/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.FilterHelper;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.jboss.logging.Logger;

public class LoaderSelectBuilder {
    private static final Logger log = Logger.getLogger(LoaderSelectBuilder.class);
    private final SqlAstCreationContext creationContext;
    private final Loadable loadable;
    private final List<? extends ModelPart> partsToSelect;
    private final ModelPart restrictedPart;
    private final DomainResult cachedDomainResult;
    private final int numberOfKeysToLoad;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final LockOptions lockOptions;
    private final Consumer<JdbcParameter> jdbcParameterConsumer;
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private Map<OrderByFragment, TableGroup> orderByFragments;

    public static SelectStatement createSelect(Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder(sessionFactory, loadable, partsToSelect, restrictedPart, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect();
    }

    public static SelectStatement createSubSelectFetchSelect(PluralAttributeMapping attributeMapping, SubselectFetch subselect, DomainResult cachedDomainResult, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder(sessionFactory, attributeMapping, null, attributeMapping.getKeyDescriptor(), cachedDomainResult, -1, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect(subselect);
    }

    private LoaderSelectBuilder(SqlAstCreationContext creationContext, Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer) {
        this.creationContext = creationContext;
        this.loadable = loadable;
        this.partsToSelect = partsToSelect;
        this.restrictedPart = restrictedPart;
        this.cachedDomainResult = cachedDomainResult;
        this.numberOfKeysToLoad = numberOfKeysToLoad;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.entityGraphTraversalState = loadQueryInfluencers != null && loadQueryInfluencers.getEffectiveEntityGraph() != null && loadQueryInfluencers.getEffectiveEntityGraph().getSemantic() != null ? new StandardEntityGraphTraversalStateImpl(loadQueryInfluencers.getEffectiveEntityGraph()) : null;
        this.lockOptions = lockOptions != null ? lockOptions : LockOptions.NONE;
        this.jdbcParameterConsumer = jdbcParameterConsumer;
    }

    private SelectStatement generateSelect() {
        List<DomainResult> domainResults;
        NavigablePath rootNavigablePath = new NavigablePath(this.loadable.getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), this.lockOptions, this::visitFetches, this.numberOfKeysToLoad > 1, this.creationContext);
        TableGroup rootTableGroup = this.loadable.createRootTableGroup(rootNavigablePath, null, true, this.lockOptions.getLockMode(), sqlAstCreationState.getSqlAliasBaseManager(), sqlAstCreationState.getSqlExpressionResolver(), () -> rootQuerySpec::applyPredicate, this.creationContext);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(rootNavigablePath, rootTableGroup);
        if (this.partsToSelect != null && !this.partsToSelect.isEmpty()) {
            domainResults = new ArrayList<DomainResult>(this.partsToSelect.size());
            for (ModelPart modelPart : this.partsToSelect) {
                NavigablePath navigablePath = rootNavigablePath.append(modelPart.getPartName());
                domainResults.add(modelPart.createDomainResult(navigablePath, rootTableGroup, null, sqlAstCreationState));
            }
        } else {
            DomainResult domainResult = this.cachedDomainResult != null ? this.cachedDomainResult : this.loadable.createDomainResult(rootNavigablePath, rootTableGroup, null, sqlAstCreationState);
            domainResults = Collections.singletonList(domainResult);
        }
        int numberOfKeyColumns = this.restrictedPart.getJdbcTypeCount(this.creationContext.getDomainModel().getTypeConfiguration());
        this.applyKeyRestriction(rootQuerySpec, rootNavigablePath, rootTableGroup, this.restrictedPart, numberOfKeyColumns, this.jdbcParameterConsumer, sqlAstCreationState);
        if (this.loadable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.loadable;
            this.applyFiltering(rootQuerySpec, rootTableGroup, pluralAttributeMapping);
            this.applyOrdering(rootTableGroup, pluralAttributeMapping);
        }
        if (this.orderByFragments != null) {
            this.orderByFragments.forEach((orderByFragment, tableGroup) -> orderByFragment.apply(rootQuerySpec, (TableGroup)tableGroup, sqlAstCreationState));
        }
        return new SelectStatement(rootQuerySpec, domainResults);
    }

    private void applyKeyRestriction(QuerySpec rootQuerySpec, NavigablePath rootNavigablePath, TableGroup rootTableGroup, ModelPart keyPart, int numberOfKeyColumns, Consumer<JdbcParameter> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState) {
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        if (numberOfKeyColumns == 1) {
            assert (keyPart instanceof BasicValuedModelPart);
            BasicValuedModelPart basicKeyPart = (BasicValuedModelPart)keyPart;
            JdbcMapping jdbcMapping2 = basicKeyPart.getJdbcMapping();
            String tableExpression = basicKeyPart.getContainingTableExpression();
            String columnExpression2 = basicKeyPart.getMappedColumnExpression();
            TableReference tableReference = rootTableGroup.resolveTableReference(tableExpression);
            ColumnReference columnRef = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression2), p -> new ColumnReference(tableReference, columnExpression2, jdbcMapping2, this.creationContext.getSessionFactory()));
            if (this.numberOfKeysToLoad == 1) {
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping2);
                jdbcParameterConsumer.accept(jdbcParameter);
                rootQuerySpec.applyPredicate(new ComparisonPredicate(columnRef, ComparisonOperator.EQUAL, jdbcParameter));
            } else {
                InListPredicate predicate = new InListPredicate(columnRef);
                for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                    for (int j = 0; j < numberOfKeyColumns; ++j) {
                        JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(columnRef.getJdbcMapping());
                        jdbcParameterConsumer.accept(jdbcParameter);
                        predicate.addExpression(jdbcParameter);
                    }
                }
                rootQuerySpec.applyPredicate(predicate);
            }
        } else {
            ArrayList columnReferences = new ArrayList(numberOfKeyColumns);
            keyPart.visitColumns((containingTableExpression, columnExpression, jdbcMapping) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(containingTableExpression);
                columnReferences.add((ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), p -> new ColumnReference(tableReference, columnExpression, jdbcMapping, this.creationContext.getSessionFactory())));
            });
            SqlTuple tuple = new SqlTuple(columnReferences, keyPart);
            InListPredicate predicate = new InListPredicate(tuple);
            for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                ArrayList<JdbcParameterImpl> tupleParams = new ArrayList<JdbcParameterImpl>(numberOfKeyColumns);
                for (int j = 0; j < numberOfKeyColumns; ++j) {
                    ColumnReference columnReference = (ColumnReference)columnReferences.get(j);
                    JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(columnReference.getJdbcMapping());
                    jdbcParameterConsumer.accept(jdbcParameter);
                    tupleParams.add(jdbcParameter);
                }
                SqlTuple paramTuple = new SqlTuple(tupleParams, keyPart);
                predicate.addExpression(paramTuple);
            }
            rootQuerySpec.applyPredicate(predicate);
        }
    }

    private void applyFiltering(QuerySpec querySpec, TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping) {
        Joinable joinable = pluralAttributeMapping.getCollectionDescriptor().getCollectionType().getAssociatedJoinable(this.creationContext.getSessionFactory());
        assert (joinable instanceof AbstractCollectionPersister);
        String tableExpression = joinable.getTableName();
        String tableAlias = tableGroup.resolveTableReference(tableExpression).getIdentificationVariable();
        FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.loadQueryInfluencers, joinable, tableAlias);
        if (filterPredicate != null) {
            querySpec.applyPredicate(filterPredicate);
        }
    }

    private void applyOrdering(TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping) {
        if (pluralAttributeMapping.getOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getOrderByFragment());
        }
        if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getManyToManyOrderByFragment());
        }
    }

    private void applyOrdering(TableGroup tableGroup, OrderByFragment orderByFragment) {
        if (this.orderByFragments == null) {
            this.orderByFragments = new LinkedHashMap<OrderByFragment, TableGroup>();
        }
        this.orderByFragments.put(orderByFragment, tableGroup);
    }

    private List<Fetch> visitFetches(FetchParent fetchParent, QuerySpec querySpec, LoaderSqlAstCreationState creationState) {
        log.tracef("Starting visitation of FetchParent's Fetchables : %s", (Object)fetchParent.getNavigablePath());
        ArrayList<Fetch> fetches = new ArrayList<Fetch>();
        BiConsumer<Fetchable, Boolean> processor = this.createFetchableBiConsumer(fetchParent, querySpec, creationState, fetches);
        FetchableContainer referencedMappingContainer = fetchParent.getReferencedMappingContainer();
        if (fetchParent.getNavigablePath().getParent() != null) {
            referencedMappingContainer.visitKeyFetchables(fetchable -> processor.accept((Fetchable)fetchable, true), null);
        }
        referencedMappingContainer.visitFetchables(fetchable -> processor.accept((Fetchable)fetchable, false), null);
        return fetches;
    }

    private BiConsumer<Fetchable, Boolean> createFetchableBiConsumer(FetchParent fetchParent, QuerySpec querySpec, LoaderSqlAstCreationState creationState, List<Fetch> fetches) {
        return (fetchable, isKeyFetchable) -> {
            NavigablePath fetchablePath;
            Fetch biDirectionalFetch;
            NavigablePath navigablePath = fetchParent.getNavigablePath();
            if (isKeyFetchable.booleanValue()) {
                navigablePath = navigablePath.append("{id}");
            }
            if ((biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath = navigablePath.append(fetchable.getFetchableName()), fetchParent, creationState)) != null) {
                fetches.add(biDirectionalFetch);
                return;
            }
            LockMode lockMode = LockMode.READ;
            FetchTiming fetchTiming = fetchable.getMappedFetchStrategy().getTiming();
            boolean joined = fetchable.getMappedFetchStrategy().getStyle() == FetchStyle.JOIN;
            EntityGraphTraversalState.TraversalResult traversalResult = null;
            if (this.entityGraphTraversalState != null) {
                traversalResult = this.entityGraphTraversalState.traverse(fetchParent, (Fetchable)fetchable, (boolean)isKeyFetchable);
                fetchTiming = traversalResult.getFetchStrategy();
                joined = traversalResult.isJoined();
            } else if (this.loadQueryInfluencers.hasEnabledFetchProfiles() && fetchParent instanceof EntityResultGraphNode) {
                EntityResultGraphNode entityFetchParent = (EntityResultGraphNode)fetchParent;
                EntityMappingType entityMappingType = entityFetchParent.getEntityValuedModelPart().getEntityMappingType();
                String fetchParentEntityName = entityMappingType.getEntityName();
                String fetchableRole = fetchParentEntityName + "." + fetchable.getFetchableName();
                for (String enabledFetchProfileName : this.loadQueryInfluencers.getEnabledFetchProfileNames()) {
                    FetchProfile enabledFetchProfile = this.creationContext.getSessionFactory().getFetchProfile(enabledFetchProfileName);
                    org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                    fetchTiming = FetchTiming.IMMEDIATE;
                    joined = joined || profileFetch.getStyle() == Fetch.Style.JOIN;
                }
            }
            Integer maximumFetchDepth = this.creationContext.getMaximumFetchDepth();
            if (maximumFetchDepth != null) {
                if (this.fetchDepth == maximumFetchDepth) {
                    joined = false;
                } else if (this.fetchDepth > maximumFetchDepth) {
                    return;
                }
            }
            try {
                if (!(fetchable instanceof BasicValuedModelPart)) {
                    ++this.fetchDepth;
                }
                Fetch fetch = fetchable.generateFetch(fetchParent, fetchablePath, fetchTiming, joined, lockMode, null, creationState);
                fetches.add(fetch);
                if (fetchable instanceof PluralAttributeMapping && fetchTiming == FetchTiming.IMMEDIATE && joined) {
                    PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                    this.applyFiltering(querySpec, creationState.getFromClauseAccess().getTableGroup(fetchablePath), pluralAttributeMapping);
                    this.applyOrdering(querySpec, fetchablePath, pluralAttributeMapping, creationState);
                }
            }
            finally {
                if (!(fetchable instanceof BasicValuedModelPart)) {
                    --this.fetchDepth;
                }
                if (this.entityGraphTraversalState != null) {
                    this.entityGraphTraversalState.backtrack(traversalResult.getPreviousContext());
                }
            }
        };
    }

    private void applyOrdering(QuerySpec ast, NavigablePath navigablePath, PluralAttributeMapping pluralAttributeMapping, LoaderSqlAstCreationState sqlAstCreationState) {
        assert (pluralAttributeMapping.getAttributeName().equals(navigablePath.getLocalName()));
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(navigablePath);
        assert (tableGroup != null);
        this.applyOrdering(tableGroup, pluralAttributeMapping);
    }

    private SelectStatement generateSelect(SubselectFetch subselect) {
        assert (this.loadable instanceof PluralAttributeMapping);
        PluralAttributeMapping attributeMapping = (PluralAttributeMapping)this.loadable;
        QuerySpec rootQuerySpec = new QuerySpec(true);
        NavigablePath rootNavigablePath = new NavigablePath(this.loadable.getRootPathName());
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), this.lockOptions, this::visitFetches, this.numberOfKeysToLoad > 1, this.creationContext);
        TableGroup rootTableGroup = this.loadable.createRootTableGroup(rootNavigablePath, null, true, this.lockOptions.getLockMode(), sqlAstCreationState.getSqlAliasBaseManager(), sqlAstCreationState.getSqlExpressionResolver(), () -> rootQuerySpec::applyPredicate, this.creationContext);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(rootNavigablePath, rootTableGroup);
        this.applySubSelectRestriction(rootQuerySpec, rootNavigablePath, rootTableGroup, subselect, sqlAstCreationState);
        this.applyFiltering(rootQuerySpec, rootTableGroup, attributeMapping);
        this.applyOrdering(rootTableGroup, attributeMapping);
        subselect.getLoadingJdbcParameters().forEach(this.jdbcParameterConsumer);
        return new SelectStatement(rootQuerySpec, Collections.singletonList(new CollectionDomainResult(rootNavigablePath, attributeMapping, null, rootTableGroup, sqlAstCreationState)));
    }

    private void applySubSelectRestriction(QuerySpec querySpec, NavigablePath rootNavigablePath, TableGroup rootTableGroup, SubselectFetch subselect, LoaderSqlAstCreationState sqlAstCreationState) {
        Expression fkExpression;
        SqlAstCreationContext sqlAstCreationContext = sqlAstCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = sqlAstCreationContext.getSessionFactory();
        assert (this.loadable instanceof PluralAttributeMapping);
        assert (this.restrictedPart == null || this.restrictedPart instanceof ForeignKeyDescriptor);
        PluralAttributeMapping attributeMapping = (PluralAttributeMapping)this.loadable;
        ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
        int jdbcTypeCount = fkDescriptor.getJdbcTypeCount(sessionFactory.getTypeConfiguration());
        if (jdbcTypeCount == 1) {
            assert (fkDescriptor instanceof SimpleForeignKeyDescriptor);
            SimpleForeignKeyDescriptor simpleFkDescriptor = (SimpleForeignKeyDescriptor)fkDescriptor;
            fkExpression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(simpleFkDescriptor.getContainingTableExpression(), simpleFkDescriptor.getMappedColumnExpression()), sqlAstProcessingState -> new ColumnReference(rootTableGroup.resolveTableReference(simpleFkDescriptor.getContainingTableExpression()), simpleFkDescriptor.getMappedColumnExpression(), simpleFkDescriptor.getJdbcMapping(), this.creationContext.getSessionFactory()));
        } else {
            ArrayList columnReferences = new ArrayList(jdbcTypeCount);
            fkDescriptor.visitColumns((containingTableExpression, columnExpression, jdbcMapping) -> columnReferences.add((ColumnReference)sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(containingTableExpression, columnExpression), sqlAstProcessingState -> new ColumnReference(rootTableGroup.resolveTableReference(containingTableExpression), columnExpression, jdbcMapping, this.creationContext.getSessionFactory()))));
            fkExpression = new SqlTuple(columnReferences, fkDescriptor);
        }
        querySpec.applyPredicate(new InSubQueryPredicate(fkExpression, this.generateSubSelect(attributeMapping, rootTableGroup, subselect, jdbcTypeCount, sqlAstCreationState, sessionFactory), false));
    }

    private QuerySpec generateSubSelect(PluralAttributeMapping attributeMapping, TableGroup rootTableGroup, SubselectFetch subselect, int jdbcTypeCount, LoaderSqlAstCreationState creationState, SessionFactoryImplementor sessionFactory) {
        ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
        QuerySpec subQuery = new QuerySpec(false);
        QuerySpec loadingSqlAst = subselect.getLoadingSqlAst();
        TableGroup ownerTableGroup = subselect.getOwnerTableGroup();
        loadingSqlAst.getFromClause().visitRoots(subQuery.getFromClause()::addRoot);
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        AtomicInteger count = new AtomicInteger();
        fkDescriptor.visitTargetColumns((containingTableExpression, columnExpression, jdbcMapping) -> {
            TableReference tableReference = ownerTableGroup.resolveTableReference(containingTableExpression);
            Expression expression = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), sqlAstProcessingState -> new ColumnReference(tableReference, columnExpression, jdbcMapping, sessionFactory));
            int valuesPosition = count.getAndIncrement();
            subQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(valuesPosition + 1, valuesPosition, expression));
        });
        subQuery.applyPredicate(loadingSqlAst.getWhereClauseRestrictions());
        return subQuery;
    }
}

