/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Collections;
import java.util.List;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.Limit;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.sql.internal.SqlAstQuerySpecProcessingStateImpl;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;

public class LoaderSqlAstCreationState
implements SqlAstProcessingState,
SqlAstCreationState,
DomainResultCreationState,
QueryOptions {
    private final QuerySpec querySpec;
    private final SqlAliasBaseManager sqlAliasBaseManager;
    private boolean forceIdentifierSelection;
    private final SqlAstCreationContext sf;
    private final SqlAstQuerySpecProcessingStateImpl processingState;
    private final FromClauseAccess fromClauseAccess;
    private final LockOptions lockOptions;
    private final FetchProcessor fetchProcessor;

    public LoaderSqlAstCreationState(QuerySpec querySpec, SqlAliasBaseManager sqlAliasBaseManager, FromClauseAccess fromClauseAccess, LockOptions lockOptions, FetchProcessor fetchProcessor, boolean forceIdentifierSelection, SqlAstCreationContext sf) {
        this.querySpec = querySpec;
        this.sqlAliasBaseManager = sqlAliasBaseManager;
        this.fromClauseAccess = fromClauseAccess;
        this.lockOptions = lockOptions;
        this.fetchProcessor = fetchProcessor;
        this.forceIdentifierSelection = forceIdentifierSelection;
        this.sf = sf;
        this.processingState = new SqlAstQuerySpecProcessingStateImpl(querySpec, this, this, () -> Clause.IRRELEVANT);
    }

    public LoaderSqlAstCreationState(QuerySpec querySpec, SqlAliasBaseManager sqlAliasBaseManager, LockOptions lockOptions, SessionFactoryImplementor sf) {
        this(querySpec, sqlAliasBaseManager, new FromClauseIndex(), lockOptions, (fetchParent, ast, state) -> Collections.emptyList(), true, sf);
    }

    public QuerySpec getQuerySpec() {
        return this.querySpec;
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.sf;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.processingState;
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseAccess;
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        return this.lockOptions.getEffectiveLockMode(identificationVariable);
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        return this.fetchProcessor.visitFetches(fetchParent, this.getQuerySpec(), this);
    }

    @Override
    public boolean forceIdentifierSelection() {
        return this.forceIdentifierSelection;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.fromClauseAccess.findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return null;
    }

    @Override
    public Integer getTimeout() {
        return null;
    }

    @Override
    public FlushMode getFlushMode() {
        return null;
    }

    @Override
    public Boolean isReadOnly() {
        return null;
    }

    @Override
    public AppliedGraph getAppliedGraph() {
        return null;
    }

    @Override
    public TupleTransformer getTupleTransformer() {
        return null;
    }

    @Override
    public ResultListTransformer getResultListTransformer() {
        return null;
    }

    @Override
    public Boolean isResultCachingEnabled() {
        return false;
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return CacheRetrieveMode.BYPASS;
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return CacheStoreMode.BYPASS;
    }

    @Override
    public String getResultCacheRegionName() {
        return null;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public List<String> getDatabaseHints() {
        return null;
    }

    @Override
    public Integer getFetchSize() {
        return null;
    }

    @Override
    public Limit getLimit() {
        return null;
    }

    private static class FromClauseIndex
    implements FromClauseAccess {
        private TableGroup tableGroup;

        private FromClauseIndex() {
        }

        @Override
        public TableGroup findTableGroup(NavigablePath navigablePath) {
            if (this.tableGroup != null) {
                if (this.tableGroup.getNavigablePath().equals(navigablePath)) {
                    return this.tableGroup;
                }
                if (this.tableGroup.getNavigablePath().getIdentifierForTableGroup().equals(navigablePath.getIdentifierForTableGroup())) {
                    return this.tableGroup;
                }
                throw new IllegalArgumentException("NavigablePath [" + navigablePath + "] did not match base TableGroup [" + this.tableGroup.getNavigablePath() + "]");
            }
            return null;
        }

        @Override
        public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
            assert (tableGroup.getNavigablePath().equals(navigablePath));
            if (this.tableGroup != null) {
                if (this.tableGroup != tableGroup) {
                    throw new IllegalArgumentException("Base TableGroup [" + tableGroup.getNavigablePath() + "] already set - " + navigablePath);
                }
                assert (this.tableGroup.getNavigablePath().equals(navigablePath));
            } else {
                this.tableGroup = tableGroup;
            }
        }
    }

    static interface FetchProcessor {
        public List<Fetch> visitFetches(FetchParent var1, QuerySpec var2, LoaderSqlAstCreationState var3);
    }
}

