/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class NaturalIdLoaderStandardImpl<T>
implements NaturalIdLoader<T> {
    private final EntityPersister entityDescriptor;
    private final NaturalIdMapping naturalIdMapping;

    public NaturalIdLoaderStandardImpl(EntityPersister entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
        this.naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (!entityDescriptor.hasNaturalIdentifier()) {
            throw new HibernateException("Entity does not define natural-id : " + entityDescriptor.getEntityName());
        }
    }

    @Override
    public EntityPersister getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object naturalIdToLoad, NaturalIdLoader.LoadOptions options, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList jdbcParameters = new ArrayList();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect(this.entityDescriptor, Collections.emptyList(), this.naturalIdMapping, null, 1, session.getLoadQueryInfluencers(), LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(sqlSelect);
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        Iterator jdbcParamItr = jdbcParameters.iterator();
        for (int i = 0; i < this.naturalIdMapping.getNaturalIdAttributes().size(); ++i) {
            SingularAttributeMapping attrMapping = this.naturalIdMapping.getNaturalIdAttributes().get(i);
            attrMapping.visitJdbcValues(naturalIdToLoad, Clause.WHERE, (jdbcValue, jdbcMapping) -> {
                assert (jdbcParamItr.hasNext());
                JdbcParameter jdbcParam = (JdbcParameter)jdbcParamItr.next();
                jdbcParamBindings.addBinding(jdbcParam, new JdbcParameterBinding(){

                    @Override
                    public JdbcMapping getBindType() {
                        return jdbcMapping;
                    }

                    @Override
                    public Object getBindValue() {
                        return jdbcValue;
                    }
                });
            }, session);
        }
        List<Object> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row[0], true);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Loading by natural-id returned more that one row : %s", this.entityDescriptor.getEntityName()));
        }
        return (T)results.get(0);
    }

    @Override
    public Object[] resolveIdToNaturalId(Object id, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList jdbcParameters = new ArrayList();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect(this.entityDescriptor, this.naturalIdMapping.getNaturalIdAttributes(), this.entityDescriptor.getIdentifierMapping(), null, 1, session.getLoadQueryInfluencers(), LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(sqlSelect);
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        Iterator jdbcParamItr = jdbcParameters.iterator();
        this.entityDescriptor.getIdentifierMapping().visitJdbcValues(id, Clause.WHERE, (value, type) -> {
            assert (jdbcParamItr.hasNext());
            JdbcParameter jdbcParam = (JdbcParameter)jdbcParamItr.next();
            jdbcParamBindings.addBinding(jdbcParam, new JdbcParameterBinding(){

                @Override
                public JdbcMapping getBindType() {
                    return type;
                }

                @Override
                public Object getBindValue() {
                    return value;
                }
            });
        }, session);
        List<Object[]> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row, true);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Resolving id to natural-id returned more that one row : %s #%s", this.entityDescriptor.getEntityName(), id));
        }
        return results.get(0);
    }

    @Override
    public Object resolveNaturalIdToId(Object[] naturalIdValues, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList jdbcParameters = new ArrayList();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect(this.entityDescriptor, Collections.singletonList(this.entityDescriptor.getIdentifierMapping()), this.naturalIdMapping, null, 1, session.getLoadQueryInfluencers(), LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(sqlSelect);
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        Iterator jdbcParamItr = jdbcParameters.iterator();
        for (int i = 0; i < this.naturalIdMapping.getNaturalIdAttributes().size(); ++i) {
            SingularAttributeMapping attrMapping = this.naturalIdMapping.getNaturalIdAttributes().get(i);
            attrMapping.visitJdbcValues(naturalIdValues[i], Clause.WHERE, (jdbcValue, jdbcMapping) -> {
                assert (jdbcParamItr.hasNext());
                jdbcParamBindings.addBinding((JdbcParameter)jdbcParamItr.next(), new JdbcParameterBinding(){

                    @Override
                    public JdbcMapping getBindType() {
                        return jdbcMapping;
                    }

                    @Override
                    public Object getBindValue() {
                        return jdbcValue;
                    }
                });
            }, session);
        }
        assert (!jdbcParamItr.hasNext());
        List<Object[]> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row, true);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Resolving natural-id to id returned more that one row : %s [%s]", this.entityDescriptor.getEntityName(), StringHelper.join(", ", naturalIdValues)));
        }
        return results.get(0);
    }
}

