/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderStandardImpl;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderSupport;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.jboss.logging.Logger;

public class SingleIdEntityLoaderDynamicBatch<T>
extends SingleIdEntityLoaderSupport<T> {
    private static final Logger log = Logger.getLogger(SingleIdEntityLoaderDynamicBatch.class);
    private final int maxBatchSize;
    private SingleIdEntityLoaderStandardImpl<T> singleIdLoader;

    public SingleIdEntityLoaderDynamicBatch(EntityMappingType entityDescriptor, int maxBatchSize, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, final Boolean readOnly, final SharedSessionContractImplementor session) {
        int i;
        Object[] batchIds = session.getPersistenceContextInternal().getBatchFetchQueue().getBatchLoadableEntityIds(this.getLoadable(), pkValue, this.maxBatchSize);
        int numberOfIds = ArrayHelper.countNonNull(batchIds);
        if (numberOfIds <= 1) {
            this.initializeSingleIdLoaderIfNeeded(session);
            T result = this.singleIdLoader.load(pkValue, lockOptions, readOnly, session);
            if (result == null) {
                BatchFetchQueueHelper.removeBatchLoadableEntityKey(pkValue, this.getLoadable(), session);
            }
            return result;
        }
        Object[] idsToLoad = new Object[numberOfIds];
        System.arraycopy(batchIds, 0, idsToLoad, 0, numberOfIds);
        if (log.isDebugEnabled()) {
            log.debugf("Batch loading entity [%s] : %s", (Object)this.getLoadable().getEntityName(), (Object)idsToLoad);
        }
        ArrayList jdbcParameters = new ArrayList();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect(this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, numberOfIds, session.getLoadQueryInfluencers(), lockOptions, jdbcParameters::add, session.getFactory());
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(sqlAst);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.getLoadable().getIdentifierMapping().getJdbcTypeCount(sessionFactory.getTypeConfiguration()));
        for (i = 0; i < numberOfIds; ++i) {
            Iterator paramItr = jdbcParameters.iterator();
            this.getLoadable().getIdentifierMapping().visitJdbcValues(idsToLoad[i], Clause.WHERE, (value, type) -> {
                assert (paramItr.hasNext());
                JdbcParameter parameter = (JdbcParameter)paramItr.next();
                jdbcParameterBindings.addBinding(parameter, new JdbcParameterBinding(){

                    @Override
                    public JdbcMapping getBindType() {
                        return type;
                    }

                    @Override
                    public Object getBindValue() {
                        return value;
                    }
                });
            }, session);
            assert (!paramItr.hasNext());
        }
        JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return new QueryOptionsAdapter(){

                    @Override
                    public Boolean isReadOnly() {
                        return readOnly;
                    }
                };
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerPassThruImpl.instance(), true);
        for (i = 0; i < idsToLoad.length; ++i) {
            Object id = idsToLoad[i];
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, this.getLoadable(), session);
        }
        EntityKey entityKey = session.generateEntityKey(pkValue, this.getLoadable().getEntityPersister());
        return (T)session.getPersistenceContext().getEntity(entityKey);
    }

    @Override
    public T load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        this.initializeSingleIdLoaderIfNeeded(session);
        return this.singleIdLoader.load(pkValue, entityInstance, lockOptions, readOnly, session);
    }

    private void initializeSingleIdLoaderIfNeeded(SharedSessionContractImplementor session) {
        if (this.singleIdLoader == null) {
            this.singleIdLoader = new SingleIdEntityLoaderStandardImpl(this.getLoadable(), session.getFactory());
            this.singleIdLoader.prepare();
        }
    }
}

