/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.DatabaseSnapshotExecutor;
import org.hibernate.loader.ast.spi.SingleIdEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;

public abstract class SingleIdEntityLoaderSupport<T>
implements SingleIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private DatabaseSnapshotExecutor databaseSnapshotExecutor;

    public SingleIdEntityLoaderSupport(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public Object[] loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        if (this.databaseSnapshotExecutor == null) {
            this.databaseSnapshotExecutor = new DatabaseSnapshotExecutor(this.entityDescriptor, this.sessionFactory);
        }
        return this.databaseSnapshotExecutor.loadDatabaseSnapshot(id, session);
    }
}

