/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Iterator;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.SingleEntityLoadPlan;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;

public class SingleIdLoadPlan<T>
implements SingleEntityLoadPlan {
    private final ModelPart restrictivePart;
    private final SelectStatement sqlAst;
    private final List<JdbcParameter> jdbcParameters;

    public SingleIdLoadPlan(ModelPart restrictivePart, SelectStatement sqlAst, List<JdbcParameter> jdbcParameters) {
        this.restrictivePart = restrictivePart;
        this.sqlAst = sqlAst;
        this.jdbcParameters = jdbcParameters;
    }

    @Override
    public Loadable getLoadable() {
        return null;
    }

    @Override
    public ModelPart getRestrictivePart() {
        return this.restrictivePart;
    }

    @Override
    public SelectStatement getSqlAst() {
        return this.sqlAst;
    }

    T load(Object restrictedValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, lockOptions, null, readOnly, session);
    }

    T load(Object restrictedValue, LockOptions lockOptions, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, lockOptions, null, null, session);
    }

    T load(final Object restrictedValue, LockOptions lockOptions, final Object entityInstance, final Boolean readOnly, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(this.sqlAst);
        int jdbcTypeCount = this.restrictivePart.getJdbcTypeCount(sessionFactory.getTypeConfiguration());
        assert (this.jdbcParameters.size() % jdbcTypeCount == 0);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcTypeCount);
        jdbcSelect.registerFilterJdbcParameterBindings(jdbcParameterBindings);
        Iterator<JdbcParameter> paramItr = this.jdbcParameters.iterator();
        while (paramItr.hasNext()) {
            this.restrictivePart.visitJdbcValues(restrictedValue, Clause.WHERE, (value, type) -> {
                assert (paramItr.hasNext());
                JdbcParameter parameter = (JdbcParameter)paramItr.next();
                jdbcParameterBindings.addBinding(parameter, new JdbcParameterBinding(){

                    @Override
                    public JdbcMapping getBindType() {
                        return type;
                    }

                    @Override
                    public Object getBindValue() {
                        return value;
                    }
                });
            }, session);
        }
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public Object getEntityInstance() {
                return entityInstance;
            }

            @Override
            public Object getEntityId() {
                return restrictedValue;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return new QueryOptionsAdapter(){

                    @Override
                    public Boolean isReadOnly() {
                        return readOnly;
                    }
                };
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, RowTransformerPassThruImpl.instance(), true);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

