/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Map;
import java.util.function.Function;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.hibernate.MappingException;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.boot.model.process.internal.NamedBasicTypeResolution;
import org.hibernate.boot.model.process.internal.NamedConverterResolution;
import org.hibernate.boot.model.process.internal.VersionResolution;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValue
extends SimpleValue
implements SqlTypeDescriptorIndicators {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(BasicValue.class);
    private final MetadataBuildingContext buildingContext;
    private final TypeConfiguration typeConfiguration;
    private final int preferredJdbcTypeCodeForBoolean;
    private String explicitTypeName;
    private Map explicitLocalTypeParams;
    private Function<TypeConfiguration, BasicJavaDescriptor> explicitJavaTypeAccess;
    private Function<TypeConfiguration, SqlTypeDescriptor> explicitSqlTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess;
    private Function<TypeConfiguration, Class> implicitJavaTypeAccess;
    private boolean isNationalized;
    private boolean isLob;
    private EnumType enumerationStyle;
    private TemporalType temporalPrecision;
    private ConverterDescriptor attributeConverterDescriptor;
    private Class resolvedJavaClass;
    private String ownerName;
    private String propertyName;
    private Selectable column;
    private Resolution<?> resolution;

    public BasicValue(MetadataBuildingContext buildingContext) {
        this(buildingContext, null);
    }

    public BasicValue(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
        this.buildingContext = buildingContext;
        this.typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        this.preferredJdbcTypeCodeForBoolean = buildingContext.getPreferredSqlTypeCodeForBoolean();
        buildingContext.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    @Override
    public MetadataBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.buildingContext.getBootstrapContext().getServiceRegistry();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.resolution != null) {
            throw new IllegalStateException("BasicValue already resolved");
        }
        this.ownerName = className;
        this.propertyName = propertyName;
        super.setTypeUsingReflection(className, propertyName);
    }

    public void setEnumerationStyle(EnumType enumerationStyle) {
        this.enumerationStyle = enumerationStyle;
    }

    public EnumType getEnumerationStyle() {
        return this.enumerationStyle;
    }

    @Override
    public ConverterDescriptor getJpaAttributeConverterDescriptor() {
        return this.attributeConverterDescriptor;
    }

    @Override
    public void setJpaAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.attributeConverterDescriptor = descriptor;
        super.setJpaAttributeConverterDescriptor(descriptor);
    }

    public void setExplicitJavaTypeAccess(Function<TypeConfiguration, BasicJavaDescriptor> explicitJavaTypeAccess) {
        this.explicitJavaTypeAccess = explicitJavaTypeAccess;
    }

    public void setExplicitSqlTypeAccess(Function<TypeConfiguration, SqlTypeDescriptor> sqlTypeAccess) {
        this.explicitSqlTypeAccess = sqlTypeAccess;
    }

    public void setExplicitMutabilityPlanAccess(Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess) {
        this.explicitMutabilityPlanAccess = explicitMutabilityPlanAccess;
    }

    public void setImplicitJavaTypeAccess(Function<TypeConfiguration, Class> implicitJavaTypeAccess) {
        this.implicitJavaTypeAccess = implicitJavaTypeAccess;
    }

    public Selectable getColumn() {
        return this.column;
    }

    @Override
    public void addColumn(Column incomingColumn) {
        super.addColumn(incomingColumn);
        this.applySelectable(incomingColumn);
    }

    @Override
    public void copyTypeFrom(SimpleValue sourceValue) {
        super.copyTypeFrom(sourceValue);
        if (sourceValue instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)sourceValue;
            this.resolution = basicValue.resolution;
            this.implicitJavaTypeAccess = typeConfiguration -> basicValue.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
        }
    }

    private void applySelectable(Selectable incomingColumn) {
        if (incomingColumn == null) {
            throw new IllegalArgumentException("Incoming column was null");
        }
        if (this.column == incomingColumn) {
            log.debugf("Skipping column re-registration: " + this.getTable().getName() + "." + this.column.getText(), new Object[0]);
            return;
        }
        if (this.column != null) {
            throw new IllegalStateException("BasicValue [" + this.ownerName + "." + this.propertyName + "] already had column associated: `" + this.column.getText() + "` -> `" + incomingColumn.getText() + "`");
        }
        this.column = incomingColumn;
    }

    @Override
    public void addColumn(Column incomingColumn, boolean isInsertable, boolean isUpdatable) {
        super.addColumn(incomingColumn, isInsertable, isUpdatable);
        this.applySelectable(incomingColumn);
    }

    @Override
    public void addFormula(Formula formula) {
        super.addFormula(formula);
        this.applySelectable(formula);
    }

    @Override
    public Type getType() throws MappingException {
        this.resolve();
        assert (this.getResolution() != null);
        return this.getResolution().getLegacyResolvedBasicType();
    }

    public Resolution<?> getResolution() {
        return this.resolution;
    }

    public boolean resolve(MetadataBuildingContext buildingContext) {
        this.resolve();
        return true;
    }

    public Resolution<?> resolve() {
        if (this.resolution != null) {
            return this.resolution;
        }
        this.resolution = this.buildResolution();
        if (this.resolution == null) {
            throw new IllegalStateException("Unable to resolve BasicValue : " + this);
        }
        if (this.column instanceof Column && this.resolution.getValueConverter() == null) {
            Column physicalColumn = (Column)this.column;
            if (physicalColumn.getSqlTypeCode() == null) {
                physicalColumn.setSqlTypeCode(this.resolution.getRelationalSqlTypeDescriptor().getJdbcTypeCode());
            }
            BasicType<?> basicType = this.resolution.getLegacyResolvedBasicType();
            Dialect dialect = this.getServiceRegistry().getService(JdbcServices.class).getDialect();
            String checkConstraint = physicalColumn.getCheckConstraint();
            if (checkConstraint == null && dialect.supportsColumnCheck()) {
                physicalColumn.setCheckConstraint(basicType.getJavaTypeDescriptor().getCheckCondition(physicalColumn.getQuotedName(dialect), basicType.getSqlTypeDescriptor(), dialect));
            }
        }
        return this.resolution;
    }

    protected Resolution<?> buildResolution() {
        JavaTypeDescriptor reflectedJtd;
        Class implicitJtd;
        BasicJavaDescriptor explicitJtd;
        if (this.explicitTypeName != null) {
            return BasicValue.interpretExplicitlyNamedType(this.explicitTypeName, this.enumerationStyle, this.implicitJavaTypeAccess, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.explicitMutabilityPlanAccess, this.attributeConverterDescriptor, this.explicitLocalTypeParams, this, this.typeConfiguration, this.getBuildingContext());
        }
        if (this.isVersion()) {
            return VersionResolution.from(this.implicitJavaTypeAccess, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.typeConfiguration, this.getBuildingContext());
        }
        if (this.attributeConverterDescriptor != null) {
            final ManagedBeanRegistry managedBeanRegistry = this.getBuildingContext().getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
            JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

                @Override
                public ManagedBeanRegistry getManagedBeanRegistry() {
                    return managedBeanRegistry;
                }

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return BasicValue.this.typeConfiguration;
                }
            };
            return NamedConverterResolution.from(this.attributeConverterDescriptor, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.explicitMutabilityPlanAccess, (SqlTypeDescriptorIndicators)this, converterCreationContext, this.getBuildingContext());
        }
        JavaTypeDescriptor jtd = null;
        if (this.explicitJavaTypeAccess != null && (explicitJtd = this.explicitJavaTypeAccess.apply(this.typeConfiguration)) != null) {
            jtd = explicitJtd;
        }
        if (jtd == null && this.implicitJavaTypeAccess != null && (implicitJtd = this.implicitJavaTypeAccess.apply(this.typeConfiguration)) != null) {
            jtd = this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(implicitJtd);
        }
        if (jtd == null && (reflectedJtd = this.determineReflectedJavaTypeDescriptor()) != null) {
            jtd = reflectedJtd;
        }
        if (jtd instanceof EnumJavaTypeDescriptor) {
            return InferredBasicValueResolver.fromEnum((EnumJavaTypeDescriptor)jtd, this.explicitJavaTypeAccess.apply(this.typeConfiguration), this.explicitSqlTypeAccess.apply(this.typeConfiguration), this, this.typeConfiguration);
        }
        if (jtd instanceof TemporalJavaTypeDescriptor) {
            return InferredBasicValueResolver.fromTemporal((TemporalJavaTypeDescriptor)jtd, this.explicitJavaTypeAccess.apply(this.typeConfiguration), this.explicitSqlTypeAccess.apply(this.typeConfiguration), this, this.typeConfiguration);
        }
        return InferredBasicValueResolver.from(this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this::determineReflectedJavaTypeDescriptor, this, this.getTable(), this.column, this.ownerName, this.propertyName, this.typeConfiguration);
    }

    private JavaTypeDescriptor determineReflectedJavaTypeDescriptor() {
        Class impliedJavaType;
        if (this.resolvedJavaClass != null) {
            impliedJavaType = this.resolvedJavaClass;
        } else if (this.implicitJavaTypeAccess != null) {
            impliedJavaType = this.implicitJavaTypeAccess.apply(this.typeConfiguration);
        } else if (this.ownerName != null && this.propertyName != null) {
            ServiceRegistry serviceRegistry = this.typeConfiguration.getServiceRegistry();
            ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
            impliedJavaType = ReflectHelper.reflectedPropertyClass(this.ownerName, this.propertyName, classLoaderService);
        } else {
            impliedJavaType = null;
        }
        return impliedJavaType == null ? null : this.typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(impliedJavaType);
    }

    private static Resolution interpretExplicitlyNamedType(String name, EnumType enumerationStyle, Function<TypeConfiguration, Class> implicitJavaTypeAccess, Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, ConverterDescriptor converterDescriptor, Map localTypeParams, SqlTypeDescriptorIndicators stdIndicators, final TypeConfiguration typeConfiguration, MetadataBuildingContext context) {
        final ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return managedBeanRegistry;
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }
        };
        if (name.startsWith("converted::")) {
            return NamedConverterResolution.from(name, explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, stdIndicators, converterCreationContext, context);
        }
        BasicType basicTypeByName = typeConfiguration.getBasicTypeRegistry().getRegisteredType(name);
        if (basicTypeByName != null) {
            JavaTypeDescriptor domainJtd;
            JpaAttributeConverter valueConverter;
            if (converterDescriptor == null) {
                valueConverter = null;
                domainJtd = basicTypeByName.getJavaTypeDescriptor();
            } else {
                valueConverter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
                domainJtd = valueConverter.getDomainJavaDescriptor();
            }
            return new NamedBasicTypeResolution(domainJtd, basicTypeByName, valueConverter, explicitMutabilityPlanAccess, context);
        }
        TypeDefinition typeDefinition = context.getTypeDefinitionRegistry().resolve(name);
        if (typeDefinition != null) {
            return typeDefinition.resolve(explicitJtdAccess.apply(typeConfiguration), explicitStdAccess.apply(typeConfiguration), localTypeParams, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context);
        }
        ClassLoaderService cls = typeConfiguration.getServiceRegistry().getService(ClassLoaderService.class);
        try {
            Class typeNamedClass = cls.classForName(name);
            if (CollectionHelper.isEmpty(localTypeParams)) {
                TypeDefinition implicitDefinition = new TypeDefinition(name, typeNamedClass, null, null, typeConfiguration);
                context.getTypeDefinitionRegistry().register(implicitDefinition);
                return implicitDefinition.resolve(explicitJtdAccess != null ? (JavaTypeDescriptor)explicitJtdAccess.apply(typeConfiguration) : null, explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null, null, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context);
            }
            return TypeDefinition.createLocalResolution(name, typeNamedClass, explicitJtdAccess.apply(typeConfiguration), explicitStdAccess.apply(typeConfiguration), explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, localTypeParams, context);
        }
        catch (ClassLoadingException classLoadingException) {
            throw new MappingException("Could not resolve named type : " + name);
        }
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getEnumerationStyle();
    }

    @Override
    public boolean isNationalized() {
        return this.isNationalized;
    }

    @Override
    public boolean isLob() {
        return this.isLob;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.preferredJdbcTypeCodeForBoolean;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setExplicitTypeParams(Map explicitLocalTypeParams) {
        this.explicitLocalTypeParams = explicitLocalTypeParams;
    }

    public void setExplicitTypeName(String typeName) {
        this.explicitTypeName = typeName;
    }

    @Override
    public void setTypeName(String typeName) {
        if (StringHelper.isNotEmpty(typeName)) {
            if (typeName.startsWith("converted::")) {
                String converterClassName = typeName.substring("converted::".length());
                ClassLoaderService cls = this.getBuildingContext().getMetadataCollector().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
                try {
                    Class converterClass = cls.classForName(converterClassName);
                    this.attributeConverterDescriptor = new ClassBasedConverterDescriptor(converterClass, false, this.getBuildingContext().getBootstrapContext().getClassmateContext());
                    return;
                }
                catch (Exception e) {
                    log.logBadHbmAttributeConverterType(typeName, e.getMessage());
                }
            } else {
                this.setExplicitTypeName(typeName);
            }
        }
        super.setTypeName(typeName);
    }

    public void setTemporalPrecision(TemporalType temporalPrecision) {
        this.temporalPrecision = temporalPrecision;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public void makeLob() {
        this.isLob = true;
    }

    @Override
    public void makeNationalized() {
        this.isNationalized = true;
    }

    public static interface Resolution<J> {
        public BasicType<J> getLegacyResolvedBasicType();

        public JdbcMapping getJdbcMapping();

        public JavaTypeDescriptor<J> getDomainJavaDescriptor();

        public JavaTypeDescriptor<?> getRelationalJavaDescriptor();

        public SqlTypeDescriptor getRelationalSqlTypeDescriptor();

        public BasicValueConverter getValueConverter();

        public MutabilityPlan<J> getMutabilityPlan();
    }
}

