/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.StandardMapEmbeddableRepresentationStrategy;
import org.hibernate.metamodel.internal.StandardMapEntityRepresentationStrategy;
import org.hibernate.metamodel.internal.StandardPojoEmbeddableRepresentationStrategy;
import org.hibernate.metamodel.internal.StandardPojoEntityRepresentationStrategy;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;

public class StandardManagedTypeRepresentationResolver
implements ManagedTypeRepresentationResolver {
    public static final StandardManagedTypeRepresentationResolver INSTANCE = new StandardManagedTypeRepresentationResolver();

    @Override
    public EntityRepresentationStrategy resolveStrategy(PersistentClass bootDescriptor, EntityPersister runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        RepresentationMode representation = null;
        if (representation == null) {
            representation = bootDescriptor.getMappedClass() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (representation == RepresentationMode.MAP) {
            return new StandardMapEntityRepresentationStrategy(bootDescriptor, creationContext);
        }
        return new StandardPojoEntityRepresentationStrategy(bootDescriptor, creationContext);
    }

    @Override
    public EmbeddableRepresentationStrategy resolveStrategy(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        RepresentationMode representation = null;
        if (representation == null) {
            representation = bootDescriptor.getComponentClass() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (representation == RepresentationMode.MAP) {
            return new StandardMapEmbeddableRepresentationStrategy(bootDescriptor, creationContext);
        }
        return new StandardPojoEmbeddableRepresentationStrategy(bootDescriptor, creationContext);
    }
}

