/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.OptimizedPojoInstantiatorImpl;
import org.hibernate.metamodel.internal.PojoInstantiatorImpl;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.Instantiator;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.internal.PropertyAccessBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyEmbeddedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyIndexBackRefImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.ProxyFactoryHelper;
import org.hibernate.type.CompositeType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;

public class StandardPojoEntityRepresentationStrategy
implements EntityRepresentationStrategy {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(StandardPojoEntityRepresentationStrategy.class);
    private final JavaTypeDescriptor<?> mappedJtd;
    private final JavaTypeDescriptor<?> proxyJtd;
    private final boolean isBytecodeEnhanced;
    private final boolean lifecycleImplementor;
    private final ReflectionOptimizer reflectionOptimizer;
    private final ProxyFactory proxyFactory;
    private final Instantiator instantiator;
    private final StrategySelector strategySelector;
    private final String identifierPropertyName;
    private final PropertyAccess identifierPropertyAccess;
    private final Map<String, PropertyAccess> propertyAccessMap = new ConcurrentHashMap<String, PropertyAccess>();

    public StandardPojoEntityRepresentationStrategy(PersistentClass bootDescriptor, RuntimeModelCreationContext creationContext) {
        ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer;
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        JavaTypeDescriptorRegistry jtdRegistry = creationContext.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        Class mappedJavaType = bootDescriptor.getMappedClass();
        this.mappedJtd = jtdRegistry.getDescriptor(mappedJavaType);
        Class proxyJavaType = bootDescriptor.getProxyInterface();
        this.proxyJtd = jtdRegistry.getDescriptor(proxyJavaType);
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(mappedJavaType);
        this.isBytecodeEnhanced = PersistentAttributeInterceptable.class.isAssignableFrom(mappedJavaType);
        Property identifierProperty = bootDescriptor.getIdentifierProperty();
        if (identifierProperty == null) {
            this.identifierPropertyName = null;
            this.identifierPropertyAccess = PropertyAccessStrategyEmbeddedImpl.INSTANCE.buildPropertyAccess(this.proxyJtd != null ? this.proxyJtd.getJavaType() : this.mappedJtd.getJavaType(), "id");
        } else {
            this.identifierPropertyName = identifierProperty.getName();
            this.identifierPropertyAccess = this.makePropertyAccess(identifierProperty);
        }
        BytecodeProvider bytecodeProvider = Environment.getBytecodeProvider();
        this.proxyFactory = this.createProxyFactory(bootDescriptor, bytecodeProvider, creationContext);
        this.reflectionOptimizer = this.resolveReflectionOptimizer(bootDescriptor, bytecodeProvider, sessionFactory);
        this.instantiator = this.reflectionOptimizer != null ? ((instantiationOptimizer = this.reflectionOptimizer.getInstantiationOptimizer()) != null ? new OptimizedPojoInstantiatorImpl(this.mappedJtd, instantiationOptimizer) : new PojoInstantiatorImpl(this.mappedJtd)) : new PojoInstantiatorImpl(this.mappedJtd);
        this.strategySelector = sessionFactory.getServiceRegistry().getService(StrategySelector.class);
    }

    private PropertyAccess resolveIdentifierPropertyAccess(PersistentClass bootDescriptor) {
        Property identifierProperty = bootDescriptor.getIdentifierProperty();
        if (identifierProperty == null) {
            return PropertyAccessStrategyEmbeddedImpl.INSTANCE.buildPropertyAccess(this.proxyJtd != null ? this.proxyJtd.getJavaType() : this.mappedJtd.getJavaType(), "id");
        }
        return this.makePropertyAccess(identifierProperty);
    }

    private ProxyFactory createProxyFactory(PersistentClass bootDescriptor, BytecodeProvider bytecodeProvider, RuntimeModelCreationContext creationContext) {
        LinkedHashSet<Class> proxyInterfaces = new LinkedHashSet<Class>();
        Class<?> mappedClass = this.mappedJtd.getJavaType();
        Class<?> proxyInterface = this.proxyJtd.getJavaType();
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + bootDescriptor.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        Iterator subclasses = bootDescriptor.getSubclassIterator();
        while (subclasses.hasNext()) {
            Subclass subclass = (Subclass)subclasses.next();
            Class subclassProxy = subclass.getProxyInterface();
            Class subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!subclassProxy.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subclass.getEntityName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        proxyInterfaces.add(HibernateProxy.class);
        Iterator properties = bootDescriptor.getPropertyIterator();
        Class clazz = bootDescriptor.getMappedClass();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            ProxyFactoryHelper.validateGetterSetterMethodProxyability("Getter", property.getGetter(clazz).getMethod());
            ProxyFactoryHelper.validateGetterSetterMethodProxyability("Setter", property.getSetter(clazz).getMethod());
        }
        Method idGetterMethod = this.identifierPropertyAccess == null ? null : this.identifierPropertyAccess.getGetter().getMethod();
        Method idSetterMethod = this.identifierPropertyAccess == null ? null : this.identifierPropertyAccess.getSetter().getMethod();
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        ProxyFactory pf = bytecodeProvider.getProxyFactoryFactory().buildProxyFactory(creationContext.getSessionFactory());
        try {
            pf.postInstantiate(bootDescriptor.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, bootDescriptor.hasEmbeddedIdentifier() ? (CompositeType)bootDescriptor.getIdentifier().getType() : null);
            return pf;
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(bootDescriptor.getEntityName(), he);
            return null;
        }
    }

    private ReflectionOptimizer resolveReflectionOptimizer(PersistentClass bootType, BytecodeProvider bytecodeProvider, SessionFactoryImplementor sessionFactory) {
        Class<?> javaTypeToReflect;
        if (this.proxyFactory != null) {
            assert (this.proxyJtd != null);
            javaTypeToReflect = this.proxyJtd.getJavaType();
        } else {
            javaTypeToReflect = this.mappedJtd.getJavaType();
        }
        ArrayList<String> getterNames = new ArrayList<String>();
        ArrayList<String> setterNames = new ArrayList<String>();
        ArrayList<Class> getterTypes = new ArrayList<Class>();
        boolean foundCustomAccessor = false;
        Iterator itr = bootType.getPropertyClosureIterator();
        int i = 0;
        while (itr.hasNext()) {
            Property property = (Property)itr.next();
            PropertyAccess propertyAccess = this.makePropertyAccess(property);
            this.propertyAccessMap.put(property.getName(), propertyAccess);
            if (!(propertyAccess instanceof PropertyAccessBasicImpl)) {
                foundCustomAccessor = true;
            }
            getterNames.add(propertyAccess.getGetter().getMethodName());
            getterTypes.add(propertyAccess.getGetter().getReturnType());
            setterNames.add(propertyAccess.getSetter().getMethodName());
            ++i;
        }
        if (foundCustomAccessor || !Environment.useReflectionOptimizer()) {
            return null;
        }
        return bytecodeProvider.getReflectionOptimizer(javaTypeToReflect, getterNames.toArray(new String[0]), setterNames.toArray(new String[0]), getterTypes.toArray(new Class[0]));
    }

    private PropertyAccess makePropertyAccess(Property bootAttributeDescriptor) {
        PropertyAccessStrategy strategy = null;
        String propertyAccessorName = bootAttributeDescriptor.getPropertyAccessorName();
        BuiltInPropertyAccessStrategies namedStrategy = BuiltInPropertyAccessStrategies.interpret(propertyAccessorName);
        if (namedStrategy != null) {
            strategy = namedStrategy.getStrategy();
        }
        if (strategy == null) {
            if (StringHelper.isNotEmpty(propertyAccessorName)) {
                strategy = this.strategySelector.resolveStrategy(PropertyAccessStrategy.class, propertyAccessorName);
            } else if (bootAttributeDescriptor instanceof Backref) {
                Backref backref = (Backref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyBackRefImpl(backref.getCollectionRole(), backref.getEntityName());
            } else if (bootAttributeDescriptor instanceof IndexBackref) {
                IndexBackref indexBackref = (IndexBackref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyIndexBackRefImpl(indexBackref.getCollectionRole(), indexBackref.getEntityName());
            } else {
                strategy = BuiltInPropertyAccessStrategies.MIXED.getStrategy();
            }
        }
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", this.mappedJtd.getJavaType().getName(), bootAttributeDescriptor.getName()));
        }
        return strategy.buildPropertyAccess(this.mappedJtd.getJavaType(), bootAttributeDescriptor.getName());
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return this.reflectionOptimizer;
    }

    public Instantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Override
    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    @Override
    public boolean isBytecodeEnhanced() {
        return this.isBytecodeEnhanced;
    }

    @Override
    public JavaTypeDescriptor<?> getMappedJavaTypeDescriptor() {
        return this.mappedJtd;
    }

    @Override
    public JavaTypeDescriptor<?> getProxyJavaTypeDescriptor() {
        return this.proxyJtd;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        if (bootAttributeDescriptor.getName().equals(this.identifierPropertyName)) {
            return this.identifierPropertyAccess;
        }
        return this.propertyAccessMap.get(bootAttributeDescriptor.getName());
    }
}

