/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.spi.TypeConfiguration;

public interface Bindable {
    default public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        AtomicInteger value = new AtomicInteger(0);
        this.visitJdbcTypes(sqlExpressableType -> value.incrementAndGet(), Clause.IRRELEVANT, typeConfiguration);
        return value.get();
    }

    default public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        ArrayList<JdbcMapping> results = new ArrayList<JdbcMapping>();
        this.visitJdbcTypes(results::add, Clause.IRRELEVANT, typeConfiguration);
        return results;
    }

    default public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public void visitDisassembledJdbcValues(Object value, Clause clause, JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public void visitJdbcValues(Object value, Clause clause, JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        this.visitDisassembledJdbcValues(this.disassemble(value, session), clause, valuesConsumer, session);
    }

    @FunctionalInterface
    public static interface JdbcValuesConsumer {
        public void consume(Object var1, JdbcMapping var2);
    }
}

