/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;

public class MappingModelHelper {
    public static Expression buildColumnReferenceExpression(ModelPart modelPart, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        int jdbcTypeCount = modelPart.getJdbcTypeCount(sessionFactory.getTypeConfiguration());
        if (jdbcTypeCount == 1) {
            assert (modelPart instanceof BasicValuedModelPart);
            BasicValuedModelPart basicPart = (BasicValuedModelPart)modelPart;
            if (sqlExpressionResolver == null) {
                return new ColumnReference(basicPart.getContainingTableExpression(), basicPart.getMappedColumnExpression(), basicPart.getJdbcMapping(), sessionFactory);
            }
            return sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(basicPart.getContainingTableExpression(), basicPart.getMappedColumnExpression()), sqlAstProcessingState -> new ColumnReference(basicPart.getContainingTableExpression(), basicPart.getMappedColumnExpression(), basicPart.getJdbcMapping(), sessionFactory));
        }
        ArrayList columnReferences = new ArrayList(jdbcTypeCount);
        modelPart.visitColumns((containingTableExpression, columnExpression, jdbcMapping) -> {
            ColumnReference colRef = sqlExpressionResolver == null ? new ColumnReference(containingTableExpression, columnExpression, jdbcMapping, sessionFactory) : (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(containingTableExpression, columnExpression), sqlAstProcessingState -> new ColumnReference(containingTableExpression, columnExpression, jdbcMapping, sessionFactory));
            columnReferences.add(colRef);
        });
        return new SqlTuple(columnReferences, modelPart);
    }

    private MappingModelHelper() {
    }
}

