/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicEntityIdentifierMappingImpl
implements BasicEntityIdentifierMapping {
    private final PropertyAccess propertyAccess;
    private final EntityPersister entityPersister;
    private final SessionFactoryImplementor sessionFactory;
    private final NavigableRole idRole;
    private final String rootTable;
    private final String pkColumnName;
    private final BasicType idType;

    public BasicEntityIdentifierMappingImpl(EntityPersister entityPersister, String rootTable, String pkColumnName, BasicType idType, MappingModelCreationProcess creationProcess) {
        assert (entityPersister.hasIdentifierProperty());
        assert (entityPersister.getIdentifierPropertyName() != null);
        this.rootTable = rootTable;
        this.pkColumnName = pkColumnName;
        this.idType = idType;
        this.entityPersister = entityPersister;
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        this.propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        this.idRole = entityPersister.getNavigableRole().append("{id}");
        this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.propertyAccess.getSetter().set(entity, id, session.getFactory());
    }

    @Override
    public Object instantiate() {
        return this.entityPersister.getRepresentationStrategy().getInstantiator().instantiate(this.sessionFactory);
    }

    @Override
    public MappingType getPartMappingType() {
        return this.getJdbcMapping()::getJavaTypeDescriptor;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return this.getJdbcMapping()::getJavaTypeDescriptor;
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        return 1;
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        consumer.accept(this.getContainingTableExpression(), this.getMappedColumnExpression(), this.getJdbcMapping());
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.entityPersister;
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.idType);
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(value, this.idType);
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.idRole;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableReference rootTableReference;
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        try {
            rootTableReference = tableGroup.resolveTableReference(this.rootTable);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Could not resolve table reference `%s` relative to TableGroup `%s` related with NavigablePath `%s`", this.rootTable, tableGroup, navigablePath), e);
        }
        Expression expression = expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(rootTableReference, this.pkColumnName), sqlAstProcessingState -> new ColumnReference(rootTableReference.getIdentificationVariable(), this.pkColumnName, ((BasicValuedMapping)((Object)this.entityPersister.getIdentifierType())).getJdbcMapping(), this.sessionFactory));
        SqlSelection sqlSelection = expressionResolver.resolveSqlSelection(expression, this.idType.getExpressableJavaTypeDescriptor(), this.sessionFactory.getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.entityPersister.getIdentifierMapping().getMappedTypeDescriptor().getMappedJavaTypeDescriptor(), navigablePath);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableReference rootTableReference = tableGroup.resolveTableReference(this.rootTable);
        Expression expression = expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(rootTableReference, this.pkColumnName), sqlAstProcessingState -> new ColumnReference(this.rootTable, this.pkColumnName, ((BasicValuedModelPart)((Object)this.entityPersister.getIdentifierType())).getJdbcMapping(), this.sessionFactory));
        expressionResolver.resolveSqlSelection(expression, this.idType.getExpressableJavaTypeDescriptor(), this.sessionFactory.getTypeConfiguration());
    }

    @Override
    public String getContainingTableExpression() {
        return this.rootTable;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.pkColumnName;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.idType;
    }

    @Override
    public String getFetchableName() {
        return this.entityPersister.getIdentifierPropertyName();
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return FetchStrategy.IMMEDIATE_JOIN;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new BasicFetch(0, fetchParent, fetchablePath, this, false, null, FetchTiming.IMMEDIATE, creationState);
    }
}

