/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class CollectionIdentifierDescriptorImpl
implements CollectionIdentifierDescriptor {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final String containingTableName;
    private final String columnName;
    private final BasicType type;

    public CollectionIdentifierDescriptorImpl(CollectionPersister collectionDescriptor, String containingTableName, String columnName, BasicType type) {
        this.navigableRole = collectionDescriptor.getNavigableRole().append(CollectionPart.Nature.ID.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.containingTableName = containingTableName;
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return CollectionPart.Nature.ID;
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableName;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.columnName;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.type;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.type;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return this.type;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public String getFetchableName() {
        return null;
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return null;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(fetchablePath.getParent());
        SqlAstCreationState astCreationState = creationState.getSqlAstCreationState();
        SqlAstCreationContext astCreationContext = astCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = astCreationContext.getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = astCreationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.columnName), p -> new ColumnReference(tableGroup.getPrimaryTableReference().getIdentificationVariable(), this.columnName, (JdbcMapping)this.type, sessionFactory)), this.type.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, !selected, null, FetchTiming.IMMEDIATE, creationState);
    }

    public DomainResult createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlAstCreationState astCreationState = creationState.getSqlAstCreationState();
        SqlAstCreationContext astCreationContext = astCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = astCreationContext.getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = astCreationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.columnName), p -> new ColumnReference(tableGroup.getPrimaryTableReference().getIdentificationVariable(), this.columnName, (JdbcMapping)this.type, sessionFactory)), this.type.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, this.type.getJavaTypeDescriptor(), collectionPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.collectionDescriptor.getRole() + ")";
    }
}

