/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SingularAssociationAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddedForeignKeyDescriptor
implements ForeignKeyDescriptor,
ModelPart {
    private final String keyColumnContainingTable;
    private final List<String> keyColumnExpressions;
    private final String targetColumnContainingTable;
    private final List<String> targetColumnExpressions;
    private final EmbeddableValuedModelPart mappingType;
    private final List<JdbcMapping> jdbcMappings;

    public EmbeddedForeignKeyDescriptor(EmbeddedIdentifierMappingImpl mappingType, String keyColumnContainingTable, List<String> keyColumnExpressions, String targetColumnContainingTable, List<String> targetColumnExpressions, MappingModelCreationProcess creationProcess) {
        this.keyColumnContainingTable = keyColumnContainingTable;
        this.keyColumnExpressions = keyColumnExpressions;
        this.targetColumnContainingTable = targetColumnContainingTable;
        this.targetColumnExpressions = targetColumnExpressions;
        this.mappingType = mappingType;
        this.jdbcMappings = new ArrayList<JdbcMapping>();
        mappingType.getAttributes().forEach(attribute -> {
            TypeConfiguration typeConfiguration = creationProcess.getCreationContext().getTypeConfiguration();
            if (attribute instanceof SingularAssociationAttributeMapping) {
                SingularAssociationAttributeMapping associationAttributeMapping = (SingularAssociationAttributeMapping)attribute;
                associationAttributeMapping.getAssociatedEntityMappingType().getEntityPersister().getIdentifierMapping().visitJdbcTypes(this.jdbcMappings::add, null, typeConfiguration);
            } else {
                attribute.visitJdbcTypes(this.jdbcMappings::add, null, typeConfiguration);
            }
        });
    }

    @Override
    public DomainResult createCollectionFetchDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.targetColumnContainingTable.equals(this.keyColumnContainingTable)) {
            SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
            SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
            TableReference tableReference = tableGroup.resolveTableReference(this.keyColumnContainingTable);
            String identificationVariable = tableReference.getIdentificationVariable();
            ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>();
            for (int i = 0; i < this.keyColumnExpressions.size(); ++i) {
                JdbcMapping jdbcMapping = this.jdbcMappings.get(i);
                String columnExpression = this.targetColumnExpressions.get(i);
                SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), s -> new ColumnReference(identificationVariable, columnExpression, jdbcMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), jdbcMapping.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
                sqlSelections.add(sqlSelection);
            }
            return new EmbeddableForeignKeyResultImpl(sqlSelections, collectionPath, this.mappingType, null, creationState);
        }
        return this.createDomainResult(collectionPath, tableGroup, creationState);
    }

    @Override
    public DomainResult createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(this.keyColumnContainingTable);
        String identificationVariable = tableReference.getIdentificationVariable();
        int size = this.keyColumnExpressions.size();
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(size);
        for (int i = 0; i < size; ++i) {
            String columnExpression = this.keyColumnExpressions.get(i);
            JdbcMapping jdbcMapping = this.jdbcMappings.get(i);
            SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), s -> new ColumnReference(identificationVariable, columnExpression, jdbcMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), jdbcMapping.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
            sqlSelections.add(sqlSelection);
        }
        return new EmbeddableForeignKeyResultImpl(sqlSelections, collectionPath, this.mappingType, null, creationState);
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup lhs, TableGroup tableGroup, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference rhsTableKeyReference;
        TableReference lhsTableReference;
        if (this.targetColumnContainingTable.equals(this.keyColumnContainingTable)) {
            lhsTableReference = this.getTableReferenceWhenTargetEqualsKey(lhs, tableGroup, this.keyColumnContainingTable);
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetColumnContainingTable);
        } else {
            lhsTableReference = this.getTableReference(lhs, tableGroup, this.keyColumnContainingTable);
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetColumnContainingTable);
        }
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlAstJoinType, sqlExpressionResolver, creationContext);
    }

    @Override
    public Predicate generateJoinPredicate(TableReference lhs, TableReference rhs, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        String rhsTableExpression = rhs.getTableExpression();
        String lhsTableExpression = lhs.getTableExpression();
        if (lhsTableExpression.equals(this.keyColumnContainingTable)) {
            assert (rhsTableExpression.equals(this.targetColumnContainingTable));
            return this.getPredicate(lhs, rhs, creationContext, this.keyColumnExpressions, this.targetColumnExpressions);
        }
        assert (rhsTableExpression.equals(this.keyColumnContainingTable));
        return this.getPredicate(lhs, rhs, creationContext, this.targetColumnExpressions, this.keyColumnExpressions);
    }

    private Predicate getPredicate(TableReference lhs, TableReference rhs, SqlAstCreationContext creationContext, List<String> lhsExpressions, List<String> rhsColumnExpressions) {
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        for (int i = 0; i < lhsExpressions.size(); ++i) {
            JdbcMapping jdbcMapping = this.jdbcMappings.get(i);
            ComparisonPredicate comparisonPredicate = new ComparisonPredicate(new ColumnReference(lhs, lhsExpressions.get(i), jdbcMapping, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, rhsColumnExpressions.get(i), jdbcMapping, creationContext.getSessionFactory()));
            predicate.add(comparisonPredicate);
        }
        return predicate;
    }

    protected TableReference getTableReferenceWhenTargetEqualsKey(TableGroup lhs, TableGroup tableGroup, String table) {
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : lhs.getTableReferenceJoins()) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(table)) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        TableReference tableReference = lhs.resolveTableReference(table);
        if (tableReference != null) {
            return tableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public String getReferringTableExpression() {
        return this.keyColumnContainingTable;
    }

    @Override
    public String getTargetTableExpression() {
        return this.targetColumnContainingTable;
    }

    @Override
    public void visitReferringColumns(ColumnConsumer consumer) {
        for (int i = 0; i < this.keyColumnExpressions.size(); ++i) {
            consumer.accept(this.keyColumnContainingTable, this.keyColumnExpressions.get(i), this.jdbcMappings.get(i));
        }
    }

    @Override
    public void visitTargetColumns(ColumnConsumer consumer) {
        for (int i = 0; i < this.keyColumnExpressions.size(); ++i) {
            consumer.accept(this.targetColumnContainingTable, this.targetColumnExpressions.get(i), this.jdbcMappings.get(i));
        }
    }

    @Override
    public boolean areTargetColumnNamesEqualsTo(String[] columnNames) {
        int length = columnNames.length;
        if (length != this.targetColumnExpressions.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.targetColumnExpressions.contains(columnNames[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public MappingType getPartMappingType() {
        throw new HibernateException("Unexpected call to SimpleForeignKeyDescriptor#getPartMappingType");
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.mappingType.getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        throw new UnsupportedOperationException();
    }
}

