/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.SingularAssociationAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.CompositeTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddedIdentifierMappingImpl
implements CompositeIdentifierMapping,
EmbeddableValuedFetchable {
    private final NavigableRole navigableRole;
    private final EntityMappingType entityMapping;
    private final String name;
    private final MappingType type;
    private final StateArrayContributorMetadataAccess attributeMetadataAccess;
    private final PropertyAccess propertyAccess;
    private final String tableExpression;
    private final String[] attrColumnNames;
    private final SessionFactoryImplementor sessionFactory;

    public EmbeddedIdentifierMappingImpl(EntityMappingType entityMapping, String name, MappingType type, StateArrayContributorMetadataAccess attributeMetadataAccess, PropertyAccess propertyAccess, String tableExpression, String[] attrColumnNames, SessionFactoryImplementor sessionFactory) {
        this.navigableRole = entityMapping.getNavigableRole().appendContainer("{id}");
        this.entityMapping = entityMapping;
        this.name = name;
        this.type = type;
        this.attributeMetadataAccess = attributeMetadataAccess;
        this.propertyAccess = propertyAccess;
        this.tableExpression = tableExpression;
        this.attrColumnNames = attrColumnNames;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public EmbeddableMappingType getPartMappingType() {
        return (EmbeddableMappingType)this.type;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return this.name;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.propertyAccess.getSetter().set(entity, id, session.getFactory());
    }

    @Override
    public Object instantiate() {
        return this.entityMapping.getRepresentationStrategy().getInstantiator().instantiate(this.sessionFactory);
    }

    @Override
    public EmbeddableMappingType getEmbeddableTypeDescriptor() {
        return this.getMappedTypeDescriptor();
    }

    @Override
    public EmbeddableMappingType getMappedTypeDescriptor() {
        return (EmbeddableMappingType)this.type;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public List<String> getMappedColumnExpressions() {
        return Arrays.asList(this.attrColumnNames);
    }

    @Override
    public SingularAttributeMapping getParentInjectionAttributeMapping() {
        return null;
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getMappedTypeDescriptor().visitJdbcTypes(action, clause, typeConfiguration);
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().getAttributeMappings().forEach(attributeMapping -> {
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            if (attributeMapping instanceof SingularAssociationAttributeMapping) {
                EntityMappingType associatedEntityMappingType = ((SingularAssociationAttributeMapping)attributeMapping).getAssociatedEntityMappingType();
                EntityIdentifierMapping identifierMapping = associatedEntityMappingType.getIdentifierMapping();
                Object identifier = identifierMapping.getIdentifier(o, session);
                identifierMapping.visitJdbcValues(identifier, clause, valuesConsumer, session);
            } else {
                attributeMapping.visitJdbcValues(o, clause, valuesConsumer, session);
            }
        });
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this, resultVariable, creationState);
    }

    @Override
    public Expression toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, final SqlAstCreationState sqlAstCreationState) {
        final ArrayList columnReferences = CollectionHelper.arrayList(this.attrColumnNames.length);
        final TableReference tableReference = tableGroup.resolveTableReference(this.getContainingTableExpression());
        this.getEmbeddableTypeDescriptor().visitJdbcTypes(new Consumer<JdbcMapping>(){
            private int index = 0;

            @Override
            public void accept(JdbcMapping jdbcMapping) {
                String attrColumnExpr = EmbeddedIdentifierMappingImpl.this.attrColumnNames[this.index++];
                Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, attrColumnExpr), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), attrColumnExpr, jdbcMapping, sqlAstCreationState.getCreationContext().getSessionFactory()));
                columnReferences.add((ColumnReference)columnReference);
            }
        }, clause, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new SqlTuple(columnReferences, this);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        CompositeTableGroup compositeTableGroup = new CompositeTableGroup(navigablePath, this, lhs);
        TableGroupJoin join = new TableGroupJoin(navigablePath, SqlAstJoinType.LEFT, compositeTableGroup, null);
        lhs.addTableGroupJoin(join);
        return join;
    }

    @Override
    public String getSqlAliasStem() {
        return this.name;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.getMappedTypeDescriptor().findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.getMappedTypeDescriptor().visitSubParts(consumer, treatTargetType);
    }

    @Override
    public String getFetchableName() {
        return this.name;
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return null;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableFetchImpl(fetchablePath, this, fetchParent, fetchTiming, selected, this.attributeMetadataAccess.resolveAttributeMetadata(null).isNullable(), creationState);
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        this.getAttributes().forEach(attribute -> {
            if (attribute instanceof SingularAssociationAttributeMapping) {
                SingularAssociationAttributeMapping associationAttributeMapping = (SingularAssociationAttributeMapping)attribute;
                associationAttributeMapping.getForeignKeyDescriptor().visitReferringColumns(consumer);
            } else {
                attribute.visitColumns(consumer);
            }
        });
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public int getAttributeCount() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public Collection<SingularAttributeMapping> getAttributes() {
        return this.getEmbeddableTypeDescriptor().getAttributeMappings();
    }
}

