/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.AbstractEntityDiscriminatorMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.BasicType;

public class EntityDiscriminatorMappingImpl
extends AbstractEntityDiscriminatorMapping {
    private final NavigableRole navigableRole;

    public EntityDiscriminatorMappingImpl(EntityPersister entityDescriptor, String tableExpression, String mappedColumnExpression, BasicType mappingType) {
        super(entityDescriptor, tableExpression, mappedColumnExpression, mappingType);
        this.navigableRole = entityDescriptor.getNavigableRole().append("{discriminator}");
    }

    @Override
    protected SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(this.getContainingTableExpression());
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.getMappedColumnExpression()), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), this.getMappedColumnExpression(), this.getJdbcMapping(), creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.getEntityDescriptor();
    }
}

