/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.internal.BasicValuedSingularAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EntityVersionMappingImpl
implements EntityVersionMapping {
    private final String attributeName;
    private final EntityMappingType declaringType;
    private final String columnTableExpression;
    private final String columnExpression;
    private final BasicType versionBasicType;

    public EntityVersionMappingImpl(String attributeName, String columnTableExpression, String columnExpression, BasicType versionBasicType, EntityMappingType declaringType) {
        this.attributeName = attributeName;
        this.declaringType = declaringType;
        this.columnTableExpression = columnTableExpression;
        this.columnExpression = columnExpression;
        this.versionBasicType = versionBasicType;
    }

    @Override
    public BasicValuedSingularAttributeMapping getVersionAttribute() {
        return (BasicValuedSingularAttributeMapping)this.declaringType.findAttributeMapping(this.attributeName);
    }

    @Override
    public String getContainingTableExpression() {
        return this.columnTableExpression;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.columnExpression;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.versionBasicType;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return this.versionBasicType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.versionBasicType.getJdbcMapping();
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.versionBasicType.getJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return this.attributeName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getVersionAttribute().getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType;
    }

    @Override
    public String getFetchableName() {
        return this.attributeName;
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return FetchStrategy.IMMEDIATE_JOIN;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(this.columnTableExpression);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnTableReference, this.columnExpression), sqlAstProcessingState -> new ColumnReference(columnTableReference, this.columnExpression, (JdbcMapping)this.versionBasicType, sqlAstCreationState.getCreationContext().getSessionFactory())), this.versionBasicType.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, false, null, fetchTiming, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(this.columnTableExpression);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnTableReference, this.columnExpression), sqlAstProcessingState -> new ColumnReference(columnTableReference, this.columnExpression, (JdbcMapping)this.versionBasicType, sqlAstCreationState.getCreationContext().getSessionFactory())), this.versionBasicType.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaTypeDescriptor(), navigablePath);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
    }
}

