/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.mapping.ordering.OrderByFragmentTranslator;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.collection.internal.DelayedCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.SelectEagerCollectionFetch;
import org.hibernate.type.EntityType;
import org.jboss.logging.Logger;

public class PluralAttributeMappingImpl
extends AbstractAttributeMapping
implements PluralAttributeMapping {
    private static final Logger log = Logger.getLogger(PluralAttributeMappingImpl.class);
    private final CollectionMappingType collectionMappingType;
    private final int stateArrayPosition;
    private final PropertyAccess propertyAccess;
    private final StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess;
    private final CollectionPart elementDescriptor;
    private final CollectionPart indexDescriptor;
    private final CollectionIdentifierDescriptor identifierDescriptor;
    private final FetchStrategy fetchStrategy;
    private final CascadeStyle cascadeStyle;
    private final CollectionPersister collectionDescriptor;
    private final String separateCollectionTable;
    private final String sqlAliasStem;
    private final PluralAttributeMapping.IndexMetadata indexMetadata;
    private ForeignKeyDescriptor fkDescriptor;
    private ForeignKeyDescriptor manyToManyFkDescriptor;
    private OrderByFragment orderByFragment;
    private OrderByFragment manyToManyOrderByFragment;

    public PluralAttributeMappingImpl(String attributeName, final Collection bootDescriptor, PropertyAccess propertyAccess, StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess, CollectionMappingType collectionMappingType, int stateArrayPosition, CollectionPart elementDescriptor, final CollectionPart indexDescriptor, CollectionIdentifierDescriptor identifierDescriptor, FetchStrategy fetchStrategy, CascadeStyle cascadeStyle, ManagedMappingType declaringType, CollectionPersister collectionDescriptor) {
        super(attributeName, declaringType);
        this.propertyAccess = propertyAccess;
        this.stateArrayContributorMetadataAccess = stateArrayContributorMetadataAccess;
        this.collectionMappingType = collectionMappingType;
        this.stateArrayPosition = stateArrayPosition;
        this.elementDescriptor = elementDescriptor;
        this.indexDescriptor = indexDescriptor;
        this.identifierDescriptor = identifierDescriptor;
        this.fetchStrategy = fetchStrategy;
        this.cascadeStyle = cascadeStyle;
        this.collectionDescriptor = collectionDescriptor;
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(attributeName);
        this.separateCollectionTable = bootDescriptor.isOneToMany() ? null : ((Joinable)((Object)collectionDescriptor)).getTableName();
        this.indexMetadata = new PluralAttributeMapping.IndexMetadata(){
            final int baseIndex;
            {
                this.baseIndex = bootDescriptor instanceof List ? ((List)bootDescriptor).getBaseIndex() : -1;
            }

            @Override
            public CollectionPart getIndexDescriptor() {
                return indexDescriptor;
            }

            @Override
            public int getListIndexBase() {
                return this.baseIndex;
            }
        };
        if (collectionDescriptor instanceof Aware) {
            ((Aware)((Object)collectionDescriptor)).injectAttributeMapping(this);
        }
        if (elementDescriptor instanceof Aware) {
            ((Aware)((Object)elementDescriptor)).injectAttributeMapping(this);
        }
        if (indexDescriptor instanceof Aware) {
            ((Aware)((Object)indexDescriptor)).injectAttributeMapping(this);
        }
    }

    public void finishInitialization(Property bootProperty, Collection bootDescriptor, MappingModelCreationProcess creationProcess) {
        boolean hasManyToManyOrder;
        if (this.collectionDescriptor.getElementType() instanceof EntityType || this.collectionDescriptor.getIndexType() instanceof EntityType) {
            creationProcess.registerForeignKeyPostInitCallbacks(() -> {
                Value fkBootDescriptorSource;
                EntityIdentifierMapping fkTargetPart;
                if (this.collectionDescriptor.getElementType() instanceof EntityType) {
                    EntityType elementEntityType = (EntityType)this.collectionDescriptor.getElementType();
                    EntityPersister associatedEntityDescriptor = creationProcess.getEntityPersister(elementEntityType.getAssociatedEntityName());
                    fkTargetPart = elementEntityType.isReferenceToPrimaryKey() ? associatedEntityDescriptor.getIdentifierMapping() : associatedEntityDescriptor.findSubPart(elementEntityType.getRHSUniqueKeyPropertyName());
                    fkBootDescriptorSource = bootDescriptor.getElement();
                } else {
                    assert (this.collectionDescriptor.getIndexType() != null);
                    assert (bootDescriptor instanceof IndexedCollection);
                    EntityType indexEntityType = (EntityType)this.collectionDescriptor.getIndexType();
                    EntityPersister associatedEntityDescriptor = creationProcess.getEntityPersister(indexEntityType.getAssociatedEntityName());
                    fkTargetPart = indexEntityType.isReferenceToPrimaryKey() ? associatedEntityDescriptor.getIdentifierMapping() : associatedEntityDescriptor.findSubPart(indexEntityType.getRHSUniqueKeyPropertyName());
                    fkBootDescriptorSource = ((IndexedCollection)bootDescriptor).getIndex();
                }
                Dialect dialect = creationProcess.getCreationContext().getSessionFactory().getJdbcServices().getDialect();
                if (fkTargetPart instanceof BasicValuedModelPart) {
                    BasicValuedModelPart basicFkTargetPart = (BasicValuedModelPart)((Object)fkTargetPart);
                    Joinable collectionDescriptorAsJoinable = (Joinable)((Object)this.collectionDescriptor);
                    this.manyToManyFkDescriptor = new SimpleForeignKeyDescriptor(collectionDescriptorAsJoinable.getTableName(), fkBootDescriptorSource.getColumnIterator().next().getText(dialect), basicFkTargetPart.getContainingTableExpression(), basicFkTargetPart.getMappedColumnExpression(), basicFkTargetPart.getJdbcMapping());
                } else if (fkTargetPart instanceof EmbeddableValuedModelPart) {
                    this.manyToManyFkDescriptor = MappingModelCreationHelper.buildEmbeddedForeignKeyDescriptor((EmbeddableValuedModelPart)((Object)fkTargetPart), this, fkBootDescriptorSource, dialect, creationProcess);
                } else {
                    throw new NotYetImplementedFor6Exception("Support for composite foreign keys not yet implemented : " + this.collectionDescriptor.getRole());
                }
                return true;
            });
        }
        boolean hasOrder = bootDescriptor.getOrderBy() != null;
        boolean bl = hasManyToManyOrder = bootDescriptor.getManyToManyOrdering() != null;
        if (hasOrder || hasManyToManyOrder) {
            TranslationContext context = new TranslationContext(){};
            if (hasOrder) {
                log.debugf("Translating order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                this.orderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getOrderBy(), this, context);
            }
            if (hasManyToManyOrder) {
                log.debugf("Translating many-to-many order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                this.manyToManyOrderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getManyToManyOrdering(), this, context);
            }
        }
    }

    @Override
    public CollectionMappingType getMappedTypeDescriptor() {
        return this.collectionMappingType;
    }

    @Override
    public ForeignKeyDescriptor getKeyDescriptor() {
        return this.fkDescriptor;
    }

    @Override
    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public CollectionPart getElementDescriptor() {
        return this.elementDescriptor;
    }

    @Override
    public CollectionPart getIndexDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public PluralAttributeMapping.IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    @Override
    public CollectionIdentifierDescriptor getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    @Override
    public OrderByFragment getOrderByFragment() {
        return this.orderByFragment;
    }

    @Override
    public OrderByFragment getManyToManyOrderByFragment() {
        return this.manyToManyOrderByFragment;
    }

    @Override
    public String getSeparateCollectionTable() {
        return this.separateCollectionTable;
    }

    @Override
    public int getStateArrayPosition() {
        return this.stateArrayPosition;
    }

    @Override
    public StateArrayContributorMetadataAccess getAttributeMetadataAccess() {
        return this.stateArrayContributorMetadataAccess;
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public String getFetchableName() {
        return this.getAttributeName();
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getCollectionDescriptor().getNavigableRole();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup collectionTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        assert (collectionTableGroup != null);
        return new CollectionDomainResult(navigablePath, this, resultVariable, tableGroup, creationState);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            if (selected) {
                TableGroup collectionTableGroup = sqlAstCreationState.getFromClauseAccess().resolveTableGroup(fetchablePath, p -> {
                    TableGroup lhsTableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, lhsTableGroup, null, SqlAstJoinType.LEFT, lockMode, creationState.getSqlAliasBaseManager(), creationState.getSqlAstCreationState().getSqlExpressionResolver(), creationState.getSqlAstCreationState().getCreationContext());
                    return tableGroupJoin.getJoinedGroup();
                });
                return new EagerCollectionFetch(fetchablePath, this, collectionTableGroup, fetchParent, creationState);
            }
            return new SelectEagerCollectionFetch(fetchablePath, this, fetchParent);
        }
        if (this.getCollectionDescriptor().getCollectionType().hasHolder()) {
            return new SelectEagerCollectionFetch(fetchablePath, this, fetchParent);
        }
        return new DelayedCollectionFetch(fetchablePath, this, fetchParent);
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        CollectionPersister collectionDescriptor = this.getCollectionDescriptor();
        if (collectionDescriptor.isOneToMany()) {
            return this.createOneToManyTableGroupJoin(navigablePath, lhs, explicitSourceAlias, sqlAstJoinType, lockMode, aliasBaseGenerator, sqlExpressionResolver, creationContext);
        }
        return this.createCollectionTableGroupJoin(navigablePath, lhs, explicitSourceAlias, sqlAstJoinType, lockMode, aliasBaseGenerator, sqlExpressionResolver, creationContext);
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor fkDescriptor) {
        this.fkDescriptor = fkDescriptor;
    }

    private TableGroupJoin createOneToManyTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableGroup tableGroup = this.createOneToManyTableGroup(navigablePath, sqlAstJoinType == SqlAstJoinType.INNER && !this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), lockMode, aliasBaseGenerator, sqlExpressionResolver, creationContext);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, this.getKeyDescriptor().generateJoinPredicate(lhs, tableGroup, sqlAstJoinType, sqlExpressionResolver, creationContext));
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    private TableGroup createOneToManyTableGroup(NavigablePath navigablePath, boolean canUseInnerJoins, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        EntityCollectionPart entityPartDescriptor;
        if (this.elementDescriptor instanceof EntityCollectionPart) {
            entityPartDescriptor = (EntityCollectionPart)this.elementDescriptor;
        } else {
            assert (this.indexDescriptor instanceof EntityCollectionPart);
            entityPartDescriptor = (EntityCollectionPart)this.indexDescriptor;
        }
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem());
        TableReference primaryTableReference = entityPartDescriptor.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        return new StandardTableGroup(navigablePath, this, lockMode, primaryTableReference, sqlAliasBase, tableExpression -> entityPartDescriptor.getEntityMappingType().containsTableReference((String)tableExpression), (tableExpression, tg) -> entityPartDescriptor.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, canUseInnerJoins, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
    }

    private TableGroupJoin createCollectionTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableGroup tableGroup = this.createCollectionTableGroup(navigablePath, sqlAstJoinType == SqlAstJoinType.INNER && !this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), lockMode, aliasBaseGenerator, sqlExpressionResolver, creationContext);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, this.getKeyDescriptor().generateJoinPredicate(lhs, tableGroup, sqlAstJoinType, sqlExpressionResolver, creationContext));
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    private TableGroup createCollectionTableGroup(NavigablePath navigablePath, boolean canUseInnerJoin, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        Consumer<TableGroup> tableGroupFinalizer;
        BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator;
        java.util.function.Predicate<String> tableReferenceJoinNameChecker;
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem());
        assert (!this.getCollectionDescriptor().isOneToMany());
        String collectionTableName = ((Joinable)((Object)this.collectionDescriptor)).getTableName();
        TableReference collectionTableReference = new TableReference(collectionTableName, sqlAliasBase.generateNewAlias(), true, creationContext.getSessionFactory());
        if (this.elementDescriptor instanceof EntityCollectionPart || this.indexDescriptor instanceof EntityCollectionPart) {
            EntityCollectionPart entityPartDescriptor = this.elementDescriptor instanceof EntityCollectionPart ? (EntityCollectionPart)this.elementDescriptor : (EntityCollectionPart)this.indexDescriptor;
            EntityMappingType mappingType = entityPartDescriptor.getEntityMappingType();
            TableReference associatedPrimaryTable = mappingType.createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
            tableReferenceJoinNameChecker = mappingType::containsTableReference;
            tableReferenceJoinCreator = (tableExpression, tableGroup) -> mappingType.createTableReferenceJoin((String)tableExpression, sqlAliasBase, associatedPrimaryTable, canUseInnerJoin && !this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), sqlExpressionResolver, creationContext);
            tableGroupFinalizer = tableGroup -> {
                SqlAstJoinType joinType = canUseInnerJoin && !this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable() ? SqlAstJoinType.INNER : SqlAstJoinType.LEFT;
                TableReferenceJoin associationJoin = new TableReferenceJoin(joinType, associatedPrimaryTable, this.manyToManyFkDescriptor.generateJoinPredicate(collectionTableReference, associatedPrimaryTable, joinType, sqlExpressionResolver, creationContext));
                ((StandardTableGroup)tableGroup).addTableReferenceJoin(associationJoin);
            };
        } else {
            tableReferenceJoinCreator = (tableExpression, tableGroup) -> {
                throw new UnsupportedOperationException("element-collection cannot contain joins : " + collectionTableReference.getTableExpression() + " -> " + tableExpression);
            };
            tableReferenceJoinNameChecker = s -> false;
            tableGroupFinalizer = null;
        }
        StandardTableGroup tableGroup2 = new StandardTableGroup(navigablePath, this, lockMode, collectionTableReference, sqlAliasBase, tableReferenceJoinNameChecker, tableReferenceJoinCreator, creationContext.getSessionFactory());
        if (tableGroupFinalizer != null) {
            tableGroupFinalizer.accept(tableGroup2);
        }
        return tableGroup2;
    }

    @Override
    public TableGroup createRootTableGroup(NavigablePath navigablePath, String explicitSourceAlias, boolean canUseInnerJoins, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationContext creationContext) {
        if (this.getCollectionDescriptor().isOneToMany()) {
            return this.createOneToManyTableGroup(navigablePath, canUseInnerJoins, lockMode, aliasBaseGenerator, sqlExpressionResolver, creationContext);
        }
        return this.createCollectionTableGroup(navigablePath, canUseInnerJoins, lockMode, aliasBaseGenerator, sqlExpressionResolver, creationContext);
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFilters(influencers);
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEntityGraph(influencers);
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFetchProfiles(influencers);
    }

    @Override
    public String getRootPathName() {
        return this.getCollectionDescriptor().getRole();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromName(name);
        if (nature == CollectionPart.Nature.ELEMENT) {
            return this.elementDescriptor;
        }
        if (nature == CollectionPart.Nature.INDEX) {
            return this.indexDescriptor;
        }
        if (nature == CollectionPart.Nature.ID) {
            return this.identifierDescriptor;
        }
        if (this.elementDescriptor instanceof EntityCollectionPart) {
            return ((EntityCollectionPart)this.elementDescriptor).findSubPart(name);
        }
        return null;
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.elementDescriptor);
        if (this.indexDescriptor != null) {
            consumer.accept(this.indexDescriptor);
        }
    }

    @Override
    public int getNumberOfFetchables() {
        return this.indexDescriptor == null ? 1 : 2;
    }

    public String toString() {
        return "PluralAttribute(" + this.getCollectionDescriptor().getRole() + ")";
    }

    public static interface Aware {
        public void injectAttributeMapping(PluralAttributeMapping var1);
    }
}

