/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SimpleForeignKeyDescriptor
implements ForeignKeyDescriptor,
BasicValuedModelPart {
    private final String keyColumnContainingTable;
    private final String keyColumnExpression;
    private final String targetColumnContainingTable;
    private final String targetColumnExpression;
    private final JdbcMapping jdbcMapping;

    public SimpleForeignKeyDescriptor(String keyColumnContainingTable, String keyColumnExpression, String targetColumnContainingTable, String targetColumnExpression, JdbcMapping jdbcMapping) {
        this.keyColumnContainingTable = keyColumnContainingTable;
        this.keyColumnExpression = keyColumnExpression;
        this.targetColumnContainingTable = targetColumnContainingTable;
        this.targetColumnExpression = targetColumnExpression;
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public DomainResult createCollectionFetchDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.targetColumnContainingTable.equals(this.keyColumnContainingTable)) {
            SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
            SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
            TableReference tableReference = tableGroup.resolveTableReference(this.keyColumnContainingTable);
            String identificationVariable = tableReference.getIdentificationVariable();
            SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.targetColumnExpression), s -> new ColumnReference(identificationVariable, this.targetColumnExpression, this.jdbcMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.jdbcMapping.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
            return new BasicResult(sqlSelection.getValuesArrayPosition(), null, this.jdbcMapping.getJavaTypeDescriptor());
        }
        return this.createDomainResult(collectionPath, tableGroup, creationState);
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, null, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(this.keyColumnContainingTable);
        String identificationVariable = tableReference.getIdentificationVariable();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.keyColumnExpression), s -> new ColumnReference(identificationVariable, this.keyColumnExpression, this.jdbcMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.jdbcMapping.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, this.jdbcMapping.getJavaTypeDescriptor());
    }

    @Override
    public Predicate generateJoinPredicate(TableReference lhs, TableReference rhs, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        String rhsTableExpression = rhs.getTableExpression();
        String lhsTableExpression = lhs.getTableExpression();
        if (lhsTableExpression.equals(this.keyColumnContainingTable)) {
            assert (rhsTableExpression.equals(this.targetColumnContainingTable));
            return new ComparisonPredicate(new ColumnReference(lhs, this.keyColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, this.targetColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()));
        }
        assert (rhsTableExpression.equals(this.keyColumnContainingTable));
        return new ComparisonPredicate(new ColumnReference(lhs, this.targetColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, this.keyColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()));
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup lhs, TableGroup tableGroup, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference rhsTableKeyReference;
        TableReference lhsTableReference;
        if (this.targetColumnContainingTable.equals(this.keyColumnContainingTable)) {
            lhsTableReference = this.getTableReferenceWhenTargetEqualsKey(lhs, tableGroup, this.keyColumnContainingTable);
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetColumnContainingTable);
        } else {
            lhsTableReference = this.getTableReference(lhs, tableGroup, this.keyColumnContainingTable);
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetColumnContainingTable);
        }
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlAstJoinType, sqlExpressionResolver, creationContext);
    }

    protected TableReference getTableReferenceWhenTargetEqualsKey(TableGroup lhs, TableGroup tableGroup, String table) {
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : lhs.getTableReferenceJoins()) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(table)) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        TableReference tableReference = lhs.resolveTableReference(table);
        if (tableReference != null) {
            return tableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.jdbcMapping.getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getReferringTableExpression() {
        return this.keyColumnContainingTable;
    }

    @Override
    public void visitReferringColumns(ColumnConsumer consumer) {
        consumer.accept(this.keyColumnContainingTable, this.keyColumnExpression, this.jdbcMapping);
    }

    @Override
    public String getTargetTableExpression() {
        return this.targetColumnContainingTable;
    }

    @Override
    public void visitTargetColumns(ColumnConsumer consumer) {
        consumer.accept(this.targetColumnContainingTable, this.targetColumnExpression, this.jdbcMapping);
    }

    @Override
    public boolean areTargetColumnNamesEqualsTo(String[] columnNames) {
        if (columnNames.length != 1) {
            return false;
        }
        return this.targetColumnExpression.equals(columnNames[0]);
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        return 1;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        return Collections.singletonList(this.jdbcMapping);
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.jdbcMapping);
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(value, this.jdbcMapping);
    }

    @Override
    public String getContainingTableExpression() {
        return this.keyColumnContainingTable;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.keyColumnExpression;
    }

    @Override
    public String getFetchableName() {
        return "{fk}";
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return FetchStrategy.IMMEDIATE_JOIN;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    public String getTargetColumnContainingTable() {
        return this.targetColumnContainingTable;
    }

    public String getTargetColumnExpression() {
        return this.targetColumnExpression;
    }
}

