/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.ToOne;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchDelayedImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchSelectImpl;
import org.hibernate.sql.results.internal.domain.BiDirectionalFetchImpl;
import org.hibernate.type.ForeignKeyDirection;

public class SingularAssociationAttributeMapping
extends AbstractSingularAttributeMapping
implements EntityValuedFetchable,
EntityAssociationMapping,
Association,
TableGroupJoinProducer {
    private final NavigableRole navigableRole;
    private final String sqlAliasStem;
    private final boolean isNullable;
    private final boolean unwrapProxy;
    private final EntityMappingType entityMappingType;
    private final String referencedPropertyName;
    private final boolean referringPrimaryKey;
    private final Cardinality cardinality;
    private ForeignKeyDescriptor foreignKeyDescriptor;
    private ForeignKeyDirection foreignKeyDirection;
    private String identifyingColumnsTableExpression;

    public SingularAssociationAttributeMapping(String name, int stateArrayPosition, ToOne bootValue, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchStrategy mappedFetchStrategy, EntityMappingType entityMappingType, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, attributeMetadataAccess, mappedFetchStrategy, declaringType, propertyAccess);
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(name);
        this.isNullable = bootValue.isNullable();
        this.referencedPropertyName = bootValue.getReferencedPropertyName();
        this.referringPrimaryKey = bootValue.isReferenceToPrimaryKey();
        this.unwrapProxy = bootValue.isUnwrapProxy();
        this.entityMappingType = entityMappingType;
        if (this.referringPrimaryKey ? !$assertionsDisabled && this.referencedPropertyName != null : !$assertionsDisabled && this.referencedPropertyName == null) {
            throw new AssertionError();
        }
        if (bootValue instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)bootValue;
            this.cardinality = manyToOne.isLogicalOneToOne() ? Cardinality.LOGICAL_ONE_TO_ONE : Cardinality.MANY_TO_ONE;
        } else {
            assert (bootValue instanceof OneToOne);
            this.cardinality = Cardinality.ONE_TO_ONE;
        }
        this.navigableRole = declaringType.getNavigableRole().appendContainer(name);
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor foreignKeyDescriptor) {
        this.foreignKeyDescriptor = foreignKeyDescriptor;
    }

    public void setIdentifyingColumnsTableExpression(String tableExpression) {
        this.identifyingColumnsTableExpression = tableExpression;
    }

    public void setForeignKeyDirection(ForeignKeyDirection direction) {
        this.foreignKeyDirection = direction;
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.foreignKeyDescriptor;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    @Override
    public EntityMappingType getMappedTypeDescriptor() {
        return this.getEntityMappingType();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, DomainResultCreationState creationState) {
        ModelPart parentModelPart = fetchParent.getReferencedModePart();
        if (!Fetchable.class.isInstance(parentModelPart)) {
            return null;
        }
        FetchParent associationFetchParent = fetchParent.resolveContainingAssociationParent();
        if (associationFetchParent == null) {
            return null;
        }
        ModelPart referencedModePart = associationFetchParent.getReferencedModePart();
        assert (referencedModePart instanceof Association);
        Association associationParent = (Association)referencedModePart;
        if (this.foreignKeyDescriptor.equals(associationParent.getForeignKeyDescriptor())) {
            return this.createBiDirectionalFetch(fetchablePath, fetchParent);
        }
        ForeignKeyDescriptor associationParentForeignKeyDescriptor = associationParent.getForeignKeyDescriptor();
        if (referencedModePart instanceof SingularAssociationAttributeMapping && ((SingularAssociationAttributeMapping)referencedModePart).getDeclaringType() == this.getPartMappingType() && this.foreignKeyDescriptor.getReferringTableExpression().equals(associationParentForeignKeyDescriptor.getReferringTableExpression())) {
            SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)this.getDeclaringType();
            if (associationParentForeignKeyDescriptor.getTargetTableExpression().equals(entityPersister.getTableName())) {
                String[] identifierColumnNames = entityPersister.getIdentifierColumnNames();
                if (associationParentForeignKeyDescriptor.areTargetColumnNamesEqualsTo(identifierColumnNames)) {
                    return this.createBiDirectionalFetch(fetchablePath, fetchParent);
                }
                return null;
            }
        }
        return null;
    }

    private Fetch createBiDirectionalFetch(NavigablePath fetchablePath, FetchParent fetchParent) {
        EntityResultGraphNode referencedEntityReference = this.resolveEntityGraphNode(fetchParent);
        if (referencedEntityReference == null) {
            throw new HibernateException("Could not locate entity-valued reference for circular path `" + fetchablePath + "`");
        }
        return new BiDirectionalFetchImpl(FetchTiming.IMMEDIATE, fetchablePath, fetchParent, this, referencedEntityReference.getNavigablePath());
    }

    protected EntityResultGraphNode resolveEntityGraphNode(FetchParent fetchParent) {
        FetchParent processingParent = fetchParent;
        while (processingParent != null) {
            if (processingParent instanceof EntityResultGraphNode) {
                return (EntityResultGraphNode)processingParent;
            }
            if (processingParent instanceof Fetch) {
                processingParent = ((Fetch)((Object)processingParent)).getFetchParent();
                continue;
            }
            processingParent = null;
        }
        return null;
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup lhsTableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        if (fetchTiming == FetchTiming.IMMEDIATE && selected) {
            if (sqlAstCreationState.getFromClauseAccess().findTableGroup(fetchablePath) == null) {
                SqlAstJoinType sqlAstJoinType = this.isNullable ? SqlAstJoinType.LEFT : SqlAstJoinType.INNER;
                TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, lhsTableGroup, null, sqlAstJoinType, lockMode, creationState.getSqlAliasBaseManager(), creationState.getSqlAstCreationState().getSqlExpressionResolver(), creationState.getSqlAstCreationState().getCreationContext());
                sqlAstCreationState.getFromClauseAccess().registerTableGroup(fetchablePath, tableGroupJoin.getJoinedGroup());
            }
            return new EntityFetchJoinedImpl(fetchParent, this, lockMode, true, fetchablePath, creationState);
        }
        DomainResult keyResult = this.referringPrimaryKey ? this.foreignKeyDescriptor.createDomainResult(fetchablePath, lhsTableGroup, creationState) : ((EntityPersister)this.getDeclaringType()).getIdentifierMapping().createDomainResult(fetchablePath, lhsTableGroup, null, creationState);
        assert (!selected);
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            return new EntityFetchSelectImpl(fetchParent, this, lockMode, this.isNullable, fetchablePath, keyResult, creationState);
        }
        return new EntityFetchDelayedImpl(fetchParent, this, lockMode, this.isNullable, fetchablePath, keyResult);
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEntityMappingType().getNumberOfFetchables();
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        String aliasRoot = explicitSourceAlias == null ? this.sqlAliasStem : explicitSourceAlias;
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(aliasRoot);
        TableReference primaryTableReference = this.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        StandardTableGroup tableGroup = new StandardTableGroup(navigablePath, this, lockMode, primaryTableReference, sqlAliasBase, tableExpression -> this.getEntityMappingType().containsTableReference((String)tableExpression), (tableExpression, tg) -> this.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, false, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
        TableReference lhsTableReference = lhs.resolveTableReference(this.identifyingColumnsTableExpression);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, this.foreignKeyDescriptor.generateJoinPredicate(lhsTableReference, primaryTableReference, sqlAstJoinType, sqlExpressionResolver, creationContext));
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.foreignKeyDescriptor;
    }

    public String toString() {
        return "SingularAssociationAttributeMapping {" + this.navigableRole + "}";
    }

    public static enum Cardinality {
        ONE_TO_ONE,
        MANY_TO_ONE,
        LOGICAL_ONE_TO_ONE;

    }
}

