/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPathContinuation;
import org.hibernate.metamodel.mapping.ordering.ast.PathResolutionException;
import org.hibernate.metamodel.mapping.ordering.ast.PluralAttributePath;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.query.NavigablePath;

public class CollectionPartPath
implements DomainPath {
    private final NavigablePath navigablePath;
    private final PluralAttributePath lhs;
    private final CollectionPart referencedPart;

    CollectionPartPath(PluralAttributePath lhs, CollectionPart referencedPart) {
        this.lhs = lhs;
        this.referencedPart = referencedPart;
        this.navigablePath = lhs.getNavigablePath().append(referencedPart.getPartName());
    }

    @Override
    public PluralAttributeMapping getPluralAttribute() {
        return this.lhs.getPluralAttribute();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public PluralAttributePath getLhs() {
        return this.lhs;
    }

    @Override
    public CollectionPart getReferenceModelPart() {
        return this.referencedPart;
    }

    @Override
    public SequencePart resolvePathPart(String name, boolean isTerminal, TranslationContext translationContext) {
        if (this.referencedPart instanceof EmbeddedCollectionPart) {
            ModelPart subPart = ((EmbeddedCollectionPart)this.referencedPart).findSubPart(name, null);
            return new DomainPathContinuation(this.navigablePath.append(name), this, subPart);
        }
        throw new PathResolutionException("Could not resolve order-by path : " + this.navigablePath + " -> " + name);
    }
}

