/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.SortOrder;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class ColumnReference
implements OrderingExpression,
SequencePart {
    private final String columnExpression;
    private final NavigablePath rootPath;

    public ColumnReference(String columnExpression, NavigablePath rootPath) {
        this.columnExpression = columnExpression;
        this.rootPath = rootPath;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    @Override
    public SequencePart resolvePathPart(String name, boolean isTerminal, TranslationContext translationContext) {
        throw new UnsupportedOperationException("ColumnReference cannot be de-referenced");
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, SortOrder sortOrder, SqlAstCreationState creationState) {
        TableReference primaryTableReference = tableGroup.getPrimaryTableReference();
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        ast.addSortSpecification(new SortSpecification(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(primaryTableReference, this.columnExpression), sqlAstProcessingState -> new org.hibernate.sql.ast.tree.expression.ColumnReference(tableGroup.getPrimaryTableReference(), this.columnExpression, null, creationState.getCreationContext().getSessionFactory())), collation, sortOrder));
    }
}

