/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.PathResolutionException;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.query.NavigablePath;

public class DomainPathContinuation
implements DomainPath {
    private final NavigablePath navigablePath;
    private final DomainPath lhs;
    private final ModelPart referencedModelPart;

    public DomainPathContinuation(NavigablePath navigablePath, DomainPath lhs, ModelPart referencedModelPart) {
        this.navigablePath = navigablePath;
        this.lhs = lhs;
        this.referencedModelPart = referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public DomainPath getLhs() {
        return this.lhs;
    }

    @Override
    public ModelPart getReferenceModelPart() {
        return this.referencedModelPart;
    }

    @Override
    public SequencePart resolvePathPart(String name, boolean isTerminal, TranslationContext translationContext) {
        if (this.referencedModelPart.getPartMappingType() instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedPart = (EmbeddableValuedModelPart)((Object)this.referencedModelPart.getPartMappingType());
            ModelPart subPart = embeddableValuedPart.findSubPart(name, null);
            if (subPart == null) {
                throw new PathResolutionException("Could not resolve path token : " + this.referencedModelPart + " -> " + name);
            }
            return new DomainPathContinuation(this.navigablePath.append(name), this, subPart);
        }
        throw new PathResolutionException("Domain path of type `" + this.referencedModelPart.getPartMappingType() + "` -> `" + name + "`");
    }
}

