/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.metamodel.Attribute;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractAttribute<D, J, B>
implements PersistentAttribute<D, J>,
Serializable {
    private final ManagedDomainType<D> declaringType;
    private final String name;
    private final JavaTypeDescriptor<J> attributeJtd;
    private final AttributeClassification attributeClassification;
    private final SimpleDomainType<B> valueType;
    private transient Member member;

    protected AbstractAttribute(ManagedDomainType<D> declaringType, String name, JavaTypeDescriptor<J> attributeJtd, AttributeClassification attributeClassification, SimpleDomainType<B> valueType, Member member, MetadataContext metadataContext) {
        this.declaringType = declaringType;
        this.name = name;
        this.attributeJtd = attributeJtd;
        this.attributeClassification = attributeClassification;
        this.valueType = valueType;
        this.member = member;
    }

    public String getName() {
        return this.name;
    }

    public Class<J> getJavaType() {
        return this.attributeJtd.getJavaType();
    }

    public SimpleDomainType<B> getSqmPathType() {
        return this.valueType;
    }

    @Override
    public JavaTypeDescriptor<J> getAttributeJavaTypeDescriptor() {
        return this.attributeJtd;
    }

    @Override
    public ManagedDomainType<D> getDeclaringType() {
        return this.declaringType;
    }

    public Member getJavaMember() {
        return this.member;
    }

    @Override
    public AttributeClassification getAttributeClassification() {
        return this.attributeClassification;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.getAttributeClassification().getJpaClassification();
    }

    @Override
    public SimpleDomainType<?> getValueGraphType() {
        return this.valueType;
    }

    public String toString() {
        return this.declaringType.getTypeName() + '#' + this.name + '(' + (Object)((Object)this.attributeClassification) + ')';
    }

    protected void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String memberDeclaringClassName = (String)ois.readObject();
        String memberName = (String)ois.readObject();
        String memberType = (String)ois.readObject();
        Class<?> memberDeclaringClass = Class.forName(memberDeclaringClassName, false, this.declaringType.getJavaType().getClassLoader());
        try {
            this.member = "method".equals(memberType) ? memberDeclaringClass.getMethod(memberName, ReflectHelper.NO_PARAM_SIGNATURE) : memberDeclaringClass.getField(memberName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to locate member [" + memberDeclaringClassName + "#" + memberName + "]");
        }
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getJavaMember().getDeclaringClass().getName());
        oos.writeObject(this.getJavaMember().getName());
        oos.writeObject(Method.class.isInstance(this.getJavaMember()) ? "method" : "field");
    }
}

