/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.io.Serializable;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.Type;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EntityTypeImpl<J>
extends AbstractIdentifiableType<J>
implements EntityDomainType<J>,
Serializable {
    private final String jpaEntityName;

    public EntityTypeImpl(JavaTypeDescriptor<J> javaTypeDescriptor, IdentifiableDomainType<? super J> superType, PersistentClass persistentClass, JpaMetamodel jpaMetamodel) {
        super(persistentClass.getEntityName(), javaTypeDescriptor, superType, persistentClass.getDeclaredIdentifierMapper() != null || superType != null && superType.hasIdClass(), persistentClass.hasIdentifierProperty(), persistentClass.isVersioned(), jpaMetamodel);
        this.jpaEntityName = persistentClass.getJpaEntityName();
    }

    public String getName() {
        return this.jpaEntityName;
    }

    @Override
    public String getHibernateEntityName() {
        return super.getTypeName();
    }

    @Override
    public String getPathName() {
        return this.getHibernateEntityName();
    }

    @Override
    public EntityDomainType<J> getSqmPathType() {
        return this;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        PersistentAttribute<J, ?> attribute = this.findAttribute(name);
        if (attribute != null) {
            return (SqmPathSource)((Object)attribute);
        }
        if ("id".equalsIgnoreCase(name)) {
            // empty if block
        }
        return null;
    }

    @Override
    public PersistentAttribute<? super J, ?> findAttribute(String name) {
        SingularPersistentAttribute idAttribute;
        PersistentAttribute attribute = super.findAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if ("id".equalsIgnoreCase(name) && (idAttribute = this.findIdAttribute()) != null) {
            return idAttribute;
        }
        return null;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Class<J> getBindableJavaType() {
        return this.getJavaType();
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public IdentifiableDomainType<? super J> getSuperType() {
        return super.getSuperType();
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(Class<S> subType) {
        if (!this.getBindableJavaType().isAssignableFrom(subType)) {
            throw new IllegalArgumentException(String.format("Entity type [%s] cannot be treated as requested sub-type [%s]", this.getName(), subType.getName()));
        }
        return new SubGraphImpl(this, true, this.jpaMetamodel());
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return this.makeSubGraph(this.getBindableJavaType());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmCreationState creationState) {
        throw new UnsupportedOperationException("EntityType cannot be used to create an SqmPath - that would be an SqmFrom which are created directly");
    }
}

