/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.ParameterMode;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.named.AbstractNamedQueryMemento;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryEngine;

public class NamedCallableQueryMementoImpl
extends AbstractNamedQueryMemento
implements NamedCallableQueryMemento {
    private final String callableName;
    private final ParameterStrategy parameterStrategy;
    private final List<NamedCallableQueryMemento.ParameterMemento> parameterMementos;
    private final String[] resultSetMappingNames;
    private final Class[] resultSetMappingClasses;
    private final Set<String> querySpaces;

    public NamedCallableQueryMementoImpl(String name, String callableName, ParameterStrategy parameterStrategy, List<NamedCallableQueryMemento.ParameterMemento> parameterMementos, String[] resultSetMappingNames, Class[] resultSetMappingClasses, Set<String> querySpaces, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        super(name, cacheable, cacheRegion, cacheMode, flushMode, readOnly, timeout, fetchSize, comment, hints);
        this.callableName = callableName;
        this.parameterStrategy = parameterStrategy;
        this.parameterMementos = parameterMementos;
        this.resultSetMappingNames = resultSetMappingNames;
        this.resultSetMappingClasses = resultSetMappingClasses;
        this.querySpaces = querySpaces;
    }

    @Override
    public String getCallableName() {
        return this.callableName;
    }

    @Override
    public List<NamedCallableQueryMemento.ParameterMemento> getParameterMementos() {
        return this.parameterMementos;
    }

    @Override
    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public String[] getResultSetMappingNames() {
        return this.resultSetMappingNames;
    }

    @Override
    public Class[] getResultSetMappingClasses() {
        return this.resultSetMappingClasses;
    }

    @Override
    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public ProcedureCall makeProcedureCall(SharedSessionContractImplementor session) {
        return new ProcedureCallImpl(session, this);
    }

    @Override
    public NamedQueryMemento makeCopy(String name) {
        return new NamedCallableQueryMementoImpl(name, this.callableName, this.parameterStrategy, this.parameterMementos, this.resultSetMappingNames, this.resultSetMappingClasses, this.querySpaces, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    @Override
    public void validate(QueryEngine queryEngine) {
    }

    public static class ParameterMementoImpl
    implements NamedCallableQueryMemento.ParameterMemento {
        private final Integer position;
        private final String name;
        private final ParameterMode mode;
        private final Class type;
        private final AllowableParameterType hibernateType;

        public ParameterMementoImpl(int position, String name, ParameterMode mode, Class type, AllowableParameterType hibernateType) {
            this.position = position;
            this.name = name;
            this.mode = mode;
            this.type = type;
            this.hibernateType = hibernateType;
        }

        public Integer getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public ParameterMode getMode() {
            return this.mode;
        }

        public Class getType() {
            return this.type;
        }

        public AllowableParameterType getHibernateType() {
            return this.hibernateType;
        }

        @Override
        public ProcedureParameterImplementor resolve(SharedSessionContractImplementor session) {
            throw new NotYetImplementedFor6Exception();
        }

        public static ParameterMementoImpl fromRegistration(ProcedureParameterImplementor registration) {
            return new ParameterMementoImpl(registration.getPosition(), registration.getName(), registration.getMode(), registration.getParameterType(), registration.getHibernateType());
        }
    }
}

