/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.hibernate.metamodel.mapping.JdbcMapping;

public enum CastType {
    STRING,
    BOOLEAN,
    INTEGER,
    LONG,
    FLOAT,
    DOUBLE,
    FIXED,
    DATE,
    TIME,
    TIMESTAMP,
    OFFSET_TIMESTAMP,
    ZONE_TIMESTAMP,
    NULL,
    OTHER;


    public static CastType from(Class javaClass) {
        if (String.class.equals((Object)javaClass)) {
            return STRING;
        }
        if (Boolean.class.equals((Object)javaClass) || Boolean.TYPE.equals(javaClass)) {
            return BOOLEAN;
        }
        if (Integer.class.equals((Object)javaClass) || Integer.TYPE.equals(javaClass)) {
            return INTEGER;
        }
        if (Long.class.equals((Object)javaClass) || Long.TYPE.equals(javaClass)) {
            return LONG;
        }
        if (Float.class.equals((Object)javaClass) || Float.TYPE.equals(javaClass)) {
            return FLOAT;
        }
        if (Double.class.equals((Object)javaClass) || Double.TYPE.equals(javaClass)) {
            return DOUBLE;
        }
        if (BigInteger.class.equals((Object)javaClass)) {
            return FIXED;
        }
        if (BigDecimal.class.equals((Object)javaClass)) {
            return FIXED;
        }
        if (LocalDate.class.equals((Object)javaClass)) {
            return DATE;
        }
        if (LocalTime.class.equals((Object)javaClass)) {
            return TIME;
        }
        if (LocalDateTime.class.equals((Object)javaClass)) {
            return TIMESTAMP;
        }
        if (OffsetDateTime.class.equals((Object)javaClass)) {
            return OFFSET_TIMESTAMP;
        }
        if (ZonedDateTime.class.equals((Object)javaClass)) {
            return ZONE_TIMESTAMP;
        }
        return OTHER;
    }

    public static CastType from(JdbcMapping jdbcMapping) {
        return jdbcMapping == null ? NULL : CastType.from(jdbcMapping.getJavaTypeDescriptor().getJavaType());
    }
}

