/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.query.hql.HqlLogger;
import org.jboss.logging.Logger;

public class HqlParseTreeBuilder {
    private static final Logger LOGGER = HqlLogger.subLogger("reservedWordAsIdentifier");
    private static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    public static final HqlParseTreeBuilder INSTANCE = new HqlParseTreeBuilder();

    public HqlLexer buildHqlLexer(String hql) {
        return new HqlLexer((CharStream)CharStreams.fromString((String)hql));
    }

    public HqlParser buildHqlParser(String hql, HqlLexer hqlLexer) {
        return new HqlParser((TokenStream)new CommonTokenStream((TokenSource)hqlLexer)){

            @Override
            protected void logUseOfReservedWordAsIdentifier(Token token) {
                if (DEBUG_ENABLED) {
                    LOGGER.debugf("Encountered use of reserved word as identifier : %s", (Object)token.getText());
                }
            }
        };
    }

    public HqlParser buildHqlParser(String hql) {
        return this.buildHqlParser(hql, this.buildHqlLexer(hql));
    }
}

