/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.hibernate.QueryException;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.internal.SqmTreePrinter;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmStatement;

public class StandardHqlTranslator
implements HqlTranslator {
    private final SqmCreationContext sqmCreationContext;
    private final SqmCreationOptions sqmCreationOptions;

    public StandardHqlTranslator(SqmCreationContext sqmCreationContext, SqmCreationOptions sqmCreationOptions) {
        this.sqmCreationContext = sqmCreationContext;
        this.sqmCreationOptions = sqmCreationOptions;
    }

    @Override
    public SqmStatement translate(String query) {
        HqlParser.StatementContext hqlParseTree = this.parseHql(query);
        try {
            SqmStatement sqmStatement = SemanticQueryBuilder.buildSemanticModel(hqlParseTree, this.sqmCreationOptions, this.sqmCreationContext);
            SqmTreePrinter.logTree(sqmStatement);
            return sqmStatement;
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InterpretationException(query, e);
        }
    }

    private HqlParser.StatementContext parseHql(String hql) {
        HqlLexer hqlLexer = HqlParseTreeBuilder.INSTANCE.buildHqlLexer(hql);
        HqlParser hqlParser = HqlParseTreeBuilder.INSTANCE.buildHqlParser(hql, hqlLexer);
        ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        hqlParser.removeErrorListeners();
        hqlParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            return hqlParser.statement();
        }
        catch (ParseCancellationException e) {
            hqlLexer.reset();
            hqlParser.reset();
            ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            hqlParser.addErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
            hqlParser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            return hqlParser.statement();
        }
    }
}

