/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryPlan;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SimpleHqlInterpretationImpl;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.jboss.logging.Logger;

public class QueryInterpretationCacheStandardImpl
implements QueryInterpretationCache {
    private static final Logger log = QueryLogger.subLogger("plan.cache");
    @Deprecated
    public static final int DEFAULT_PARAMETER_METADATA_MAX_COUNT = 128;
    public static final int DEFAULT_QUERY_PLAN_MAX_COUNT = 2048;
    private final BoundedConcurrentHashMap<QueryInterpretationCache.Key, QueryPlan> queryPlanCache;
    private final BoundedConcurrentHashMap<String, HqlInterpretation> hqlInterpretationCache;
    private final BoundedConcurrentHashMap<String, ParameterInterpretation> nativeQueryParamCache;

    public QueryInterpretationCacheStandardImpl(int maxQueryPlanCount) {
        log.debugf("Starting QueryPlanCache(%s)", maxQueryPlanCount);
        this.queryPlanCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.hqlInterpretationCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.nativeQueryParamCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    @Override
    public int getNumberOfCachedHqlInterpretations() {
        return this.hqlInterpretationCache.size();
    }

    @Override
    public int getNumberOfCachedQueryPlans() {
        return this.queryPlanCache.size();
    }

    @Override
    public SelectQueryPlan resolveSelectQueryPlan(QueryInterpretationCache.Key key, Supplier<SelectQueryPlan> creator) {
        log.tracef("QueryPlan#getSelectQueryPlan(%s)", (Object)key);
        SelectQueryPlan cached = (SelectQueryPlan)this.queryPlanCache.get(key);
        if (cached != null) {
            return cached;
        }
        SelectQueryPlan plan = creator.get();
        this.queryPlanCache.put(key, plan);
        return plan;
    }

    @Override
    public NonSelectQueryPlan getNonSelectQueryPlan(QueryInterpretationCache.Key key) {
        log.tracef("QueryPlan#getNonSelectQueryPlan(%s)", (Object)key);
        return null;
    }

    @Override
    public void cacheNonSelectQueryPlan(QueryInterpretationCache.Key key, NonSelectQueryPlan plan) {
        log.tracef("QueryPlan#cacheNonSelectQueryPlan(%s)", (Object)key);
    }

    @Override
    public HqlInterpretation resolveHqlInterpretation(String queryString, Function<String, SqmStatement<?>> creator) {
        ParameterMetadataImpl parameterMetadata;
        DomainParameterXref domainParameterXref;
        log.tracef("QueryPlan#resolveHqlInterpretation( `%s` )", (Object)queryString);
        HqlInterpretation cached = this.hqlInterpretationCache.get(queryString);
        if (cached != null) {
            return cached;
        }
        log.debugf("Creating and caching HqlInterpretation - %s", (Object)queryString);
        SqmStatement<?> sqmStatement = creator.apply(queryString);
        if (sqmStatement.getSqmParameters().isEmpty()) {
            domainParameterXref = DomainParameterXref.empty();
            parameterMetadata = ParameterMetadataImpl.EMPTY;
        } else {
            domainParameterXref = DomainParameterXref.from(sqmStatement);
            parameterMetadata = new ParameterMetadataImpl(domainParameterXref.getQueryParameters());
        }
        SimpleHqlInterpretationImpl interpretation = new SimpleHqlInterpretationImpl(sqmStatement, parameterMetadata, domainParameterXref);
        this.hqlInterpretationCache.put(queryString, interpretation);
        return interpretation;
    }

    @Override
    public ParameterInterpretation resolveNativeQueryParameters(String queryString, Function<String, ParameterInterpretation> creator) {
        log.tracef("QueryPlan#resolveNativeQueryParameters(%s)", (Object)queryString);
        return this.nativeQueryParamCache.computeIfAbsent(queryString, s -> {
            log.debugf("Creating and caching SqmStatement - %s", (Object)queryString);
            return (ParameterInterpretation)creator.apply(queryString);
        });
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        this.queryPlanCache.clear();
    }
}

