/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.persistence.TemporalType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;

public class QueryParameterBindingValidator {
    public static final QueryParameterBindingValidator INSTANCE = new QueryParameterBindingValidator();

    private QueryParameterBindingValidator() {
    }

    public void validate(AllowableParameterType paramType, Object bind) {
        this.validate(paramType, bind, null);
    }

    public void validate(AllowableParameterType paramType, Object bind, TemporalType temporalType) {
        if (bind == null || paramType == null) {
            return;
        }
        Class parameterType = paramType.getExpressableJavaTypeDescriptor().getJavaType();
        if (parameterType == null) {
            return;
        }
        if (Collection.class.isInstance(bind) && !Collection.class.isAssignableFrom(parameterType)) {
            this.validateCollectionValuedParameterBinding(parameterType, (Collection)bind, temporalType);
        } else if (bind.getClass().isArray()) {
            this.validateArrayValuedParameterBinding(parameterType, bind, temporalType);
        } else if (!QueryParameterBindingValidator.isValidBindValue(parameterType, bind, temporalType)) {
            throw new IllegalArgumentException(String.format("Parameter value [%s] did not match expected type [%s (%s)]", bind, parameterType.getName(), this.extractName(temporalType)));
        }
    }

    private String extractName(TemporalType temporalType) {
        return temporalType == null ? "n/a" : temporalType.name();
    }

    private void validateCollectionValuedParameterBinding(Class parameterType, Collection value, TemporalType temporalType) {
        for (Object element : value) {
            if (QueryParameterBindingValidator.isValidBindValue(parameterType, element, temporalType)) continue;
            throw new IllegalArgumentException(String.format("Parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), this.extractName(temporalType)));
        }
    }

    private static boolean isValidBindValue(Class expectedType, Object value, TemporalType temporalType) {
        if (expectedType.isPrimitive()) {
            if (expectedType == Boolean.TYPE) {
                return value instanceof Boolean;
            }
            if (expectedType == Character.TYPE) {
                return value instanceof Character;
            }
            if (expectedType == Byte.TYPE) {
                return value instanceof Byte;
            }
            if (expectedType == Short.TYPE) {
                return value instanceof Short;
            }
            if (expectedType == Integer.TYPE) {
                return value instanceof Integer;
            }
            if (expectedType == Long.TYPE) {
                return value instanceof Long;
            }
            if (expectedType == Float.TYPE) {
                return value instanceof Float;
            }
            if (expectedType == Double.TYPE) {
                return value instanceof Double;
            }
            return false;
        }
        if (value == null) {
            return true;
        }
        if (expectedType.isInstance(value)) {
            return true;
        }
        if (temporalType != null) {
            boolean bindIsTemporal;
            boolean parameterDeclarationIsTemporal = Date.class.isAssignableFrom(expectedType) || Calendar.class.isAssignableFrom(expectedType);
            boolean bl = bindIsTemporal = value instanceof Date || value instanceof Calendar;
            if (parameterDeclarationIsTemporal && bindIsTemporal) {
                return true;
            }
        }
        return false;
    }

    private void validateArrayValuedParameterBinding(Class parameterType, Object value, TemporalType temporalType) {
        if (!parameterType.isArray()) {
            throw new IllegalArgumentException(String.format("Encountered array-valued parameter binding, but was expecting [%s (%s)]", parameterType.getName(), this.extractName(temporalType)));
        }
        if (value.getClass().getComponentType().isPrimitive()) {
            if (!parameterType.getComponentType().isAssignableFrom(value.getClass().getComponentType())) {
                throw new IllegalArgumentException(String.format("Primitive array-valued parameter bind value type [%s] did not match expected type [%s (%s)]", value.getClass().getComponentType().getName(), parameterType.getName(), this.extractName(temporalType)));
            }
        } else {
            Object[] array;
            for (Object element : array = (Object[])value) {
                if (QueryParameterBindingValidator.isValidBindValue(parameterType.getComponentType(), element, temporalType)) continue;
                throw new IllegalArgumentException(String.format("Array-valued parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), this.extractName(temporalType)));
            }
        }
    }
}

