/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryConstructorReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryScalarReturn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.Limit;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.internal.NativeQueryReturnBuilder;
import org.hibernate.query.internal.NativeQueryReturnBuilderFetchImpl;
import org.hibernate.query.internal.NativeQueryReturnBuilderRootImpl;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sql.internal.NativeNonSelectQueryPlanImpl;
import org.hibernate.query.sql.internal.ParameterRecognizerImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sql.spi.NativeSelectQueryDefinition;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.query.sql.spi.NonSelectInterpretationsKey;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sql.spi.SelectInterpretationsKey;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.transform.ResultTransformer;

public class NativeQueryImpl<R>
extends AbstractQuery<R>
implements NativeQueryImplementor<R>,
ExecutionContext {
    private final String sqlString;
    private final ParameterMetadataImplementor parameterMetadata;
    private final List<QueryParameterImplementor<?>> occurrenceOrderedParamList;
    private final QueryParameterBindings parameterBindings;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();
    private Set<String> querySpaces;
    private List<NativeSQLQueryReturn> queryReturns;
    private List<NativeQueryReturnBuilder> queryReturnBuilders;
    private boolean autoDiscoverTypes;
    private Object collectionKey;
    private NativeQueryInterpreter nativeQueryInterpreter;

    public NativeQueryImpl(NamedNativeQueryMemento memento, SharedSessionContractImplementor session) {
        super(session);
        this.sqlString = memento.getSqlString();
        ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(session);
        this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
        this.occurrenceOrderedParamList = parameterInterpretation.getOccurrenceOrderedParameters();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
        this.applyOptions(memento);
    }

    public NativeQueryImpl(NamedNativeQueryMemento memento, Class<R> resultJavaType, SharedSessionContractImplementor session) {
        this(memento, session);
    }

    public NativeQueryImpl(NamedNativeQueryMemento memento, String resultSetMappingName, SharedSessionContractImplementor session) {
        this(memento, session);
    }

    private ParameterInterpretation resolveParameterInterpretation(SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        return interpretationCache.resolveNativeQueryParameters(this.sqlString, s -> {
            final ParameterRecognizerImpl parameterRecognizer = new ParameterRecognizerImpl(session.getFactory());
            session.getFactory().getServiceRegistry().getService(NativeQueryInterpreter.class).recognizeParameters(this.sqlString, parameterRecognizer);
            return new ParameterInterpretation(){

                @Override
                public List<QueryParameterImplementor<?>> getOccurrenceOrderedParameters() {
                    return parameterRecognizer.getParameterList();
                }

                @Override
                public ParameterMetadataImplementor toParameterMetadata(SharedSessionContractImplementor session1) {
                    return new ParameterMetadataImpl(parameterRecognizer.getPositionalQueryParameters(), parameterRecognizer.getNamedQueryParameters());
                }
            };
        });
    }

    protected void applyOptions(NamedNativeQueryMemento memento) {
        super.applyOptions(memento);
        this.querySpaces = CollectionHelper.makeCopy(memento.getQuerySpaces());
    }

    public NativeQueryImpl(String sqlString, SharedSessionContractImplementor session) {
        super(session);
        this.sqlString = sqlString;
        this.queryReturns = new ArrayList<NativeSQLQueryReturn>();
        this.querySpaces = new HashSet<String>();
        ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(session);
        this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
        this.occurrenceOrderedParamList = parameterInterpretation.getOccurrenceOrderedParameters();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
    }

    @Override
    public String getQueryString() {
        return this.sqlString;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public Callback getCallback() {
        throw new NotYetImplementedFor6Exception();
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.getQueryParameterBindings();
    }

    @Override
    public NamedNativeQueryMemento toMemento(String name) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    protected boolean canApplyAliasSpecificLockModes() {
        return false;
    }

    @Override
    protected void verifySettingLockMode() {
        throw new IllegalStateException("Illegal attempt to set lock mode on a native query");
    }

    @Override
    protected void verifySettingAliasSpecificLockModes() {
        throw new IllegalStateException("Illegal attempt to set lock mode on a native query");
    }

    @Override
    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    @Override
    public NativeQueryImplementor<R> setTupleTransformer(TupleTransformer transformer) {
        return (NativeQueryImplementor)super.setTupleTransformer(transformer);
    }

    @Override
    public NativeQueryImplementor<R> setResultListTransformer(ResultListTransformer transformer) {
        return (NativeQueryImplementor)super.setResultListTransformer(transformer);
    }

    @Override
    protected void prepareForExecution() {
        if (this.getSynchronizedQuerySpaces() != null && !this.getSynchronizedQuerySpaces().isEmpty()) {
            return;
        }
        if (this.shouldFlush()) {
            this.getSession().flush();
        }
    }

    private boolean shouldFlush() {
        if (this.getSession().isTransactionInProgress()) {
            FlushMode effectiveFlushMode = this.getHibernateFlushMode();
            if (effectiveFlushMode == null) {
                effectiveFlushMode = this.getSession().getHibernateFlushMode();
            }
            if (effectiveFlushMode == FlushMode.ALWAYS) {
                return true;
            }
            if (effectiveFlushMode == FlushMode.AUTO && this.getSession().getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<R> doList() {
        return this.resolveSelectQueryPlan().performList(this);
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        Object queryPlan = null;
        JdbcValuesMappingProducer resultSetMapping = this.getJdbcValuesMappingProducer();
        SelectInterpretationsKey cacheKey = this.generateSelectInterpretationsKey(resultSetMapping);
        if (cacheKey != null) {
            return this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan(cacheKey, this::createQueryPlan);
        }
        return this.createQueryPlan();
    }

    private NativeSelectQueryPlan<R> createQueryPlan() {
        RowTransformer rowTransformer = this.resolveRowTransformer();
        return this.getSessionFactory().getQueryEngine().getNativeQueryInterpreter().createQueryPlan(this.generateSelectQueryDefinition(), this.getSessionFactory());
    }

    private JdbcValuesMappingProducer getJdbcValuesMappingProducer() {
        throw new NotYetImplementedFor6Exception();
    }

    private RowTransformer resolveRowTransformer() {
        throw new NotYetImplementedFor6Exception();
    }

    private SelectInterpretationsKey generateSelectInterpretationsKey(JdbcValuesMappingProducer resultSetMapping) {
        if (!NativeQueryImpl.isCacheable(this)) {
            return null;
        }
        return new SelectInterpretationsKey(this.getQueryString(), resultSetMapping, this.getQueryOptions().getTupleTransformer(), this.getQueryOptions().getResultListTransformer());
    }

    private static boolean isCacheable(NativeQueryImpl query) {
        return !NativeQueryImpl.hasLimit(query.getQueryOptions().getLimit());
    }

    private static boolean hasLimit(Limit limit) {
        return limit.getFirstRow() != null || limit.getMaxRows() != null;
    }

    private NativeSelectQueryDefinition<R> generateSelectQueryDefinition() {
        return new NativeSelectQueryDefinition(){

            @Override
            public String getSqlString() {
                return NativeQueryImpl.this.getQueryString();
            }

            @Override
            public boolean isCallable() {
                return false;
            }

            @Override
            public List<QueryParameterImplementor<?>> getQueryParameterList() {
                return NativeQueryImpl.this.occurrenceOrderedParamList;
            }

            @Override
            public JdbcValuesMappingProducer getJdbcValuesMappingProducer() {
                return NativeQueryImpl.this.getJdbcValuesMappingProducer();
            }

            public RowTransformer getRowTransformer() {
                return NativeQueryImpl.this.resolveRowTransformer();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return NativeQueryImpl.this.querySpaces;
            }
        };
    }

    private void prepareQueryReturnsIfNecessary() {
        if (this.queryReturnBuilders != null) {
            if (!this.queryReturnBuilders.isEmpty()) {
                if (this.queryReturns != null) {
                    this.queryReturns.clear();
                    this.queryReturns = null;
                }
                this.queryReturns = new ArrayList<NativeSQLQueryReturn>();
                for (NativeQueryReturnBuilder builder : this.queryReturnBuilders) {
                    this.queryReturns.add(builder.buildReturn());
                }
                this.queryReturnBuilders.clear();
            }
            this.queryReturnBuilders = null;
        }
    }

    @Override
    protected ScrollableResultsImplementor doScroll(ScrollMode scrollMode) {
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    protected void beforeQuery(boolean txnRequired) {
        boolean noReturns;
        this.prepareQueryReturnsIfNecessary();
        boolean bl = noReturns = this.queryReturns == null || this.queryReturns.isEmpty();
        if (noReturns) {
            this.autoDiscoverTypes = true;
        } else {
            for (NativeSQLQueryReturn queryReturn : this.queryReturns) {
                if (queryReturn instanceof NativeSQLQueryScalarReturn) {
                    NativeSQLQueryScalarReturn scalar = (NativeSQLQueryScalarReturn)queryReturn;
                    if (scalar.getType() != null) continue;
                    this.autoDiscoverTypes = true;
                    break;
                }
                if (!NativeSQLQueryConstructorReturn.class.isInstance(queryReturn)) continue;
                this.autoDiscoverTypes = true;
                break;
            }
        }
        super.beforeQuery(txnRequired);
        if (this.getSynchronizedQuerySpaces() != null && !this.getSynchronizedQuerySpaces().isEmpty()) {
            return;
        }
        if (this.shouldFlush()) {
            this.getSession().flush();
        }
    }

    @Override
    protected int doExecuteUpdate() {
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        NonSelectInterpretationsKey cacheKey = this.generateNonSelectInterpretationsKey();
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getInterpretationCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = new NativeNonSelectQueryPlanImpl(this);
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getInterpretationCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    protected NonSelectInterpretationsKey generateNonSelectInterpretationsKey() {
        return new NonSelectInterpretationsKey(this.getQueryString(), this.getSynchronizedQuerySpaces());
    }

    @Override
    public NativeQueryImplementor setCollectionKey(Object key) {
        this.collectionKey = key;
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias) {
        return this.addScalar(columnAlias, null);
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias, BasicDomainType type) {
        this.addReturnBuilder(() -> new NativeSQLQueryScalarReturn(columnAlias, type));
        return this;
    }

    protected void addReturnBuilder(NativeQueryReturnBuilder builder) {
        if (this.queryReturnBuilders == null) {
            this.queryReturnBuilders = new ArrayList<NativeQueryReturnBuilder>();
        }
        this.queryReturnBuilders.add(builder);
    }

    @Override
    public NativeQuery.RootReturn addRoot(String tableAlias, String entityName) {
        NativeQueryReturnBuilderRootImpl builder = new NativeQueryReturnBuilderRootImpl(tableAlias, entityName);
        this.addReturnBuilder(builder);
        return builder;
    }

    @Override
    public NativeQuery.RootReturn addRoot(String tableAlias, Class entityType) {
        return this.addRoot(tableAlias, entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String entityName) {
        return this.addEntity(StringHelper.unqualify(entityName), entityName);
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName) {
        this.addRoot(tableAlias, entityName);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName, LockMode lockMode) {
        this.addRoot(tableAlias, entityName).setLockMode(lockMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(Class entityType) {
        return this.addEntity(entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class entityClass) {
        return this.addEntity(tableAlias, entityClass.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class entityClass, LockMode lockMode) {
        return this.addEntity(tableAlias, entityClass.getName(), lockMode);
    }

    @Override
    public NativeQuery.FetchReturn addFetch(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        NativeQueryReturnBuilderFetchImpl builder = new NativeQueryReturnBuilderFetchImpl(tableAlias, ownerTableAlias, joinPropertyName);
        this.addReturnBuilder(builder);
        return builder;
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path) {
        this.createFetchJoin(tableAlias, path);
        return this;
    }

    private NativeQuery.FetchReturn createFetchJoin(String tableAlias, String path) {
        int loc = path.indexOf(46);
        if (loc < 0) {
            throw new QueryException("not a property path: " + path);
        }
        String ownerTableAlias = path.substring(0, loc);
        String joinedPropertyName = path.substring(loc + 1);
        return this.addFetch(tableAlias, ownerTableAlias, joinedPropertyName);
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        this.addFetch(tableAlias, ownerTableAlias, joinPropertyName);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path, LockMode lockMode) {
        this.createFetchJoin(tableAlias, path).setLockMode(lockMode);
        return this;
    }

    @Override
    public Collection<String> getSynchronizedQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.addQuerySpaces(querySpace);
        return this;
    }

    protected void addQuerySpaces(String ... spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            Collections.addAll(this.querySpaces, spaces);
        }
    }

    protected void addQuerySpaces(Serializable ... spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            Collections.addAll(this.querySpaces, (String[])spaces);
        }
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityName(String entityName) throws MappingException {
        this.addQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityName).getQuerySpaces());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityClass(Class entityClass) throws MappingException {
        this.addQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityClass.getName()).getQuerySpaces());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(LockModeType lockModeType) {
        throw new IllegalStateException("Illegal attempt to set lock mode on a native SQL query");
    }

    public <T> T unwrap(Class<T> javaType) {
        if (javaType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (javaType.isAssignableFrom(ParameterMetadata.class)) {
            return (T)this.parameterMetadata;
        }
        if (javaType.isAssignableFrom(QueryParameterBindings.class)) {
            return (T)this.parameterBindings;
        }
        if (javaType.isAssignableFrom(EntityManager.class)) {
            return (T)this.getSession();
        }
        if (javaType.isAssignableFrom(EntityManagerFactory.class)) {
            return (T)this.getSession().getFactory();
        }
        throw new PersistenceException("Unrecognized unwrap type [" + javaType.getName() + "]");
    }

    @Override
    public NativeQueryImplementor<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addQueryHint(String hint) {
        super.addQueryHint(hint);
        return this;
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        super.collectHints(hints);
        this.putIfNotNull(hints, "org.hibernate.lockMode", this.getLockOptions().getLockMode());
    }

    @Override
    protected boolean applyNativeQueryLockMode(Object value) {
        if (value instanceof LockMode) {
            this.applyHibernateLockModeHint((LockMode)((Object)value));
        } else if (value instanceof LockModeType) {
            this.applyLockModeTypeHint((LockModeType)value);
        } else {
            throw new IllegalArgumentException(String.format("Native lock-mode hint [%s] must specify %s or %s.  Encountered type : %s", "org.hibernate.lockMode", LockMode.class.getName(), LockModeType.class.getName(), value.getClass().getName()));
        }
        return true;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(QueryParameter parameter, Object value) {
        super.setParameter((Parameter)parameter, value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        super.setParameter((QueryParameter)parameter, (Object)value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<Instant> param, Instant value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<LocalDateTime> param, LocalDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<ZonedDateTime> param, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<OffsetDateTime> param, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values, AllowableParameterType type) {
        return (NativeQueryImplementor)super.setParameterList(name, values, type);
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values, AllowableParameterType type) {
        return (NativeQueryImplementor)super.setParameterList(position, values, type);
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values, AllowableParameterType type) {
        return (NativeQueryImplementor)super.setParameterList(name, values, type);
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values, AllowableParameterType type) {
        return (NativeQueryImplementor)super.setParameterList(position, values, type);
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(QueryParameter parameter, Collection values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter param, Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setMaxResults(int maxResult) {
        super.setMaxResults(maxResult);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, AllowableParameterType type) {
        return (NativeQueryImplementor)super.setParameter((QueryParameter)parameter, (Object)value, type);
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value, AllowableParameterType type) {
        return (NativeQueryImplementor)super.setParameter(name, value, type);
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value, AllowableParameterType type) {
        return (NativeQueryImplementor)super.setParameter(position, value, type);
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values) {
        return (NativeQueryImplementor)super.setParameterList(position, values);
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values) {
        return (NativeQueryImplementor)super.setParameterList(position, values);
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values, Class javaType) {
        return (NativeQueryImplementor)super.setParameterList(name, values, javaType);
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values, Class javaType) {
        return (NativeQueryImplementor)super.setParameterList(position, values, javaType);
    }

    @Override
    public NativeQueryImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }
}

