/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingFunctionSqlAstExpression
implements SelfRenderingExpression,
Selectable,
SqlExpressable,
DomainResultProducer {
    private final FunctionRenderingSupport renderer;
    private final List<SqlAstNode> sqlAstArguments;
    private final AllowableFunctionReturnType<?> type;
    private final MappingModelExpressable<?> expressable;

    public SelfRenderingFunctionSqlAstExpression(FunctionRenderingSupport renderer, List<SqlAstNode> sqlAstArguments, AllowableFunctionReturnType<?> type, MappingModelExpressable<?> expressable) {
        this.renderer = renderer;
        this.sqlAstArguments = sqlAstArguments;
        this.type = type;
        this.expressable = expressable;
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this.expressable;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this){

            @Override
            public ValueExtractor getJdbcValueExtractor() {
                if (SelfRenderingFunctionSqlAstExpression.this.type instanceof SqlExpressable) {
                    return ((SqlExpressable)((Object)SelfRenderingFunctionSqlAstExpression.this.type)).getJdbcMapping().getJdbcValueExtractor();
                }
                if (SelfRenderingFunctionSqlAstExpression.this.expressable != null) {
                    return super.getJdbcValueExtractor();
                }
                throw new SemanticException("function return type is unknown, so function cannot occur in select");
            }
        };
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        if (this.type == null) {
            throw new SemanticException("function return type is unknown, so function cannot occur in select");
        }
        return new BasicResult(creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.type.getExpressableJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()).getValuesArrayPosition(), resultVariable, this.type.getExpressableJavaTypeDescriptor());
    }

    @Override
    public void renderToSql(SqlAppender sqlAppender, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        this.renderer.render(sqlAppender, this.sqlAstArguments, walker);
    }

    @Override
    public String getAlias(Dialect dialect) {
        return null;
    }

    @Override
    public String getAlias(Dialect dialect, Table table) {
        return null;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getTemplate(Dialect dialect, SqmFunctionRegistry functionRegistry) {
        return null;
    }

    @Override
    public String getText(Dialect dialect) {
        return null;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        if (this.type instanceof SqlExpressable) {
            return ((SqlExpressable)((Object)this.type)).getJdbcMapping();
        }
        throw new SemanticException("function return type is unknown, so function cannot occur in select");
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(this, this.type.getExpressableJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
    }
}

