/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingSqmFunction<T>
extends SqmFunction<T> {
    private final AllowableFunctionReturnType<T> impliedResultType;
    private final FunctionReturnTypeResolver returnTypeResolver;
    private final String name;
    private final FunctionRenderingSupport renderingSupport;
    private final List<SqmTypedNode<?>> arguments;
    private AllowableFunctionReturnType<?> resultType;

    public SelfRenderingSqmFunction(SqmFunctionDescriptor descriptor, FunctionRenderingSupport renderingSupport, List<SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(name, descriptor, impliedResultType, nodeBuilder);
        this.renderingSupport = renderingSupport;
        this.arguments = arguments;
        this.impliedResultType = impliedResultType;
        this.returnTypeResolver = returnTypeResolver;
        this.name = name;
    }

    @Override
    public List<SqmTypedNode<?>> getArguments() {
        return this.arguments;
    }

    public FunctionRenderingSupport getRenderingSupport() {
        return this.renderingSupport;
    }

    private static List<SqlAstNode> resolveSqlAstArguments(List<SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        if (sqmArguments == null || sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>();
        for (SqmTypedNode<?> sqmArgument : sqmArguments) {
            sqlAstArguments.add((SqlAstNode)((SqmVisitableNode)((Object)sqmArgument)).accept(walker));
        }
        return sqlAstArguments;
    }

    @Override
    public SelfRenderingFunctionSqlAstExpression convertToSqlAst(SqmToSqlAstConverter walker) {
        this.resolveResultType(walker.getCreationContext().getDomainModel().getTypeConfiguration());
        return new SelfRenderingFunctionSqlAstExpression(this.getRenderingSupport(), SelfRenderingSqmFunction.resolveSqlAstArguments(this.getArguments(), walker), this.resultType, this.getMappingModelExpressable(walker, this.resultType));
    }

    @Override
    public SqmExpressable<T> getNodeType() {
        SqmExpressable nodeType = super.getNodeType();
        if (nodeType == null) {
            this.resolveResultType(this.nodeBuilder().getTypeConfiguration());
        }
        return nodeType;
    }

    private void resolveResultType(TypeConfiguration typeConfiguration) {
        if (this.resultType == null) {
            this.resultType = this.returnTypeResolver.resolveFunctionReturnType(this.impliedResultType, this.getArguments(), typeConfiguration);
            this.setExpressableType(this.resultType);
        }
    }

    private MappingModelExpressable<?> getMappingModelExpressable(SqmToSqlAstConverter walker, AllowableFunctionReturnType<?> resultType) {
        MappingModelExpressable mapping = resultType instanceof MappingModelExpressable ? (MappingModelExpressable)((Object)resultType) : this.returnTypeResolver.resolveFunctionReturnType(() -> {
            try {
                return (BasicValuedMapping)walker.getCreationContext().getDomainModel().resolveMappingExpressable(this.getNodeType());
            }
            catch (Exception e) {
                return null;
            }
        }, SelfRenderingSqmFunction.resolveSqlAstArguments(this.arguments, walker));
        return mapping;
    }

    @Override
    public String getFunctionName() {
        return this.name;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
    }
}

