/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Tuple;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.query.spi.EntityGraphQueryHint;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.hql.spi.HqlQueryImplementor;
import org.hibernate.query.hql.spi.NamedHqlQueryMemento;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.internal.AggregatedSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.MultiTableDeleteQueryPlan;
import org.hibernate.query.sqm.internal.MultiTableUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SimpleDeleteQueryPlan;
import org.hibernate.query.sqm.internal.SimpleInsertQueryPlan;
import org.hibernate.query.sqm.internal.SimpleUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.BasicType;

public class QuerySqmImpl<R>
extends AbstractQuery<R>
implements HqlQueryImplementor<R>,
ExecutionContext {
    private final String hqlString;
    private final SqmStatement sqmStatement;
    private final Class resultType;
    private final ParameterMetadataImplementor parameterMetadata;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindingsImpl parameterBindings;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();

    public QuerySqmImpl(NamedHqlQueryMemento memento, Class<R> resultType, SharedSessionContractImplementor producer) {
        super(producer);
        this.hqlString = memento.getHqlString();
        SessionFactoryImplementor factory = producer.getFactory();
        this.sqmStatement = factory.getQueryEngine().getHqlTranslator().translate(this.hqlString);
        if (resultType != null && this.sqmStatement instanceof SqmDmlStatement) {
            throw new IllegalArgumentException("Non-select queries cannot be typed");
        }
        this.resultType = resultType;
        if (this.sqmStatement.getSqmParameters().isEmpty()) {
            this.domainParameterXref = DomainParameterXref.empty();
            this.parameterMetadata = ParameterMetadataImpl.EMPTY;
        } else {
            this.domainParameterXref = DomainParameterXref.from(this.sqmStatement);
            this.parameterMetadata = new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        }
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory());
        this.applyOptions(memento);
    }

    protected void applyOptions(NamedHqlQueryMemento memento) {
        super.applyOptions(memento);
        if (memento.getFirstResult() != null) {
            this.setFirstResult(memento.getFirstResult());
        }
        if (memento.getMaxResults() != null) {
            this.setMaxResults(memento.getMaxResults());
        }
        if (memento.getLockOptions() != null) {
            this.setLockOptions(memento.getLockOptions());
        }
        if (memento.getParameterTypes() != null) {
            for (Map.Entry<String, String> entry : memento.getParameterTypes().entrySet()) {
                QueryParameter parameter = this.parameterMetadata.getQueryParameter(entry.getKey());
                BasicType type = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(entry.getValue());
                parameter.applyAnticipatedType(type);
            }
        }
    }

    public QuerySqmImpl(String hqlString, HqlInterpretation hqlInterpretation, Class resultType, SharedSessionContractImplementor producer) {
        super(producer);
        this.hqlString = hqlString;
        this.resultType = resultType;
        this.sqmStatement = hqlInterpretation.getSqmStatement();
        if (resultType != null) {
            SqmUtil.verifyIsSelectStatement(this.sqmStatement);
            QuerySqmImpl.checkQueryReturnType((SqmSelectStatement)this.sqmStatement, resultType, producer.getFactory());
        }
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory());
    }

    public QuerySqmImpl(SqmStatement sqmStatement, Class resultType, SharedSessionContractImplementor producer) {
        super(producer);
        if (sqmStatement instanceof SqmSelectStatement) {
            SqmSelectStatement sqmSelectStatement = (SqmSelectStatement)sqmStatement;
            JpaQueryStructure sqmQuerySpec = sqmSelectStatement.getQuerySpec();
            List<SqmSelection> sqmSelections = ((SqmQuerySpec)sqmQuerySpec).getSelectClause().getSelections();
            List<SqmRoot> sqmRoots = ((SqmQuerySpec)sqmQuerySpec).getFromClause().getRoots();
            if (sqmRoots == null || sqmRoots.isEmpty()) {
                throw new IllegalArgumentException("Criteria did not define any query roots");
            }
            if (sqmSelections == null || sqmSelections.isEmpty()) {
                if (sqmRoots.size() == 1) {
                    SqmRoot sqmRoot = sqmRoots.get(0);
                    ((SqmQuerySpec)sqmQuerySpec).getSelectClause().add((SqmExpression)sqmRoot, (String)null);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if (resultType != null) {
                QuerySqmImpl.checkQueryReturnType((SqmSelectStatement)sqmStatement, resultType, producer.getFactory());
            }
        } else {
            assert (sqmStatement instanceof SqmDmlStatement);
            throw new IllegalArgumentException("Non-select queries cannot be typed");
        }
        this.hqlString = "<criteria>";
        this.sqmStatement = sqmStatement;
        this.resultType = resultType;
        this.domainParameterXref = DomainParameterXref.from(sqmStatement);
        this.parameterMetadata = !this.domainParameterXref.hasParameters() ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory());
    }

    private static <T> void checkQueryReturnType(SqmSelectStatement<T> sqm, Class<T> resultClass, SessionFactoryImplementor sessionFactory) {
        if (resultClass == null) {
            return;
        }
        List<SqmSelection> selections = ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections();
        if (!resultClass.isArray() && !Tuple.class.isAssignableFrom(resultClass)) {
            SqmParameter sqmParameter;
            if (selections.size() != 1) {
                String errorMessage = "Query result-type error - multiple selections: use Tuple or array";
                if (sessionFactory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled()) {
                    throw new IllegalArgumentException("Query result-type error - multiple selections: use Tuple or array");
                }
                throw new QueryTypeMismatchException("Query result-type error - multiple selections: use Tuple or array");
            }
            SqmSelection sqmSelection = selections.get(0);
            if (sqmSelection.getSelectableNode() instanceof SqmParameter && ((sqmParameter = (SqmParameter)sqmSelection.getSelectableNode()).getNodeType() == null || sqmParameter.getNodeType().getExpressableJavaTypeDescriptor() == null)) {
                return;
            }
            QuerySqmImpl.verifyResultType(resultClass, sqmSelection.getNodeType(), sessionFactory);
        }
    }

    private static <T> void verifyResultType(Class<T> resultClass, SqmExpressable<?> sqmExpressable, SessionFactoryImplementor sessionFactory) {
        assert (sqmExpressable != null);
        assert (sqmExpressable.getExpressableJavaTypeDescriptor() != null);
        if (!resultClass.isAssignableFrom(sqmExpressable.getExpressableJavaTypeDescriptor().getJavaType())) {
            String errorMessage = String.format("Specified result type [%s] did not match Query selection type [%s] - multiple selections: use Tuple or array", resultClass.getName(), sqmExpressable.getExpressableJavaTypeDescriptor().getJavaType().getName());
            if (sessionFactory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled()) {
                throw new IllegalArgumentException(errorMessage);
            }
            throw new QueryTypeMismatchException(errorMessage);
        }
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.parameterBindings;
    }

    private boolean isSelect() {
        return this.sqmStatement instanceof SqmSelectStatement;
    }

    @Override
    public String getQueryString() {
        return this.hqlString;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    @Override
    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.queryOptions.applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        GraphSemantic graphSemantic = GraphSemantic.fromJpaHintName(hintName);
        this.applyGraph((RootGraph)entityGraph, graphSemantic);
    }

    @Override
    public SqmStatement getSqmStatement() {
        return this.sqmStatement;
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        HashSet parameters = new HashSet();
        this.parameterMetadata.collectAllParameters(parameters::add);
        return parameters;
    }

    @Override
    protected boolean canApplyAliasSpecificLockModes() {
        return this.isSelect();
    }

    @Override
    protected void verifySettingLockMode() {
        if (!this.isSelect()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on a non-SELECT query");
        }
    }

    @Override
    protected void verifySettingAliasSpecificLockModes() {
        this.verifySettingLockMode();
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.parameterMetadata)) {
            return (T)this.parameterMetadata;
        }
        if (cls.isInstance(this.parameterBindings)) {
            return (T)this.parameterBindings;
        }
        if (cls.isInstance(this.sqmStatement)) {
            return (T)this.sqmStatement;
        }
        if (cls.isInstance(this.queryOptions)) {
            return (T)this.queryOptions;
        }
        if (cls.isInstance(this.queryOptions.getAppliedGraph())) {
            return (T)this.queryOptions.getAppliedGraph();
        }
        if (EntityGraphQueryHint.class.isAssignableFrom(cls)) {
            return (T)new EntityGraphQueryHint(this.queryOptions.getAppliedGraph());
        }
        throw new PersistenceException("Unrecognized unwrap type [" + cls.getName() + "]");
    }

    @Override
    protected boolean applyNativeQueryLockMode(Object value) {
        throw new IllegalStateException("Illegal attempt to set lock mode on non-native query via hint; use Query#setLockMode instead");
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        super.collectHints(hints);
        if (this.queryOptions.getAppliedGraph() != null) {
            hints.put(this.queryOptions.getAppliedGraph().getSemantic().getJpaHintName(), this.queryOptions.getAppliedGraph().getGraph());
        }
    }

    @Override
    protected List<R> doList() {
        SqmUtil.verifyIsSelectStatement(this.getSqmStatement());
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getLockOptions().findGreatestLockMode()));
        return this.resolveSelectQueryPlan().performList(this);
    }

    private boolean requiresTxn(LockMode lockMode) {
        return lockMode != null && lockMode.greaterThan(LockMode.READ);
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.generateFrom(this);
        if (cacheKey != null) {
            return this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan(cacheKey, this::buildSelectQueryPlan);
        }
        return this.buildSelectQueryPlan();
    }

    private SelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement[] concreteSqmStatements = QuerySplitter.split((SqmSelectStatement)this.getSqmStatement(), this.getSessionFactory());
        if (concreteSqmStatements.length > 1) {
            return this.buildAggregatedSelectQueryPlan(concreteSqmStatements);
        }
        return this.buildConcreteSelectQueryPlan(concreteSqmStatements[0], this.getResultType(), this.getQueryOptions());
    }

    private SelectQueryPlan<R> buildAggregatedSelectQueryPlan(SqmSelectStatement[] concreteSqmStatements) {
        SelectQueryPlan[] aggregatedQueryPlans = new SelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteSelectQueryPlan(concreteSqmStatements[i], this.getResultType(), this.getQueryOptions());
        }
        return new AggregatedSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    private SelectQueryPlan<R> buildConcreteSelectQueryPlan(SqmSelectStatement concreteSqmStatement, Class<R> resultType, QueryOptions queryOptions) {
        return new ConcreteSqmSelectQueryPlan<R>(concreteSqmStatement, this.domainParameterXref, resultType, queryOptions);
    }

    @Override
    protected ScrollableResultsImplementor doScroll(ScrollMode scrollMode) {
        SqmUtil.verifyIsSelectStatement(this.getSqmStatement());
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getLockOptions().findGreatestLockMode()));
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    protected int doExecuteUpdate() {
        SqmUtil.verifyIsNonSelectStatement(this.getSqmStatement());
        this.getSession().prepareForQueryExecution(true);
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        QueryInterpretationCache.Key cacheKey = SqmInterpretationsKey.generateNonSelectKey(this);
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getInterpretationCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.buildNonSelectQueryPlan();
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getInterpretationCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    private NonSelectQueryPlan buildNonSelectQueryPlan() {
        if (this.getSqmStatement() instanceof SqmDeleteStatement) {
            return this.buildDeleteQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmUpdateStatement) {
            return this.buildUpdateQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmInsertStatement) {
            return this.buildInsertQueryPlan();
        }
        throw new NotYetImplementedException("Query#executeUpdate for Statements of type [" + this.getSqmStatement() + "not yet supported");
    }

    private NonSelectQueryPlan buildDeleteQueryPlan() {
        SqmDeleteStatement sqmDelete = (SqmDeleteStatement)this.getSqmStatement();
        String entityNameToDelete = ((SqmRoot)sqmDelete.getTarget()).getReferencedPathSource().getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getDomainModel().findEntityDescriptor(entityNameToDelete);
        SqmMultiTableMutationStrategy multiTableStrategy = entityDescriptor.getSqmMultiTableMutationStrategy();
        if (multiTableStrategy == null) {
            return new SimpleDeleteQueryPlan(entityDescriptor, sqmDelete, this.domainParameterXref);
        }
        return new MultiTableDeleteQueryPlan(sqmDelete, this.domainParameterXref, multiTableStrategy);
    }

    private NonSelectQueryPlan buildUpdateQueryPlan() {
        SqmUpdateStatement sqmUpdate = (SqmUpdateStatement)this.getSqmStatement();
        String entityNameToUpdate = ((SqmRoot)sqmUpdate.getTarget()).getReferencedPathSource().getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getDomainModel().findEntityDescriptor(entityNameToUpdate);
        SqmMultiTableMutationStrategy multiTableStrategy = entityDescriptor.getSqmMultiTableMutationStrategy();
        if (multiTableStrategy == null) {
            return new SimpleUpdateQueryPlan(sqmUpdate, this.domainParameterXref);
        }
        return new MultiTableUpdateQueryPlan(sqmUpdate, this.domainParameterXref, multiTableStrategy);
    }

    private NonSelectQueryPlan buildInsertQueryPlan() {
        SqmInsertStatement sqmInsert = (SqmInsertStatement)this.getSqmStatement();
        return new SimpleInsertQueryPlan(sqmInsert, this.domainParameterXref);
    }

    @Override
    public Callback getCallback() {
        return afterLoadAction -> {};
    }

    @Override
    public NamedHqlQueryMemento toMemento(String name) {
        return new NamedHqlQueryMementoImpl(name, this.hqlString, this.getFirstResult(), this.getMaxResults(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), Collections.emptyMap(), this.getHints());
    }
}

