/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelHelper;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.sql.SimpleSqmDeleteTranslation;
import org.hibernate.query.sqm.sql.SimpleSqmDeleteTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstDeleteTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class SimpleDeleteQueryPlan
implements NonSelectQueryPlan {
    private final EntityMappingType entityDescriptor;
    private final SqmDeleteStatement sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private JdbcDelete jdbcDelete;
    private SimpleSqmDeleteTranslation sqmInterpretation;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref;

    public SimpleDeleteQueryPlan(EntityMappingType entityDescriptor, SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref) {
        assert (entityDescriptor.getEntityName().equals(((SqmRoot)sqmDelete.getTarget()).getEntityName()));
        this.entityDescriptor = entityDescriptor;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
    }

    @Override
    public int executeUpdate(ExecutionContext executionContext) {
        boolean missingRestriction;
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        if (this.jdbcDelete == null) {
            QueryEngine queryEngine = factory.getQueryEngine();
            SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
            SimpleSqmDeleteTranslator translator = translatorFactory.createSimpleDeleteTranslator(executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), factory);
            this.sqmInterpretation = translator.translate(this.sqmDelete);
            JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
            SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
            SqlAstDeleteTranslator sqlAstTranslator = sqlAstTranslatorFactory.buildDeleteTranslator(factory);
            this.jdbcDelete = sqlAstTranslator.translate(this.sqmInterpretation.getSqlAst());
            this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, this.sqmInterpretation::getJdbcParamsBySqmParam);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getDomainModel(), this.sqmInterpretation.getFromClauseAccess()::findTableGroup, executionContext.getSession());
        boolean bl = missingRestriction = this.sqmDelete.getWhereClause() == null || this.sqmDelete.getWhereClause().getPredicate() == null;
        if (missingRestriction) {
            assert (this.domainParameterXref.getSqmParameterCount() == 0);
            assert (this.jdbcParamsXref.isEmpty());
            assert (jdbcParameterBindings.getBindings().size() == 0);
        }
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            if (missingRestriction) {
                return null;
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            Expression fkColumnExpression = MappingModelHelper.buildColumnReferenceExpression(fkDescriptor, null, factory);
            QuerySpec matchingIdSubQuery = new QuerySpec(false);
            Expression fkTargetColumnExpression = MappingModelHelper.buildColumnReferenceExpression(fkDescriptor, this.sqmInterpretation.getSqlExpressionResolver(), factory);
            matchingIdSubQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, fkTargetColumnExpression));
            matchingIdSubQuery.getFromClause().addRoot(new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, this.sqmInterpretation.getSqlAst().getTargetTable()));
            matchingIdSubQuery.applyPredicate(this.sqmInterpretation.getSqlAst().getRestriction());
            return new InSubQueryPredicate(fkColumnExpression, matchingIdSubQuery, false);
        }, missingRestriction ? JdbcParameterBindings.NO_BINDINGS : jdbcParameterBindings, executionContext);
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

