/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SimpleSqmUpdateTranslation;
import org.hibernate.query.sqm.sql.SimpleSqmUpdateTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.SqlAstUpdateTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class SimpleUpdateQueryPlan
implements NonSelectQueryPlan {
    private final SqmUpdateStatement sqmUpdate;
    private final DomainParameterXref domainParameterXref;
    private JdbcUpdate jdbcUpdate;
    private FromClauseAccess tableGroupAccess;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref;

    public SimpleUpdateQueryPlan(SqmUpdateStatement sqmUpdate, DomainParameterXref domainParameterXref) {
        this.sqmUpdate = sqmUpdate;
        this.domainParameterXref = domainParameterXref;
    }

    @Override
    public int executeUpdate(ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        if (this.jdbcUpdate == null) {
            QueryEngine queryEngine = factory.getQueryEngine();
            SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
            SimpleSqmUpdateTranslator translator = translatorFactory.createSimpleUpdateTranslator(executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), factory);
            SimpleSqmUpdateTranslation sqmInterpretation = translator.translate(this.sqmUpdate);
            this.tableGroupAccess = translator.getFromClauseAccess();
            this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
            JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
            SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
            SqlAstUpdateTranslator sqlAstTranslator = sqlAstTranslatorFactory.buildUpdateTranslator(factory);
            this.jdbcUpdate = sqlAstTranslator.translate(sqmInterpretation.getSqlAst());
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getDomainModel(), this.tableGroupAccess::findTableGroup, executionContext.getSession());
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcUpdate, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

