/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.function.Function;
import javax.persistence.metamodel.Bindable;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.AnyMappingSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.DomainModelHelper;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.BasicType;

public class SqmMappingModelHelper {
    private SqmMappingModelHelper() {
    }

    public static EntityPersister resolveEntityPersister(EntityDomainType<?> entityType, SessionFactoryImplementor sessionFactory) {
        String hibernateEntityName = entityType.getHibernateEntityName();
        return sessionFactory.getMetamodel().entityPersister(hibernateEntityName);
    }

    public static <J> SqmPathSource<J> resolveSqmPathSource(String name, DomainType<J> valueDomainType, Bindable.BindableType jpaBindableType) {
        if (valueDomainType instanceof BasicDomainType) {
            return new BasicSqmPathSource(name, (BasicDomainType)valueDomainType, jpaBindableType);
        }
        if (valueDomainType instanceof AnyMappingDomainType) {
            return new AnyMappingSqmPathSource(name, (AnyMappingDomainType)valueDomainType, jpaBindableType);
        }
        if (valueDomainType instanceof EmbeddableDomainType) {
            return new EmbeddedSqmPathSource(name, (EmbeddableDomainType)valueDomainType, jpaBindableType);
        }
        if (valueDomainType instanceof EntityDomainType) {
            return new EntitySqmPathSource(name, (EntityDomainType)valueDomainType, jpaBindableType);
        }
        throw new IllegalArgumentException("Unrecognized value type Java-type [" + valueDomainType.getTypeName() + "] for plural attribute value");
    }

    public static MappingModelExpressable resolveMappingModelExpressable(SqmTypedNode<?> sqmNode, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator) {
        if (sqmNode instanceof SqmPath) {
            return SqmMappingModelHelper.resolveSqmPath((SqmPath)sqmNode, domainModel, tableGroupLocator);
        }
        SqmExpressable<?> nodeType = sqmNode.getNodeType();
        if (nodeType instanceof BasicType) {
            return (BasicType)nodeType;
        }
        throw new NotYetImplementedFor6Exception(DomainModelHelper.class);
    }

    private static ModelPart resolveSqmPath(SqmPath<?> sqmPath, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator) {
        if (sqmPath instanceof SqmTreatedPath) {
            SqmTreatedPath treatedPath = (SqmTreatedPath)sqmPath;
            EntityDomainType treatTargetType = treatedPath.getTreatTarget();
            return domainModel.findEntityDescriptor(treatTargetType.getHibernateEntityName());
        }
        if (sqmPath.getLhs() instanceof SqmTreatedPath) {
            SqmTreatedPath treatedPath = (SqmTreatedPath)sqmPath.getLhs();
            EntityDomainType treatTargetType = treatedPath.getTreatTarget();
            EntityPersister container = domainModel.findEntityDescriptor(treatTargetType.getHibernateEntityName());
            return container.findSubPart(sqmPath.getNavigablePath().getLocalName(), container);
        }
        TableGroup lhsTableGroup = tableGroupLocator.apply(sqmPath.getLhs().getNavigablePath());
        return lhsTableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
    }

    public static EntityMappingType resolveExplicitTreatTarget(SqmPath<?> sqmPath, SqmToSqlAstConverter converter) {
        if (sqmPath instanceof SqmTreatedPath) {
            SqmTreatedPath treatedPath = (SqmTreatedPath)sqmPath;
            return SqmMappingModelHelper.resolveEntityPersister(treatedPath.getTreatTarget(), converter.getCreationContext().getSessionFactory());
        }
        return null;
    }
}

