/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Locale;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteConsumer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCoalesce;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPathEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmRestrictedSubQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmGroupByClause;
import org.hibernate.query.sqm.tree.select.SqmHavingClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.jboss.logging.Logger;

public class SqmTreePrinter
implements SemanticQueryWalker<Object> {
    private static final Logger log = Logger.getLogger(SqmTreePrinter.class);
    private static final Logger LOGGER = QueryLogger.subLogger("sqm.ast");
    private static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 2;

    public static void logTree(SqmQuerySpec sqmQuerySpec, String header) {
        if (!DEBUG_ENABLED) {
            return;
        }
        SqmTreePrinter treePrinter = new SqmTreePrinter();
        treePrinter.visitQuerySpec(sqmQuerySpec);
        String title = header != null ? header : "SqmQuerySpec Tree";
        LOGGER.debugf("%s :%n%s", (Object)title, (Object)treePrinter.buffer.toString());
    }

    public static void logTree(SqmStatement sqmStatement) {
        if (!DEBUG_ENABLED) {
            return;
        }
        SqmTreePrinter printer = new SqmTreePrinter();
        if (sqmStatement instanceof SqmSelectStatement) {
            printer.visitSelectStatement((SqmSelectStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmDeleteStatement) {
            printer.visitDeleteStatement((SqmDeleteStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmUpdateStatement) {
            printer.visitUpdateStatement((SqmUpdateStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmInsertSelectStatement) {
            printer.visitInsertSelectStatement((SqmInsertSelectStatement)sqmStatement);
        }
        LOGGER.debugf("SqmStatement Tree :%n%s", (Object)printer.buffer.toString());
    }

    private void processStanza(String name, Runnable continuation) {
        this.processStanza(name, false, continuation);
    }

    private void processStanza(String name, String description, Runnable continuation) {
        this.processStanza(name, description, false, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStanza(String name, boolean indentContinuation, Runnable continuation) {
        this.logWithIndentation("-> [%s]", (Object)name);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            continuation.run();
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error processing stanza {%s}", (Object)name);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("<- [%s]", (Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStanza(String name, String description, boolean indentContinuation, Runnable continuation) {
        String stanzaLabel = description == null ? "[" + name + ']' : "[" + name + "] - " + description;
        this.logWithIndentation("-> " + stanzaLabel);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            continuation.run();
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error processing stanza {%s}", (Object)name);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("<- " + stanzaLabel);
    }

    private void logWithIndentation(Object line) {
        this.pad(this.depth);
        this.buffer.append(line).append(System.lineSeparator());
    }

    private void pad(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.buffer.append("  ");
        }
    }

    private void logWithIndentation(String pattern, Object arg1) {
        this.logWithIndentation(String.format(pattern, arg1));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2) {
        this.logWithIndentation(String.format(pattern, arg1, arg2));
    }

    private void logWithIndentation(String pattern, Object ... args) {
        this.logWithIndentation(String.format(pattern, args));
    }

    private void logIndented(String line) {
        ++this.depth;
        this.logWithIndentation(line);
        --this.depth;
    }

    private void logIndented(String pattern, Object arg) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, arg));
        --this.depth;
    }

    private void logIndented(String pattern, Object arg1, Object arg2) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, arg1, arg2));
        --this.depth;
    }

    private void logIndented(String pattern, Object ... args) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, args));
        --this.depth;
    }

    @Override
    public Object visitDeleteStatement(SqmDeleteStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("delete", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath().getFullPath());
                this.visitWhereClause(statement.getWhereClause());
            });
        }
        return null;
    }

    @Override
    public Object visitInsertSelectStatement(SqmInsertSelectStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("insert", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath().getFullPath());
                this.processStanza("into", () -> statement.getInsertionTargetPaths().forEach(sqmPath -> sqmPath.accept(this)));
                this.visitQuerySpec(statement.getSelectQuerySpec());
            });
        }
        return null;
    }

    @Override
    public Object visitInsertValuesStatement(SqmInsertValuesStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("insert", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath().getFullPath());
                this.processStanza("into", () -> statement.getInsertionTargetPaths().forEach(sqmPath -> sqmPath.accept(this)));
            });
        }
        return null;
    }

    @Override
    public Object visitSelectStatement(SqmSelectStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("select", () -> this.visitQuerySpec((SqmQuerySpec)statement.getQuerySpec()));
        }
        return null;
    }

    @Override
    public Object visitCteStatement(SqmCteStatement sqmCteStatement) {
        if (DEBUG_ENABLED) {
            this.logIndented("cte");
        }
        return null;
    }

    @Override
    public Object visitCteConsumer(SqmCteConsumer consumer) {
        return null;
    }

    @Override
    public Object visitUpdateStatement(SqmUpdateStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("update", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath().getFullPath());
                this.visitSetClause(statement.getSetClause());
                this.visitWhereClause(statement.getWhereClause());
            });
        }
        return null;
    }

    @Override
    public Object visitSetClause(SqmSetClause setClause) {
        this.processStanza("set", () -> setClause.getAssignments().forEach(this::visitAssignment));
        return null;
    }

    @Override
    public Object visitAssignment(SqmAssignment assignment) {
        this.processStanza("assignment", () -> {
            this.logWithIndentation("=");
            ++this.depth;
            this.logWithIndentation("[%s]", (Object)assignment.getTargetPath().getNavigablePath());
            assignment.getValue().accept(this);
            --this.depth;
        });
        return null;
    }

    @Override
    public Object visitQuerySpec(SqmQuerySpec querySpec) {
        this.processStanza("query-spec", () -> {
            this.visitSelectClause(querySpec.getSelectClause());
            this.visitFromClause(querySpec.getFromClause());
            this.visitGroupByClause(querySpec.getGroupByClause());
            this.visitHavingClause(querySpec.getHavingClause());
            this.visitWhereClause(querySpec.getWhereClause());
            this.visitOrderByClause(querySpec.getOrderByClause());
            this.visitLimitExpression(querySpec.getLimitExpression());
            this.visitOffsetExpression(querySpec.getOffsetExpression());
        });
        return null;
    }

    @Override
    public Object visitGroupByClause(SqmGroupByClause clause) {
        if (clause != null) {
            this.processStanza("group-by", () -> clause.visitGroupings(this::visitGrouping));
        }
        return null;
    }

    @Override
    public Object visitGrouping(SqmGroupByClause.SqmGrouping grouping) {
        this.processStanza("grouping", () -> grouping.getExpression().accept(this));
        return null;
    }

    @Override
    public Object visitHavingClause(SqmHavingClause clause) {
        if (clause != null) {
            this.processStanza("having", () -> clause.getPredicate().accept(this));
        }
        return null;
    }

    @Override
    public Object visitFromClause(SqmFromClause fromClause) {
        this.processStanza("from", () -> fromClause.visitRoots(this::visitRootPath));
        return null;
    }

    @Override
    public Object visitRootPath(SqmRoot sqmRoot) {
        this.processStanza("root", '`' + sqmRoot.getNavigablePath().getFullPath() + '`', () -> this.processJoins(sqmRoot));
        return null;
    }

    private void processJoins(SqmFrom<?, ?> sqmFrom) {
        if (!sqmFrom.hasJoins()) {
            return;
        }
        this.processStanza("joins", () -> sqmFrom.visitSqmJoins(sqmJoin -> sqmJoin.accept(this)));
    }

    @Override
    public Object visitCrossJoin(SqmCrossJoin joinedFromElement) {
        this.processStanza("cross", '`' + joinedFromElement.getNavigablePath().getFullPath() + '`', () -> this.processJoins(joinedFromElement));
        return null;
    }

    @Override
    public Object visitQualifiedEntityJoin(SqmEntityJoin joinedFromElement) {
        this.processStanza("entity", '`' + joinedFromElement.getNavigablePath().getFullPath() + '`', () -> {
            if (joinedFromElement.getJoinPredicate() != null) {
                this.processStanza("on", () -> joinedFromElement.getJoinPredicate().accept(this));
            }
            this.processJoins(joinedFromElement);
        });
        return null;
    }

    @Override
    public Object visitQualifiedAttributeJoin(SqmAttributeJoin joinedFromElement) {
        this.processStanza("attribute", '`' + joinedFromElement.getNavigablePath().getFullPath() + '`', () -> {
            this.logIndented("[fetched = " + joinedFromElement.isFetched() + ']');
            if (joinedFromElement.getJoinPredicate() != null) {
                this.processStanza("on", () -> joinedFromElement.getJoinPredicate().accept(this));
            }
            this.processJoins(joinedFromElement);
        });
        return null;
    }

    @Override
    public Object visitBasicValuedPath(SqmBasicValuedSimplePath path) {
        this.logWithIndentation("-> [basic-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    @Override
    public Object visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath path) {
        this.logWithIndentation("-> [embedded-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    @Override
    public Object visitEntityValuedPath(SqmEntityValuedSimplePath path) {
        this.logWithIndentation("-> [entity-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    @Override
    public Object visitPluralValuedPath(SqmPluralValuedSimplePath path) {
        this.logWithIndentation("-> [plural-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    @Override
    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath path) {
        return null;
    }

    @Override
    public Object visitTreatedPath(SqmTreatedPath sqmTreatedPath) {
        return null;
    }

    @Override
    public Object visitCorrelation(SqmCorrelation correlation) {
        return null;
    }

    @Override
    public Object visitSelectClause(SqmSelectClause selectClause) {
        this.processStanza(selectClause.isDistinct() ? "select(distinct)" : "select", () -> selectClause.getSelections().forEach(this::visitSelection));
        return null;
    }

    @Override
    public Object visitSelection(SqmSelection selection) {
        this.processStanza(selection.getAlias() == null ? "selection" : "selection(" + selection.getAlias() + ")", () -> selection.getSelectableNode().accept(this));
        return null;
    }

    @Override
    public Object visitValues(SqmValues values) {
        return null;
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        this.logWithIndentation("?%s", (Object)expression.getPosition());
        return null;
    }

    @Override
    public Object visitNamedParameterExpression(SqmNamedParameter expression) {
        this.logWithIndentation(":%s", (Object)expression.getName());
        return null;
    }

    @Override
    public Object visitJpaCriteriaParameter(JpaCriteriaParameter expression) {
        return null;
    }

    @Override
    public Object visitEntityTypeLiteralExpression(SqmLiteralEntityType expression) {
        return null;
    }

    @Override
    public Object visitParameterizedEntityTypeExpression(SqmParameterizedEntityType expression) {
        return null;
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation expression) {
        return null;
    }

    @Override
    public Object visitFunction(SqmFunction tSqmFunction) {
        return null;
    }

    @Override
    public Object visitCoalesce(SqmCoalesce sqmCoalesce) {
        return null;
    }

    @Override
    public Object visitToDuration(SqmToDuration toDuration) {
        return null;
    }

    @Override
    public Object visitByUnit(SqmByUnit sqmByUnit) {
        return null;
    }

    @Override
    public Object visitExtractUnit(SqmExtractUnit extractUnit) {
        return null;
    }

    @Override
    public Object visitFormat(SqmFormat sqmFormat) {
        return null;
    }

    @Override
    public Object visitCastTarget(SqmCastTarget sqmCastTarget) {
        return null;
    }

    @Override
    public Object visitTrimSpecification(SqmTrimSpecification trimSpecification) {
        return null;
    }

    @Override
    public Object visitDistinct(SqmDistinct distinct) {
        return null;
    }

    @Override
    public Object visitDurationUnit(SqmDurationUnit durationUnit) {
        return null;
    }

    @Override
    public Object visitStar(SqmStar sqmStar) {
        return null;
    }

    @Override
    public Object visitWhereClause(SqmWhereClause whereClause) {
        if (whereClause != null && whereClause.getPredicate() != null) {
            this.processStanza("where", () -> whereClause.getPredicate().accept(this));
        }
        return null;
    }

    @Override
    public Object visitGroupedPredicate(SqmGroupedPredicate predicate) {
        this.processStanza("grouped", () -> {
            ++this.depth;
            predicate.getSubPredicate().accept(this);
            --this.depth;
        });
        return null;
    }

    @Override
    public Object visitAndPredicate(SqmAndPredicate predicate) {
        this.processStanza("and", () -> {
            predicate.getLeftHandPredicate().accept(this);
            predicate.getRightHandPredicate().accept(this);
        });
        return null;
    }

    @Override
    public Object visitOrPredicate(SqmOrPredicate predicate) {
        this.processStanza("or", () -> {
            predicate.getLeftHandPredicate().accept(this);
            predicate.getRightHandPredicate().accept(this);
        });
        return null;
    }

    @Override
    public Object visitComparisonPredicate(SqmComparisonPredicate predicate) {
        this.processStanza(predicate.isNegated() ? predicate.getSqmOperator().negated().name() : predicate.getSqmOperator().name(), () -> {
            ++this.depth;
            try {
                predicate.getLeftHandExpression().accept(this);
                predicate.getRightHandExpression().accept(this);
            }
            finally {
                --this.depth;
            }
        });
        return null;
    }

    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-empty" : "is-empty", () -> {
            ++this.depth;
            predicate.getPluralPath().accept(this);
            --this.depth;
        });
        return null;
    }

    @Override
    public Object visitIsNullPredicate(SqmNullnessPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-null" : "is-null", true, () -> predicate.getExpression().accept(this));
        return null;
    }

    @Override
    public Object visitBetweenPredicate(SqmBetweenPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-between" : "is-between", () -> {
            predicate.getExpression().accept(this);
            predicate.getLowerBound().accept(this);
            predicate.getUpperBound().accept(this);
        });
        return null;
    }

    @Override
    public Object visitLikePredicate(SqmLikePredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-like" : "is-like", () -> {
            predicate.getPattern().accept(this);
            predicate.getMatchExpression().accept(this);
            predicate.getEscapeCharacter().accept(this);
        });
        return null;
    }

    @Override
    public Object visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        return null;
    }

    @Override
    public Object visitNegatedPredicate(SqmNegatedPredicate predicate) {
        return null;
    }

    @Override
    public Object visitInListPredicate(SqmInListPredicate predicate) {
        return null;
    }

    @Override
    public Object visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
        return null;
    }

    @Override
    public Object visitBooleanExpressionPredicate(SqmBooleanExpressionPredicate predicate) {
        return null;
    }

    @Override
    public Object visitExistsPredicate(SqmExistsPredicate sqmExistsPredicate) {
        return null;
    }

    @Override
    public Object visitOrderByClause(SqmOrderByClause orderByClause) {
        return null;
    }

    @Override
    public Object visitSortSpecification(SqmSortSpecification sortSpecification) {
        return null;
    }

    @Override
    public Object visitOffsetExpression(SqmExpression expression) {
        return null;
    }

    @Override
    public Object visitLimitExpression(SqmExpression expression) {
        return null;
    }

    @Override
    public Object visitPluralAttributeSizeFunction(SqmCollectionSize function) {
        return null;
    }

    @Override
    public Object visitMapEntryFunction(SqmMapEntryReference function) {
        return null;
    }

    @Override
    public Object visitMaxElementPath(SqmMaxElementPath binding) {
        return null;
    }

    @Override
    public Object visitMinElementPath(SqmMinElementPath path) {
        return null;
    }

    @Override
    public Object visitMaxIndexPath(SqmMaxIndexPath path) {
        return null;
    }

    @Override
    public Object visitMinIndexPath(SqmMinIndexPath path) {
        return null;
    }

    @Override
    public Object visitLiteral(SqmLiteral literal) {
        return null;
    }

    @Override
    public Object visitTuple(SqmTuple sqmTuple) {
        return null;
    }

    @Override
    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
        return null;
    }

    @Override
    public Object visitSubQueryExpression(SqmSubQuery expression) {
        return null;
    }

    @Override
    public Object visitSimpleCaseExpression(SqmCaseSimple expression) {
        return null;
    }

    @Override
    public Object visitSearchedCaseExpression(SqmCaseSearched expression) {
        return null;
    }

    @Override
    public Object visitAny(SqmAny<?> sqmAny) {
        return null;
    }

    @Override
    public Object visitEvery(SqmEvery<?> sqmEvery) {
        return null;
    }

    @Override
    public Object visitDynamicInstantiation(SqmDynamicInstantiation sqmDynamicInstantiation) {
        this.processStanza("dynamic-instantiation (" + sqmDynamicInstantiation.getInstantiationTarget().getJavaType() + ')', () -> this.processStanza("arguments", () -> sqmDynamicInstantiation.getArguments().forEach(argument -> this.processStanza("argument (" + argument.getAlias() + ')', () -> {
            ++this.depth;
            argument.getSelectableNode().accept(this);
            --this.depth;
        }))));
        return null;
    }

    @Override
    public Object visitEnumLiteral(SqmEnumLiteral sqmEnumLiteral) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object visitFieldLiteral(SqmFieldLiteral sqmFieldLiteral) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object visitSqmPathEntityTypeExpression(SqmPathEntityType<?> expression) {
        return null;
    }

    @Override
    public Object visitFullyQualifiedClass(Class namedClass) {
        return null;
    }

    @Override
    public Object visitRestrictedSubQueryExpression(SqmRestrictedSubQueryExpression sqmRestrictedSubQueryExpression) {
        return null;
    }
}

