/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmUtil {
    private SqmUtil() {
    }

    public static void verifyIsSelectStatement(SqmStatement sqm) {
        if (!(sqm instanceof SqmSelectStatement)) {
            throw new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a SELECT Query [%s], but found %s", SqmSelectStatement.class.getName(), sqm.getClass().getName()));
        }
    }

    public static void verifyIsNonSelectStatement(SqmStatement sqm) {
        if (!(sqm instanceof SqmDmlStatement)) {
            throw new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a non-SELECT Query [%s], but found %s", SqmDmlStatement.class.getName(), sqm.getClass().getName()));
        }
    }

    public static Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> generateJdbcParamsXref(DomainParameterXref domainParameterXref, JdbcParameterBySqmParameterAccess jdbcParameterBySqmParameterAccess) {
        if (domainParameterXref == null || !domainParameterXref.hasParameters()) {
            return Collections.emptyMap();
        }
        int queryParameterCount = domainParameterXref.getQueryParameterCount();
        IdentityHashMap result = new IdentityHashMap(queryParameterCount);
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter> sqmParams = entry.getValue();
            Map sqmParamMap = result.computeIfAbsent(queryParam, qp -> new IdentityHashMap(sqmParams.size()));
            for (SqmParameter sqmParam : sqmParams) {
                sqmParamMap.put(sqmParam, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(sqmParam));
                List<SqmParameter> expansions = domainParameterXref.getExpansions(sqmParam);
                if (expansions.isEmpty()) continue;
                for (SqmParameter expansion : expansions) {
                    sqmParamMap.put(expansion, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(expansion));
                    result.put(queryParam, sqmParamMap);
                }
            }
        }
        return result;
    }

    public static JdbcParameterBindings createJdbcParameterBindings(QueryParameterBindings domainParamBindings, DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamXref, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator, SharedSessionContractImplementor session) {
        final JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(domainParameterXref.getSqmParameterCount());
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter> sqmParameters = entry.getValue();
            QueryParameterBinding<?> domainParamBinding = domainParamBindings.getBinding(queryParam);
            AllowableParameterType parameterType = SqmUtil.determineParameterType(domainParamBinding, queryParam, session.getFactory());
            Map<SqmParameter, List<JdbcParameter>> jdbcParamMap = jdbcParamXref.get(queryParam);
            for (SqmParameter sqmParameter : sqmParameters) {
                final List<JdbcParameter> jdbcParams = jdbcParamMap.get(sqmParameter);
                if (!domainParamBinding.isBound()) {
                    MappingModelExpressable mappingExpressable = SqmMappingModelHelper.resolveMappingModelExpressable(sqmParameter, domainModel, tableGroupLocator);
                    mappingExpressable.visitJdbcTypes(new Consumer<JdbcMapping>(){
                        int position = 0;

                        @Override
                        public void accept(final JdbcMapping jdbcType) {
                            JdbcParameter jdbcParameter = (JdbcParameter)jdbcParams.get(this.position++);
                            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBinding(){

                                @Override
                                public JdbcMapping getBindType() {
                                    return jdbcType;
                                }

                                @Override
                                public Object getBindValue() {
                                    return null;
                                }
                            });
                        }
                    }, Clause.IRRELEVANT, session.getFactory().getTypeConfiguration());
                    continue;
                }
                if (domainParamBinding.isMultiValued()) {
                    Collection<?> bindValues = domainParamBinding.getBindValues();
                    Iterator<?> valueItr = bindValues.iterator();
                    SqmUtil.createValueBindings(jdbcParameterBindings, parameterType, jdbcParams, valueItr.next(), session);
                    List<SqmParameter> expansions = domainParameterXref.getExpansions(sqmParameter);
                    assert (expansions.size() == bindValues.size() - 1);
                    int expansionPosition = 0;
                    while (valueItr.hasNext()) {
                        SqmParameter expansionSqmParam = expansions.get(expansionPosition++);
                        List<JdbcParameter> expansionJdbcParams = jdbcParamMap.get(expansionSqmParam);
                        SqmUtil.createValueBindings(jdbcParameterBindings, parameterType, expansionJdbcParams, valueItr.next(), session);
                    }
                    continue;
                }
                if (domainParamBinding.getBindValue() == null) {
                    assert (jdbcParams != null);
                    for (int i = 0; i < jdbcParams.size(); ++i) {
                        JdbcParameter jdbcParameter = jdbcParams.get(i);
                        jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBinding(){

                            @Override
                            public JdbcMapping getBindType() {
                                return StandardBasicTypes.SERIALIZABLE;
                            }

                            @Override
                            public Object getBindValue() {
                                return null;
                            }
                        });
                    }
                    continue;
                }
                Object bindValue = domainParamBinding.getBindValue();
                SqmUtil.createValueBindings(jdbcParameterBindings, parameterType, jdbcParams, bindValue, session);
            }
        }
        return jdbcParameterBindings;
    }

    private static void createValueBindings(final JdbcParameterBindings jdbcParameterBindings, AllowableParameterType<?> parameterType, final List<JdbcParameter> jdbcParams, Object bindValue, SharedSessionContractImplementor session) {
        MappingModelExpressable mappingExpressable = session.getFactory().getDomainModel().resolveMappingExpressable(parameterType);
        mappingExpressable.visitJdbcValues(bindValue, Clause.IRRELEVANT, new Bindable.JdbcValuesConsumer(){
            private int position = 0;

            @Override
            public void consume(final Object jdbcValue, final JdbcMapping jdbcMapping) {
                JdbcParameter jdbcParameter = (JdbcParameter)jdbcParams.get(this.position);
                jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBinding(){

                    @Override
                    public JdbcMapping getBindType() {
                        return jdbcMapping;
                    }

                    @Override
                    public Object getBindValue() {
                        return jdbcValue;
                    }
                });
                ++this.position;
            }
        }, session);
    }

    public static AllowableParameterType determineParameterType(QueryParameterBinding<?> binding, QueryParameterImplementor<?> parameter, SessionFactoryImplementor sessionFactory) {
        if (binding.getBindType() != null) {
            return binding.getBindType();
        }
        if (parameter.getHibernateType() != null) {
            return parameter.getHibernateType();
        }
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        BasicType basicType = typeConfiguration.standardBasicTypeForJavaType(parameter.getParameterType());
        return basicType;
    }
}

