/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.function.Function;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractWork;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;

public class IdTableHelper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(IdTableHelper.class);
    public static final String SESSION_ID_COLUMN_NAME = "hib_sess_id";
    private static SqlExceptionHelper.WarningHandler WARNING_HANDLER = new SqlExceptionHelper.WarningHandlerLoggingSupport(){

        @Override
        public boolean doProcess() {
            return log.isDebugEnabled();
        }

        @Override
        public void prepare(SQLWarning warning) {
            log.warningsCreatingTempTable(warning);
        }

        @Override
        protected void logWarning(String description, String message) {
            log.debug(description);
            log.debug(message);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cleanIdTableRows(IdTable idTable, IdTableExporter exporter, Function<SharedSessionContractImplementor, String> sessionUidAccess, SharedSessionContractImplementor session) {
        PreparedStatement ps = null;
        String sql23333332 = exporter.getSqlTruncateCommand(idTable, sessionUidAccess, session);
        ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql23333332, false);
        if (idTable.getSessionUidColumn() != null) {
            String sessionUid = sessionUidAccess.apply(session);
            ps.setString(1, sessionUid);
        }
        session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
        if (ps == null) return;
        try {
            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
            return;
        }
        catch (Throwable sql23333332) {}
        return;
        catch (Throwable t) {
            try {
                log.unableToCleanupTemporaryIdTable(t);
                if (ps == null) return;
            }
            catch (Throwable throwable) {
                if (ps == null) throw throwable;
                try {
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
                return;
            }
            catch (Throwable throwable) {}
            return;
        }
    }

    private static void logStatement(String sql, JdbcServices jdbcServices) {
        SqlStatementLogger statementLogger = jdbcServices.getSqlStatementLogger();
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
    }

    public static class IdTableDropWork
    extends AbstractWork {
        private final IdTable idTable;
        private final IdTableExporter exporter;
        private final SessionFactoryImplementor sessionFactory;

        IdTableDropWork(IdTable idTable, IdTableExporter exporter, SessionFactoryImplementor sessionFactory) {
            this.idTable = idTable;
            this.exporter = exporter;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public void execute(Connection connection) {
            JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
            try {
                String dropCommand = this.exporter.getSqlCreateCommand(this.idTable);
                IdTableHelper.logStatement(dropCommand, jdbcServices);
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(dropCommand);
                    jdbcServices.getSqlExceptionHelper().handleAndClearWarnings(statement, WARNING_HANDLER);
                }
                catch (SQLException e) {
                    log.debugf("unable to drop id table [%s]; `%s` failed : %s", this.idTable.getQualifiedTableName(), dropCommand, e.getMessage());
                }
            }
            catch (Exception e) {
                log.debugf("Error dropping id table(s) : %s", e.getMessage());
            }
        }
    }

    public static class IdTableCreationWork
    extends AbstractWork {
        private final IdTable idTable;
        private final IdTableExporter exporter;
        private final SessionFactoryImplementor sessionFactory;

        public IdTableCreationWork(IdTable idTable, IdTableExporter exporter, SessionFactoryImplementor sessionFactory) {
            this.idTable = idTable;
            this.exporter = exporter;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public void execute(Connection connection) {
            JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
            try {
                String creationCommand = this.exporter.getSqlCreateCommand(this.idTable);
                IdTableHelper.logStatement(creationCommand, jdbcServices);
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(creationCommand);
                    jdbcServices.getSqlExceptionHelper().handleAndClearWarnings(statement, WARNING_HANDLER);
                }
                catch (SQLException e) {
                    log.debugf("unable to create id table [%s]; `%s` failed : %s", this.idTable.getQualifiedTableName(), creationCommand, e.getMessage());
                }
            }
            catch (Exception e) {
                log.debugf("Error creating id table(s) : %s", e.getMessage());
            }
        }
    }
}

