/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.UpdateHandler;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;
import org.hibernate.query.sqm.mutation.internal.idtable.UpdateExecutionDelegate;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.jboss.logging.Logger;

public class TableBasedUpdateHandler
extends AbstractMutationHandler
implements UpdateHandler {
    private static final Logger log = Logger.getLogger(TableBasedUpdateHandler.class);
    private final IdTable idTable;
    private final TempTableDdlTransactionHandling ddlTransactionHandling;
    private final BeforeUseAction beforeUseAction;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final Supplier<IdTableExporter> exporterSupplier;
    private final DomainParameterXref domainParameterXref;
    private final EntityPersister entityDescriptor;

    TableBasedUpdateHandler(SqmUpdateStatement sqmUpdate, DomainParameterXref domainParameterXref, IdTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, Supplier<IdTableExporter> exporterSupplier, BeforeUseAction beforeUseAction, AfterUseAction afterUseAction, TempTableDdlTransactionHandling ddlTransactionHandling, SessionFactoryImplementor sessionFactory) {
        super(sqmUpdate, sessionFactory);
        this.idTable = idTable;
        this.exporterSupplier = exporterSupplier;
        this.beforeUseAction = beforeUseAction;
        this.afterUseAction = afterUseAction;
        this.ddlTransactionHandling = ddlTransactionHandling;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
        String targetEntityName = ((SqmRoot)sqmUpdate.getTarget()).getEntityName();
        this.entityDescriptor = sessionFactory.getDomainModel().getEntityDescriptor(targetEntityName);
    }

    protected SqmUpdateStatement getSqmUpdate() {
        return this.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public SqmUpdateStatement getSqmDeleteOrUpdateStatement() {
        return (SqmUpdateStatement)super.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        log.tracef("Starting multi-table update execution - %s", (Object)this.getSqmDeleteOrUpdateStatement().getRoot().getModel().getName());
        return this.resolveDelegate(executionContext).execute(executionContext);
    }

    private ExecutionDelegate resolveDelegate(ExecutionContext executionContext) {
        Predicate predicate;
        SessionFactoryImplementor sessionFactory = this.getSessionFactory();
        MappingMetamodel domainModel = sessionFactory.getDomainModel();
        EntityPersister entityDescriptor = domainModel.getEntityDescriptor(((SqmRoot)this.getSqmDeleteOrUpdateStatement().getTarget()).getEntityName());
        String rootEntityName = entityDescriptor.getRootEntityName();
        EntityPersister rootEntityDescriptor = domainModel.getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = ((Joinable)((Object)rootEntityDescriptor)).getTableName();
        MultiTableSqmMutationConverter converterDelegate = new MultiTableSqmMutationConverter(entityDescriptor, this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getQueryParameterBindings(), sessionFactory);
        Stack<SqlAstProcessingState> converterProcessingStateStack = converterDelegate.getProcessingStateStack();
        SqlAstProcessingStateImpl rootProcessingState = new SqlAstProcessingStateImpl(null, converterDelegate, converterDelegate.getCurrentClauseStack()::getCurrent);
        converterProcessingStateStack.push(rootProcessingState);
        TableGroup updatingTableGroup = converterDelegate.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < updatingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        Map<SqmParameter, List<JdbcParameter>> parameterResolutions = this.domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        converterDelegate.visitSetClause(this.getSqmDeleteOrUpdateStatement().getSetClause(), assignments::add, parameterResolutions::put);
        SqmWhereClause whereClause = this.getSqmUpdate().getWhereClause();
        if (whereClause == null || whereClause.getPredicate() == null) {
            predicate = null;
        } else {
            predicate = converterDelegate.visitWhereClause(whereClause, columnReference -> {}, parameterResolutions::put);
            assert (predicate != null);
        }
        return new UpdateExecutionDelegate(this.getSqmUpdate(), converterDelegate, this.idTable, this.ddlTransactionHandling, this.beforeUseAction, this.afterUseAction, this.sessionUidAccess, this.exporterSupplier, this.domainParameterXref, updatingTableGroup, hierarchyRootTableReference, tableReferenceByAlias, assignments, predicate, parameterResolutions, executionContext);
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    public static interface ExecutionDelegate {
        public int execute(ExecutionContext var1);
    }
}

