/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.function.Function;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;

public class TempIdTableExporter
implements IdTableExporter {
    private final boolean isLocal;
    private final Function<Integer, String> databaseTypeNameResolver;

    public TempIdTableExporter(boolean isLocal, Function<Integer, String> databaseTypeNameResolver) {
        this.isLocal = isLocal;
        this.databaseTypeNameResolver = databaseTypeNameResolver;
    }

    protected String getCreateCommand() {
        return "create " + (this.isLocal ? "local" : "global") + " temporary table";
    }

    protected String getCreateOptions() {
        return null;
    }

    protected String getDropCommand() {
        return "drop table";
    }

    protected String getTruncateIdTableCommand() {
        return "delete from";
    }

    @Override
    public String getSqlCreateCommand(IdTable idTable) {
        StringBuilder buffer = new StringBuilder(this.getCreateCommand()).append(' ');
        buffer.append(idTable.getQualifiedTableName());
        buffer.append('(');
        boolean firstPass = true;
        for (IdTableColumn column : idTable.getIdTableColumns()) {
            if (firstPass) {
                firstPass = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(column.getColumnName()).append(' ');
            String databaseTypeName = this.databaseTypeNameResolver.apply(column.getJdbcMapping().getSqlTypeDescriptor().getSqlType());
            buffer.append(" ").append(databaseTypeName).append(" ");
            buffer.append(" not null");
        }
        buffer.append(") ");
        String createOptions = this.getCreateOptions();
        if (createOptions != null) {
            buffer.append(createOptions);
        }
        return buffer.toString();
    }

    @Override
    public String getSqlDropCommand(IdTable idTable) {
        return this.getDropCommand() + " " + idTable.getQualifiedTableName();
    }

    @Override
    public String getSqlTruncateCommand(IdTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, SharedSessionContractImplementor session) {
        if (idTable.getSessionUidColumn() != null) {
            assert (sessionUidAccess != null);
            String uid = sessionUidAccess.apply(session);
            return this.getTruncateIdTableCommand() + " " + idTable.getQualifiedTableName() + " where " + idTable.getSessionUidColumn().getColumnName() + " = " + uid;
        }
        return this.getTruncateIdTableCommand() + " " + idTable.getQualifiedTableName();
    }
}

