/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;

public class PatternRenderer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PatternRenderer.class);
    private final String[] chunks;
    private final int[] paramIndexes;
    private final int varargParam;
    private final int maxParamIndex;

    public PatternRenderer(String pattern) {
        int i;
        HashSet<Integer> paramNumbers = new HashSet<Integer>();
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        StringBuilder chunk = new StringBuilder(10);
        StringBuilder index = new StringBuilder(2);
        int vararg = -1;
        int max = 0;
        int len = pattern.length();
        for (i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c == '?') {
                chunkList.add(chunk.toString());
                chunk.setLength(0);
                while (++i < pattern.length()) {
                    c = pattern.charAt(i);
                    if (Character.isDigit(c)) {
                        index.append(c);
                        continue;
                    }
                    if (c == '.') {
                        index.append(c);
                        continue;
                    }
                    if (c == '?') {
                        --i;
                        break;
                    }
                    chunk.append(c);
                    break;
                }
                if (index.toString().endsWith("...")) {
                    vararg = paramList.size();
                    continue;
                }
                int paramNumber = Integer.valueOf(index.toString());
                paramNumbers.add(paramNumber);
                paramList.add(paramNumber);
                index.setLength(0);
                if (paramNumber <= max) continue;
                max = paramNumber;
                continue;
            }
            chunk.append(c);
        }
        if (chunk.length() > 0) {
            chunkList.add(chunk.toString());
        }
        this.varargParam = vararg;
        this.maxParamIndex = max;
        this.chunks = chunkList.toArray(new String[chunkList.size()]);
        this.paramIndexes = new int[paramList.size()];
        for (i = 0; i < this.paramIndexes.length; ++i) {
            this.paramIndexes[i] = (Integer)paramList.get(i);
        }
    }

    public boolean hasVarargs() {
        return this.varargParam >= 0;
    }

    public int getParamCount() {
        return this.maxParamIndex;
    }

    public void render(SqlAppender sqlAppender, List<SqlAstNode> args, SqlAstWalker walker) {
        int numberOfArguments = args.size();
        if (numberOfArguments < this.maxParamIndex) {
            LOG.missingArguments(this.maxParamIndex, numberOfArguments);
        }
        for (int i = 0; i < this.chunks.length; ++i) {
            SqlAstNode arg;
            if (i == this.varargParam) {
                for (int j = i; j < numberOfArguments; ++j) {
                    arg = args.get(j);
                    if (arg == null) continue;
                    sqlAppender.appendSql(this.chunks[i]);
                    arg.accept(walker);
                }
                continue;
            }
            if (i < this.paramIndexes.length) {
                int index = this.paramIndexes[i] - 1;
                SqlAstNode sqlAstNode = arg = index < numberOfArguments ? args.get(index) : null;
                if (arg != null || i == 0) {
                    sqlAppender.appendSql(this.chunks[i]);
                }
                if (arg == null) continue;
                arg.accept(walker);
                continue;
            }
            sqlAppender.appendSql(this.chunks[i]);
        }
    }
}

