/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.EmbeddableValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.EntityValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqlAstQuerySpecProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.cte.SqmCteConsumer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQuerySpecProcessingState;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteConsumer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.spi.JdbcParameters;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public abstract class BaseSqmToSqlAstConverter
extends BaseSemanticQueryWalker
implements SqmToSqlAstConverter,
JdbcParameterBySqmParameterAccess,
FromClauseAccess {
    private static final Logger log = Logger.getLogger(BaseSqmToSqlAstConverter.class);
    private final SqlAstCreationContext creationContext;
    private final QueryOptions queryOptions;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindings domainParameterBindings;
    private final Map<JpaCriteriaParameter<?>, Supplier<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;
    private final SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
    private final FromClauseIndex fromClauseIndex = new FromClauseIndex();
    private final Stack<SqlAstProcessingState> processingStateStack = new StandardStack<SqlAstProcessingState>();
    private final Stack<Clause> currentClauseStack = new StandardStack<Clause>();
    private final Stack<Shallowness> shallownessStack = new StandardStack<Shallowness>(Shallowness.NONE);
    private SqmByUnit appliedByUnit;
    private Expression adjustedTimestamp;
    private SqmExpressable<?> adjustedTimestampType;
    private Expression adjustmentScale;
    private boolean negativeAdjustment;
    protected Predicate additionalRestrictions;
    private final Map<SqmParameter, List<JdbcParameter>> jdbcParamsBySqmParam = new IdentityHashMap<SqmParameter, List<JdbcParameter>>();
    private final JdbcParameters jdbcParameters = new JdbcParametersImpl();
    protected final Stack<Supplier<MappingModelExpressable>> inferableTypeAccessStack = new StandardStack<Supplier<MappingModelExpressable>>(() -> null);

    public BaseSqmToSqlAstConverter(SqlAstCreationContext creationContext, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext.getServiceRegistry());
        this.creationContext = creationContext;
        this.queryOptions = queryOptions;
        this.domainParameterXref = domainParameterXref;
        this.domainParameterBindings = domainParameterBindings;
        this.jpaCriteriaParamResolutions = domainParameterXref.getParameterResolutions().getJpaCriteriaParamResolutions();
    }

    protected Stack<SqlAstProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.fromClauseIndex.findTableGroup(navigablePath);
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this.processingStateStack.getCurrent();
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.getCurrentProcessingState().getSqlExpressionResolver();
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseIndex;
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        return this.queryOptions.getLockOptions().getEffectiveLockMode(identificationVariable);
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public FromClauseIndex getFromClauseIndex() {
        return this.fromClauseIndex;
    }

    @Override
    public Stack<Clause> getCurrentClauseStack() {
        return this.currentClauseStack;
    }

    @Override
    public Object visitUpdateStatement(SqmUpdateStatement statement) {
        throw new AssertionFailure("UpdateStatement not supported");
    }

    @Override
    public Object visitDeleteStatement(SqmDeleteStatement statement) {
        throw new AssertionFailure("DeleteStatement not supported");
    }

    @Override
    public Object visitInsertSelectStatement(SqmInsertSelectStatement statement) {
        throw new AssertionFailure("InsertStatement not supported");
    }

    @Override
    public Object visitInsertValuesStatement(SqmInsertValuesStatement statement) {
        throw new AssertionFailure("InsertStatement not supported");
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement statement) {
        throw new AssertionFailure("SelectStatement not supported");
    }

    @Override
    public CteStatement visitCteStatement(SqmCteStatement sqmCteStatement) {
        CteTable cteTable = this.createCteTable(sqmCteStatement);
        return new CteStatement(this.visitQuerySpec(sqmCteStatement.getCteDefinition()), sqmCteStatement.getCteLabel(), cteTable, this.visitCteConsumer(sqmCteStatement.getCteConsumer()));
    }

    protected CteTable createCteTable(SqmCteStatement sqmCteStatement) {
        SqmCteTable sqmCteTable = sqmCteStatement.getCteTable();
        List<SqmCteTableColumn> sqmCteColumns = sqmCteTable.getColumns();
        ArrayList<CteColumn> sqlCteColumns = new ArrayList<CteColumn>(sqmCteColumns.size());
        for (int i = 0; i < sqmCteColumns.size(); ++i) {
            SqmCteTableColumn sqmCteTableColumn = sqmCteColumns.get(i);
            sqlCteColumns.add(new CteColumn(sqmCteTableColumn.getColumnName(), sqmCteTableColumn.getType()));
        }
        return new CteTable(sqlCteColumns, this.getCreationContext().getSessionFactory());
    }

    @Override
    public CteConsumer visitCteConsumer(SqmCteConsumer consumer) {
        return (CteConsumer)super.visitCteConsumer(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuerySpec visitQuerySpec(SqmQuerySpec sqmQuerySpec) {
        QuerySpec sqlQuerySpec = new QuerySpec(this.processingStateStack.isEmpty(), sqmQuerySpec.getFromClause().getNumberOfRoots());
        this.additionalRestrictions = null;
        this.processingStateStack.push(new SqlAstQuerySpecProcessingStateImpl(sqlQuerySpec, this.processingStateStack.getCurrent(), this, this.currentClauseStack::getCurrent));
        try {
            SqmWhereClause whereClause;
            this.prepareQuerySpec(sqlQuerySpec);
            this.visitFromClause(sqmQuerySpec.getFromClause());
            SqmSelectClause selectClause = sqmQuerySpec.getSelectClause();
            if (selectClause != null) {
                this.visitSelectClause(selectClause);
            }
            if ((whereClause = sqmQuerySpec.getWhereClause()) != null && whereClause.getPredicate() != null) {
                this.currentClauseStack.push(Clause.WHERE);
                try {
                    sqlQuerySpec.applyPredicate((Predicate)whereClause.getPredicate().accept(this));
                }
                finally {
                    this.currentClauseStack.pop();
                }
            }
            if (this.additionalRestrictions != null) {
                sqlQuerySpec.applyPredicate(this.additionalRestrictions);
            }
            if (sqmQuerySpec.getOrderByClause() != null) {
                this.currentClauseStack.push(Clause.ORDER);
                try {
                    for (SqmSortSpecification sortSpecification : sqmQuerySpec.getOrderByClause().getSortSpecifications()) {
                        sqlQuerySpec.addSortSpecification(this.visitSortSpecification(sortSpecification));
                    }
                }
                finally {
                    this.currentClauseStack.pop();
                }
            }
            sqlQuerySpec.setLimitClauseExpression(this.visitLimitExpression(sqmQuerySpec.getLimitExpression()));
            sqlQuerySpec.setOffsetClauseExpression(this.visitOffsetExpression(sqmQuerySpec.getOffsetExpression()));
            this.postProcessQuerySpec(sqlQuerySpec);
            QuerySpec querySpec = sqlQuerySpec;
            return querySpec;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    protected void prepareQuerySpec(QuerySpec sqlQuerySpec) {
    }

    protected void postProcessQuerySpec(QuerySpec sqlQuerySpec) {
    }

    @Override
    public SelectClause visitSelectClause(SqmSelectClause selectClause) {
        this.currentClauseStack.push(Clause.SELECT);
        this.shallownessStack.push(Shallowness.SUBQUERY);
        try {
            super.visitSelectClause(selectClause);
            this.currentQuerySpec().getSelectClause().makeDistinct(selectClause.isDistinct());
            SelectClause selectClause2 = this.currentQuerySpec().getSelectClause();
            return selectClause2;
        }
        finally {
            this.shallownessStack.pop();
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitOrderByClause(SqmOrderByClause orderByClause) {
        super.visitOrderByClause(orderByClause);
        return null;
    }

    @Override
    public SortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
        return new SortSpecification((Expression)sortSpecification.getSortExpression().accept(this), sortSpecification.getCollation(), sortSpecification.getSortOrder());
    }

    @Override
    public Expression visitOffsetExpression(SqmExpression expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.OFFSET);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Expression visitLimitExpression(SqmExpression expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.LIMIT);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitFromClause(SqmFromClause sqmFromClause) {
        this.currentClauseStack.push(Clause.FROM);
        try {
            sqmFromClause.visitRoots(this::consumeFromClauseRoot);
        }
        finally {
            this.currentClauseStack.pop();
        }
        return null;
    }

    protected void consumeFromClauseRoot(SqmRoot<?> sqmRoot) {
        log.tracef("Resolving SqmRoot [%s] to TableGroup", sqmRoot);
        if (this.fromClauseIndex.isResolved(sqmRoot)) {
            log.tracef("Already resolved SqmRoot [%s] to TableGroup", sqmRoot);
        }
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), true, LockMode.NONE, this.sqlAliasBaseManager, this.getSqlExpressionResolver(), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this.creationContext);
        log.tracef("Resolved SqmRoot [%s] to new TableGroup [%s]", sqmRoot, (Object)tableGroup);
        this.fromClauseIndex.register(sqmRoot, tableGroup);
        this.currentQuerySpec().getFromClause().addRoot(tableGroup);
        this.consumeExplicitJoins(sqmRoot, tableGroup);
        this.consumeImplicitJoins(sqmRoot, tableGroup);
    }

    private EntityPersister resolveEntityPersister(EntityDomainType<?> entityDomainType) {
        return this.creationContext.getDomainModel().getEntityDescriptor(entityDomainType.getHibernateEntityName());
    }

    protected void consumeExplicitJoins(SqmFrom<?, ?> sqmFrom, TableGroup lhsTableGroup) {
        log.tracef("Visiting explicit joins for `%s`", (Object)sqmFrom.getNavigablePath());
        sqmFrom.visitSqmJoins(sqmJoin -> this.consumeExplicitJoin((SqmJoin<?, ?>)sqmJoin, lhsTableGroup));
    }

    protected void consumeExplicitJoin(SqmJoin<?, ?> sqmJoin, TableGroup lhsTableGroup) {
        if (sqmJoin instanceof SqmAttributeJoin) {
            this.consumeAttributeJoin((SqmAttributeJoin)sqmJoin, lhsTableGroup);
        } else if (sqmJoin instanceof SqmCrossJoin) {
            this.consumeCrossJoin((SqmCrossJoin)sqmJoin, lhsTableGroup);
        } else if (sqmJoin instanceof SqmEntityJoin) {
            this.consumeEntityJoin((SqmEntityJoin)sqmJoin, lhsTableGroup);
        } else {
            throw new InterpretationException("Could not resolve SqmJoin [" + sqmJoin.getNavigablePath() + "] to TableGroupJoin");
        }
    }

    private void consumeAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin, TableGroup lhsTableGroup) {
        TableGroup joinedTableGroup;
        TableGroupJoin joinedTableGroupJoin;
        SqmPathSource<?> pathSource = sqmJoin.getReferencedPathSource();
        if (pathSource instanceof PluralPersistentAttribute) {
            ModelPart pluralPart = lhsTableGroup.getModelPart().findSubPart(sqmJoin.getReferencedPathSource().getPathName(), SqmMappingModelHelper.resolveExplicitTreatTarget(sqmJoin, this));
            assert (pluralPart instanceof PluralAttributeMapping);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)pluralPart;
            NavigablePath elementPath = sqmJoin.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName());
            joinedTableGroupJoin = pluralAttributeMapping.createTableGroupJoin(elementPath, lhsTableGroup, sqmJoin.getExplicitAlias(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), this.determineLockMode(sqmJoin.getExplicitAlias()), this.sqlAliasBaseManager, this.getSqlExpressionResolver(), this.creationContext);
            joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
            lhsTableGroup.addTableGroupJoin(joinedTableGroupJoin);
            this.fromClauseIndex.register(sqmJoin, joinedTableGroup);
            this.fromClauseIndex.registerTableGroup(elementPath, joinedTableGroup);
        } else if (pathSource instanceof EmbeddedSqmPathSource) {
            ModelPart joinedPart = lhsTableGroup.getModelPart().findSubPart(pathSource.getPathName(), SqmMappingModelHelper.resolveExplicitTreatTarget(sqmJoin, this));
            assert (joinedPart instanceof TableGroupJoinProducer);
            String explicitAlias = sqmJoin.getExplicitAlias();
            NavigablePath joinedPath = explicitAlias == null ? sqmJoin.getNavigablePath() : sqmJoin.getNavigablePath().getParent().append(sqmJoin.getAttribute().getName());
            joinedTableGroupJoin = ((TableGroupJoinProducer)joinedPart).createTableGroupJoin(joinedPath, lhsTableGroup, sqmJoin.getExplicitAlias(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), this.determineLockMode(sqmJoin.getExplicitAlias()), this.sqlAliasBaseManager, this.getSqlExpressionResolver(), this.creationContext);
            joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
            lhsTableGroup.addTableGroupJoin(joinedTableGroupJoin);
            this.fromClauseIndex.register(sqmJoin, joinedTableGroup);
        } else if (lhsTableGroup.getModelPart() instanceof PluralAttributeMapping) {
            this.fromClauseIndex.register(sqmJoin, lhsTableGroup);
            joinedTableGroupJoin = null;
            joinedTableGroup = lhsTableGroup;
        } else {
            ModelPart joinedPart = lhsTableGroup.getModelPart().findSubPart(pathSource.getPathName(), SqmMappingModelHelper.resolveExplicitTreatTarget(sqmJoin, this));
            if (!TableGroupJoinProducer.class.isInstance(joinedPart)) {
                throw new HibernateException("Expecting joined model part to implement TableGroupJoinProducer - " + joinedPart);
            }
            String explicitAlias = sqmJoin.getExplicitAlias();
            NavigablePath joinedPath = explicitAlias == null ? sqmJoin.getNavigablePath() : sqmJoin.getNavigablePath().getParent().append(sqmJoin.getAttribute().getName());
            joinedTableGroupJoin = ((TableGroupJoinProducer)joinedPart).createTableGroupJoin(joinedPath, lhsTableGroup, sqmJoin.getExplicitAlias(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), this.determineLockMode(sqmJoin.getExplicitAlias()), this.sqlAliasBaseManager, this.getSqlExpressionResolver(), this.creationContext);
            joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
            lhsTableGroup.addTableGroupJoin(joinedTableGroupJoin);
            this.fromClauseIndex.register(sqmJoin, joinedTableGroup);
        }
        if (sqmJoin.getJoinPredicate() != null) {
            if (sqmJoin.isFetched()) {
                QueryLogger.QUERY_LOGGER.debugf("Join fetch [" + sqmJoin.getNavigablePath() + "] is restricted", new Object[0]);
            }
            if (joinedTableGroupJoin == null) {
                throw new IllegalStateException();
            }
            joinedTableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
        }
        this.consumeExplicitJoins(sqmJoin, joinedTableGroup);
        this.consumeImplicitJoins(sqmJoin, joinedTableGroup);
    }

    private void consumeCrossJoin(SqmCrossJoin sqmJoin, TableGroup lhsTableGroup) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), true, this.determineLockMode(sqmJoin.getExplicitAlias()), this.sqlAliasBaseManager, this.getSqlExpressionResolver(), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this.getCreationContext());
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), SqlAstJoinType.CROSS, tableGroup);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        this.fromClauseIndex.register(sqmJoin, tableGroup);
        this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        this.consumeImplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
    }

    private void consumeEntityJoin(SqmEntityJoin sqmJoin, TableGroup lhsTableGroup) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), true, this.determineLockMode(sqmJoin.getExplicitAlias()), this.sqlAliasBaseManager, this.getSqlExpressionResolver(), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this.getCreationContext());
        this.fromClauseIndex.register(sqmJoin, tableGroup);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), tableGroup, null);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        if (sqmJoin.getJoinPredicate() != null) {
            tableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
        }
        this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        this.consumeImplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
    }

    private void consumeImplicitJoins(SqmPath<?> sqmPath, TableGroup tableGroup) {
        log.tracef("Visiting implicit joins for `%s`", (Object)sqmPath.getNavigablePath());
        sqmPath.visitImplicitJoinPaths(joinedPath -> {
            log.tracef("Starting implicit join handling for `%s`", (Object)joinedPath.getNavigablePath());
            assert (this.getFromClauseAccess().findTableGroup(joinedPath.getLhs().getNavigablePath()) == tableGroup);
            ModelPart subPart = tableGroup.getModelPart().findSubPart(joinedPath.getReferencedPathSource().getPathName(), sqmPath instanceof SqmTreatedPath ? this.resolveEntityPersister(((SqmTreatedPath)sqmPath).getTreatTarget()) : null);
            assert (subPart instanceof TableGroupJoinProducer);
            TableGroupJoinProducer joinProducer = (TableGroupJoinProducer)subPart;
            TableGroupJoin tableGroupJoin = joinProducer.createTableGroupJoin(joinedPath.getNavigablePath(), tableGroup, null, tableGroup.isInnerJoinPossible() ? SqlAstJoinType.INNER : SqlAstJoinType.LEFT, null, this.sqlAliasBaseManager, this.getSqlExpressionResolver(), this.creationContext);
            this.fromClauseIndex.register((SqmPath<?>)joinedPath, tableGroupJoin.getJoinedGroup());
            this.consumeImplicitJoins((SqmPath<?>)joinedPath, tableGroupJoin.getJoinedGroup());
        });
    }

    @Override
    public TableGroup visitRootPath(SqmRoot<?> sqmRoot) {
        TableGroup resolved = this.fromClauseIndex.findTableGroup(sqmRoot.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmRoot [%s] resolved to existing TableGroup [%s]", sqmRoot, (Object)resolved);
            return resolved;
        }
        throw new InterpretationException("SqmRoot not yet resolved to TableGroup");
    }

    @Override
    public TableGroup visitQualifiedAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin) {
        TableGroup existing = this.fromClauseIndex.findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmAttributeJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmAttributeJoin not yet resolved to TableGroup");
    }

    private QuerySpec currentQuerySpec() {
        SqlAstQuerySpecProcessingState processingState = (SqlAstQuerySpecProcessingState)this.getProcessingStateStack().getCurrent();
        return processingState.getInflightQuerySpec();
    }

    @Override
    public TableGroup visitCrossJoin(SqmCrossJoin<?> sqmJoin) {
        TableGroup existing = this.fromClauseIndex.findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmCrossJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmCrossJoin not yet resolved to TableGroup");
    }

    @Override
    public TableGroup visitQualifiedEntityJoin(SqmEntityJoin sqmJoin) {
        TableGroup existing = this.fromClauseIndex.findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmEntityJoin [%s] resolved to existing TableGroup [%s]", (Object)sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmEntityJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitBasicValuedPath(SqmBasicValuedSimplePath<?> sqmPath) {
        BasicValuedPathInterpretation<?> path = BasicValuedPathInterpretation.from(sqmPath, this, this);
        if (TypeConfiguration.isDuration(sqmPath.getNodeType())) {
            Expression scaledExpression = this.applyScale(this.toSqlExpression(path));
            if (this.adjustedTimestamp != null) {
                if (this.appliedByUnit != null) {
                    throw new IllegalStateException();
                }
                return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, new DurationUnit(TemporalUnit.NANOSECOND, this.basicType(Long.class)), scaledExpression, this.adjustedTimestamp);
            }
            if (this.appliedByUnit != null) {
                MappingModelExpressable durationType = scaledExpression.getExpressionType();
                Duration duration = new Duration(scaledExpression, TemporalUnit.NANOSECOND, (BasicValuedMapping)durationType);
                TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
                BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
                return new Conversion(duration, appliedUnit, scalarType);
            }
            return scaledExpression;
        }
        return path;
    }

    @Override
    public SqmPathInterpretation<?> visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> sqmPath) {
        return EmbeddableValuedPathInterpretation.from(sqmPath, this, this);
    }

    @Override
    public SqmPathInterpretation<?> visitEntityValuedPath(SqmEntityValuedSimplePath sqmPath) {
        return EntityValuedPathInterpretation.from(sqmPath, this);
    }

    @Override
    public SqmPathInterpretation<?> visitPluralValuedPath(SqmPluralValuedSimplePath sqmPath) {
        return (SqmPathInterpretation)((Object)sqmPath);
    }

    @Override
    public Expression visitLiteral(SqmLiteral literal) {
        if (literal instanceof SqmLiteralNull) {
            return new QueryLiteral<Object>(null, (BasicValuedMapping)this.inferableTypeAccessStack.getCurrent().get());
        }
        return new QueryLiteral(literal.getLiteralValue(), (BasicValuedMapping)SqmMappingModelHelper.resolveMappingModelExpressable(literal, this.getCreationContext().getDomainModel(), this.getFromClauseAccess()::findTableGroup));
    }

    @Override
    public Map<SqmParameter, List<JdbcParameter>> getJdbcParamsBySqmParam() {
        return this.jdbcParamsBySqmParam;
    }

    @Override
    public Expression visitNamedParameterExpression(SqmNamedParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    protected Expression consumeSqmParameter(SqmParameter sqmParameter) {
        MappingModelExpressable<?> valueMapping = this.determineValueMapping(sqmParameter);
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, valueMapping, jdbcParametersForSqm::add);
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.put(sqmParameter, jdbcParametersForSqm);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        return new SqmParameterInterpretation(sqmParameter, queryParameter, jdbcParametersForSqm, valueMapping, qp -> binding);
    }

    protected MappingModelExpressable<?> resolveMappingExpressable(SqmExpressable<?> nodeType) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        MappingModelExpressable valueMapping = this.getCreationContext().getDomainModel().resolveMappingExpressable(nodeType);
        if (valueMapping == null && (currentExpressableSupplier = this.inferableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpressable: " + nodeType);
        }
        return valueMapping;
    }

    protected MappingModelExpressable<?> determineValueMapping(SqmExpression<?> sqmExpression) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        if (sqmExpression instanceof SqmParameter) {
            return this.determineValueMapping((SqmParameter)sqmExpression);
        }
        if (sqmExpression instanceof SqmPath) {
            log.debugf("Determining mapping-model type for SqmPath : %s ", sqmExpression);
            return SqmMappingModelHelper.resolveMappingModelExpressable(sqmExpression, this.getCreationContext().getDomainModel(), this.getFromClauseAccess()::findTableGroup);
        }
        log.debugf("Determining mapping-model type for generalized SqmExpression : %s", sqmExpression);
        SqmExpressable<?> nodeType = sqmExpression.getNodeType();
        MappingModelExpressable valueMapping = this.getCreationContext().getDomainModel().resolveMappingExpressable(nodeType);
        if (valueMapping == null && (currentExpressableSupplier = this.inferableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpression: " + sqmExpression);
        }
        return valueMapping;
    }

    protected MappingModelExpressable<?> determineValueMapping(SqmParameter<?> sqmParameter) {
        MappingModelExpressable inferredMapping;
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        log.debugf("Determining mapping-model type for SqmParameter : %s", sqmParameter);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        if (sqmParameter.getAnticipatedType() == null && (currentExpressableSupplier = this.inferableTypeAccessStack.getCurrent()) != null && (inferredMapping = currentExpressableSupplier.get()) != null) {
            return inferredMapping;
        }
        AllowableParameterType<Object> parameterSqmType = binding.getBindType();
        if (parameterSqmType == null && (parameterSqmType = queryParameter.getHibernateType()) == null) {
            parameterSqmType = sqmParameter.getAnticipatedType();
        }
        assert (parameterSqmType != null);
        if (parameterSqmType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)parameterSqmType);
        }
        if (parameterSqmType instanceof CompositeSqmPathSource) {
            throw new NotYetImplementedFor6Exception("Support for embedded-valued parameters not yet implemented");
        }
        throw new ConversionException("Could not determine ValueMapping for SqmParameter: " + sqmParameter);
    }

    private void resolveSqmParameter(SqmParameter expression, MappingModelExpressable valueMapping, Consumer<JdbcParameter> jdbcParameterConsumer) {
        valueMapping.visitJdbcTypes(jdbcMapping -> jdbcParameterConsumer.accept(new JdbcParameterImpl((JdbcMapping)jdbcMapping)), this.getCurrentClauseStack().getCurrent(), this.getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    @Override
    public Object visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        if (this.jpaCriteriaParamResolutions == null) {
            throw new IllegalStateException("No JpaCriteriaParameter resolutions registered");
        }
        Supplier<SqmJpaCriteriaParameterWrapper<?>> supplier = this.jpaCriteriaParamResolutions.get(expression);
        if (supplier == null) {
            throw new IllegalStateException("Criteria parameter [" + expression + "] not known to be a parameter of the processing tree");
        }
        return this.consumeSqmParameter(supplier.get());
    }

    @Override
    public Expression visitFunction(SqmFunction sqmFunction) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            Expression expression = sqmFunction.convertToSqlAst(this);
            return expression;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Star visitStar(SqmStar sqmStar) {
        return new Star();
    }

    @Override
    public Object visitDistinct(SqmDistinct sqmDistinct) {
        return new Distinct((Expression)sqmDistinct.getExpression().accept(this));
    }

    @Override
    public Object visitTrimSpecification(SqmTrimSpecification specification) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            TrimSpecification trimSpecification = new TrimSpecification(specification.getSpecification());
            return trimSpecification;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitCastTarget(SqmCastTarget target) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            CastTarget castTarget = new CastTarget((BasicValuedMapping)((Object)target.getType()), target.getLength(), target.getPrecision(), target.getScale());
            return castTarget;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitExtractUnit(SqmExtractUnit unit) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            ExtractUnit extractUnit = new ExtractUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
            return extractUnit;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitDurationUnit(SqmDurationUnit unit) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            DurationUnit durationUnit = new DurationUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
            return durationUnit;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitFormat(SqmFormat sqmFormat) {
        return new Format((String)sqmFormat.getLiteralValue(), (BasicValuedMapping)((Object)sqmFormat.getNodeType()));
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation expression) {
        this.shallownessStack.push(Shallowness.NONE);
        try {
            UnaryOperation unaryOperation = new UnaryOperation(this.interpret(expression.getOperation()), this.toSqlExpression(expression.getOperand().accept(this)), (BasicValuedMapping)this.determineValueMapping(expression.getOperand()));
            return unaryOperation;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    private UnaryArithmeticOperator interpret(UnaryArithmeticOperator operator) {
        return operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
        this.shallownessStack.push(Shallowness.NONE);
        try {
            boolean temporalTypeSomewhereToLeft;
            SqmExpression leftOperand = expression.getLeftHandOperand();
            SqmExpression rightOperand = expression.getRightHandOperand();
            boolean durationToRight = TypeConfiguration.isDuration(rightOperand.getNodeType());
            TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
            boolean temporalTypeToLeft = typeConfiguration.isSqlTemporalType(leftOperand.getNodeType());
            boolean temporalTypeToRight = typeConfiguration.isSqlTemporalType(rightOperand.getNodeType());
            boolean bl = temporalTypeSomewhereToLeft = this.adjustedTimestamp != null || temporalTypeToLeft;
            if (temporalTypeToLeft && durationToRight && (this.adjustmentScale != null || this.negativeAdjustment)) {
                throw new SemanticException("scalar multiplication of temporal value");
            }
            if (durationToRight && temporalTypeSomewhereToLeft) {
                Object object = this.transformDurationArithmetic(expression);
                return object;
            }
            if (temporalTypeToLeft && temporalTypeToRight) {
                Object object = this.transformDatetimeArithmetic(expression);
                return object;
            }
            if (durationToRight && this.appliedByUnit != null) {
                BinaryArithmeticExpression binaryArithmeticExpression = new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType()));
                return binaryArithmeticExpression;
            }
            BinaryArithmeticExpression binaryArithmeticExpression = new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), expression.getNodeType() instanceof BasicValuedMapping ? (BasicValuedMapping)((Object)expression.getNodeType()) : (BasicValuedMapping)((Object)expression.getLeftHandOperand().getNodeType()));
            return binaryArithmeticExpression;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    private Expression toSqlExpression(Object value) {
        return (Expression)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object transformDurationArithmetic(SqmBinaryArithmetic<?> expression) {
        operator = expression.getOperator();
        switch (1.$SwitchMap$org$hibernate$query$BinaryArithmeticOperator[operator.ordinal()]) {
            case 1: 
            case 2: {
                timestamp = this.adjustedTimestamp;
                timestampType = this.adjustedTimestampType;
                this.adjustedTimestamp = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                type = this.adjustedTimestamp.getExpressionType();
                this.adjustedTimestampType = type instanceof SqmExpressable != false ? (SqmExpressable<Object>)type : expression.getLeftHandOperand().getNodeType();
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                try {
                    var6_6 = expression.getRightHandOperand().accept(this);
                    if (operator != BinaryArithmeticOperator.SUBTRACT) ** GOTO lbl21
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                catch (Throwable var7_8) {
                    if (operator == BinaryArithmeticOperator.SUBTRACT) {
                        this.negativeAdjustment = this.negativeAdjustment == false;
                    }
                    this.adjustedTimestamp = timestamp;
                    this.adjustedTimestampType = timestampType;
                    throw var7_8;
                }
lbl21:
                // 2 sources

                this.adjustedTimestamp = timestamp;
                this.adjustedTimestampType = timestampType;
                return var6_6;
            }
            case 3: {
                duration = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                scale = this.adjustmentScale;
                negate = this.negativeAdjustment;
                this.adjustmentScale = this.applyScale(duration);
                this.negativeAdjustment = false;
                try {
                    var9_11 = expression.getRightHandOperand().accept(this);
                    return var9_11;
                }
                finally {
                    this.adjustmentScale = scale;
                    this.negativeAdjustment = negate;
                }
            }
        }
        throw new SemanticException("illegal operator for a duration " + (Object)operator);
    }

    private Object transformDatetimeArithmetic(SqmBinaryArithmetic expression) {
        TemporalUnit baseUnit;
        BinaryArithmeticOperator operator = expression.getOperator();
        if (operator != BinaryArithmeticOperator.SUBTRACT) {
            throw new SemanticException("illegal operator for temporal type: " + (Object)((Object)operator));
        }
        Expression left = this.cleanly(() -> this.toSqlExpression(expression.getLeftHandOperand().accept(this)));
        Expression right = this.cleanly(() -> this.toSqlExpression(expression.getRightHandOperand().accept(this)));
        TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
        boolean leftTimestamp = typeConfiguration.isSqlTimestampType(expression.getLeftHandOperand().getNodeType());
        boolean rightTimestamp = typeConfiguration.isSqlTimestampType(expression.getRightHandOperand().getNodeType());
        TemporalUnit temporalUnit = baseUnit = rightTimestamp || leftTimestamp ? TemporalUnit.NATIVE : TemporalUnit.DAY;
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
            Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        if (this.appliedByUnit != null) {
            DurationUnit unit = (DurationUnit)this.appliedByUnit.getUnit().accept((SemanticQueryWalker<?>)this);
            return this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
        }
        DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)expression.getNodeType());
        Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
        return new Duration(scaledMagnitude, baseUnit, durationType);
    }

    private <J> BasicValuedMapping basicType(Class<J> javaType) {
        return this.creationContext.getDomainModel().getTypeConfiguration().getBasicTypeForJavaType(javaType);
    }

    private TimestampaddFunction timestampadd() {
        return (TimestampaddFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampadd");
    }

    private TimestampdiffFunction timestampdiff() {
        return (TimestampdiffFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampdiff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T cleanly(Supplier<T> supplier) {
        SqmByUnit byUnit = this.appliedByUnit;
        Expression timestamp = this.adjustedTimestamp;
        SqmExpressable<?> timestampType = this.adjustedTimestampType;
        Expression scale = this.adjustmentScale;
        boolean negate = this.negativeAdjustment;
        this.adjustmentScale = null;
        this.negativeAdjustment = false;
        this.appliedByUnit = null;
        this.adjustedTimestamp = null;
        this.adjustedTimestampType = null;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.appliedByUnit = byUnit;
            this.adjustedTimestamp = timestamp;
            this.adjustedTimestampType = timestampType;
            this.adjustmentScale = scale;
            this.negativeAdjustment = negate;
        }
    }

    Expression applyScale(Expression magnitude) {
        boolean negate = this.negativeAdjustment;
        if (magnitude instanceof UnaryOperation) {
            UnaryOperation unary = (UnaryOperation)magnitude;
            if (unary.getOperator() == UnaryArithmeticOperator.UNARY_MINUS) {
                negate = !negate;
            }
            magnitude = unary.getOperand();
        }
        if (this.adjustmentScale != null && !BaseSqmToSqlAstConverter.isOne(this.adjustmentScale)) {
            magnitude = BaseSqmToSqlAstConverter.isOne(magnitude) ? this.adjustmentScale : new BinaryArithmeticExpression(this.adjustmentScale, BinaryArithmeticOperator.MULTIPLY, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        if (negate) {
            magnitude = new UnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        return magnitude;
    }

    static boolean isOne(Expression scale) {
        return scale instanceof QueryLiteral && ((Number)((QueryLiteral)scale).getLiteralValue()).longValue() == 1L;
    }

    @Override
    public Object visitToDuration(SqmToDuration toDuration) {
        Expression magnitude = this.toSqlExpression(toDuration.getMagnitude().accept(this));
        DurationUnit unit = (DurationUnit)toDuration.getUnit().accept((SemanticQueryWalker<?>)this);
        Expression scaledMagnitude = this.applyScale(magnitude);
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)toDuration.getNodeType());
        Duration duration = new Duration(scaledMagnitude, unit.getUnit(), durationType);
        if (this.appliedByUnit != null) {
            TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
            BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
            return new Conversion(duration, appliedUnit, scalarType);
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitByUnit(SqmByUnit byUnit) {
        SqmByUnit outer = this.appliedByUnit;
        this.appliedByUnit = byUnit;
        try {
            Object object = byUnit.getDuration().accept(this);
            return object;
        }
        finally {
            this.appliedByUnit = outer;
        }
    }

    @Override
    public QuerySpec visitSubQueryExpression(SqmSubQuery sqmSubQuery) {
        return this.visitQuerySpec((SqmQuerySpec)sqmSubQuery.getQuerySpec());
    }

    @Override
    public CaseSimpleExpression visitSimpleCaseExpression(SqmCaseSimple<?, ?> expression) {
        SqmExpressable resultType = expression.getNodeType();
        ArrayList<CaseSimpleExpression.WhenFragment> whenFragments = new ArrayList<CaseSimpleExpression.WhenFragment>(expression.getWhenFragments().size());
        for (SqmCaseSimple.WhenFragment<?, ?> whenFragment : expression.getWhenFragments()) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, whenFragment.getResult().getNodeType());
            whenFragments.add(new CaseSimpleExpression.WhenFragment((Expression)whenFragment.getCheckValue().accept(this), (Expression)whenFragment.getResult().accept(this)));
        }
        Expression otherwise = null;
        if (expression.getOtherwise() != null) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, expression.getOtherwise().getNodeType());
            otherwise = (Expression)expression.getOtherwise().accept(this);
        }
        CaseSimpleExpression result = new CaseSimpleExpression(this.resolveMappingExpressable(resultType), (Expression)expression.getFixture().accept(this), whenFragments, otherwise);
        return result;
    }

    @Override
    public CaseSearchedExpression visitSearchedCaseExpression(SqmCaseSearched<?> expression) {
        SqmExpressable resultType = expression.getNodeType();
        ArrayList<CaseSearchedExpression.WhenFragment> whenFragments = new ArrayList<CaseSearchedExpression.WhenFragment>(expression.getWhenFragments().size());
        for (SqmCaseSearched.WhenFragment<?> whenFragment : expression.getWhenFragments()) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, whenFragment.getResult().getNodeType());
            whenFragments.add(new CaseSearchedExpression.WhenFragment((Predicate)whenFragment.getPredicate().accept(this), (Expression)whenFragment.getResult().accept(this)));
        }
        Expression otherwise = null;
        if (expression.getOtherwise() != null) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, expression.getOtherwise().getNodeType());
            otherwise = (Expression)expression.getOtherwise().accept(this);
        }
        CaseSearchedExpression result = new CaseSearchedExpression(this.resolveMappingExpressable(resultType), whenFragments, otherwise);
        return result;
    }

    @Override
    public Object visitAny(SqmAny<?> sqmAny) {
        return new Any(this.visitSubQueryExpression((SqmSubQuery)sqmAny.getSubquery()), null);
    }

    @Override
    public Object visitEvery(SqmEvery<?> sqmEvery) {
        return new Every(this.visitSubQueryExpression((SqmSubQuery)sqmEvery.getSubquery()), null);
    }

    @Override
    public Object visitEnumLiteral(SqmEnumLiteral sqmEnumLiteral) {
        return new QueryLiteral<Enum>(sqmEnumLiteral.getEnumValue(), (BasicValuedMapping)this.determineValueMapping(sqmEnumLiteral));
    }

    @Override
    public Object visitFieldLiteral(SqmFieldLiteral sqmFieldLiteral) {
        return new QueryLiteral(sqmFieldLiteral.getValue(), (BasicValuedMapping)this.determineValueMapping(sqmFieldLiteral));
    }

    @Override
    public GroupedPredicate visitGroupedPredicate(SqmGroupedPredicate predicate) {
        return new GroupedPredicate((Predicate)predicate.getSubPredicate().accept(this));
    }

    @Override
    public Junction visitAndPredicate(SqmAndPredicate predicate) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        conjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        conjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return conjunction;
    }

    @Override
    public Junction visitOrPredicate(SqmOrPredicate predicate) {
        Junction disjunction = new Junction(Junction.Nature.DISJUNCTION);
        disjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        disjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return disjunction;
    }

    @Override
    public NegatedPredicate visitNegatedPredicate(SqmNegatedPredicate predicate) {
        return new NegatedPredicate((Predicate)predicate.getWrappedPredicate().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
        Expression rhs;
        Expression lhs;
        this.inferableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getRightHandExpression()));
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getLeftHandExpression()));
        try {
            rhs = (Expression)predicate.getRightHandExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return new ComparisonPredicate(lhs, predicate.getSqmOperator(), rhs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BetweenPredicate visitBetweenPredicate(SqmBetweenPredicate predicate) {
        Expression upperBound;
        Expression lowerBound;
        Expression expression;
        this.inferableTypeAccessStack.push(() -> NullnessHelper.coalesce(this.determineValueMapping(predicate.getLowerBound()), this.determineValueMapping(predicate.getUpperBound())));
        try {
            expression = (Expression)predicate.getExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> NullnessHelper.coalesce(this.determineValueMapping(predicate.getExpression()), this.determineValueMapping(predicate.getUpperBound())));
        try {
            lowerBound = (Expression)predicate.getLowerBound().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> NullnessHelper.coalesce(this.determineValueMapping(predicate.getExpression()), this.determineValueMapping(predicate.getLowerBound())));
        try {
            upperBound = (Expression)predicate.getUpperBound().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return new BetweenPredicate(expression, lowerBound, upperBound, predicate.isNegated());
    }

    @Override
    public LikePredicate visitLikePredicate(SqmLikePredicate predicate) {
        Expression escapeExpression = predicate.getEscapeCharacter() == null ? null : (Expression)predicate.getEscapeCharacter().accept(this);
        return new LikePredicate((Expression)predicate.getMatchExpression().accept(this), (Expression)predicate.getPattern().accept(this), escapeExpression, predicate.isNegated());
    }

    @Override
    public NullnessPredicate visitIsNullPredicate(SqmNullnessPredicate predicate) {
        return new NullnessPredicate((Expression)predicate.getExpression().accept(this), predicate.isNegated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InListPredicate visitInListPredicate(SqmInListPredicate<?> predicate) {
        SqmParameter sqmParameter;
        QueryParameterImplementor<?> domainParam;
        QueryParameterBinding<?> domainParamBinding;
        SqmExpression<?> sqmExpression;
        if (predicate.getListExpressions().size() == 1 && (sqmExpression = predicate.getListExpressions().get(0)) instanceof SqmParameter && (domainParamBinding = this.domainParameterBindings.getBinding(domainParam = this.domainParameterXref.getQueryParameter(sqmParameter = (SqmParameter)sqmExpression))).isMultiValued()) {
            InListPredicate inListPredicate = new InListPredicate((Expression)predicate.getTestExpression().accept(this));
            this.inferableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getTestExpression()));
            try {
                boolean first = true;
                for (Object bindValue : domainParamBinding.getBindValues()) {
                    SqmParameter sqmParamToConsume;
                    if (first) {
                        sqmParamToConsume = sqmParameter;
                        first = false;
                    } else {
                        sqmParamToConsume = sqmParameter.copy();
                        this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                    }
                    inListPredicate.addExpression(this.consumeSqmParameter(sqmParamToConsume));
                }
            }
            finally {
                this.inferableTypeAccessStack.pop();
            }
            return inListPredicate;
        }
        InListPredicate inPredicate = new InListPredicate((Expression)predicate.getTestExpression().accept(this), predicate.isNegated());
        for (SqmExpression<?> expression : predicate.getListExpressions()) {
            inPredicate.addExpression((Expression)expression.accept(this));
        }
        return inPredicate;
    }

    @Override
    public InSubQueryPredicate visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
        return new InSubQueryPredicate((Expression)predicate.getTestExpression().accept(this), (QuerySpec)predicate.getSubQueryExpression().accept(this), predicate.isNegated());
    }

    @Override
    public Object visitExistsPredicate(SqmExistsPredicate predicate) {
        return new ExistsPredicate((QuerySpec)predicate.getExpression().accept(this));
    }

    protected static enum Shallowness {
        NONE,
        CTOR,
        FUNCTION,
        SUBQUERY;

    }
}

