/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.jboss.logging.Logger;

public class FromClauseIndex
extends SimpleFromClauseAccessImpl {
    private static final Logger log = Logger.getLogger(FromClauseIndex.class);
    private final Map<String, TableGroup> tableGroupByAliasXref = new HashMap<String, TableGroup>();
    private Map<String, SqmAttributeJoin> fetchesByPath;

    public void register(SqmPath<?> sqmPath, TableGroup tableGroup) {
        SqmAttributeJoin sqmJoin;
        TableGroup previousAliasReg;
        this.registerTableGroup(sqmPath.getNavigablePath(), tableGroup);
        if (sqmPath.getExplicitAlias() != null && (previousAliasReg = this.tableGroupByAliasXref.put(sqmPath.getExplicitAlias(), tableGroup)) != null) {
            log.debugf("Encountered previous TableGroup registration [%s] for alias : %s", (Object)previousAliasReg, (Object)sqmPath.getExplicitAlias());
        }
        if (sqmPath instanceof SqmAttributeJoin && (sqmJoin = (SqmAttributeJoin)sqmPath).isFetched()) {
            this.registerJoinFetch(sqmJoin);
        }
    }

    private void registerJoinFetch(SqmAttributeJoin sqmJoin) {
        if (this.fetchesByPath == null) {
            this.fetchesByPath = new HashMap<String, SqmAttributeJoin>();
        }
        NavigablePath navigablePath = sqmJoin.getNavigablePath();
        this.fetchesByPath.put(navigablePath.getIdentifierForTableGroup(), sqmJoin);
    }

    public boolean isResolved(SqmFrom fromElement) {
        return this.tableGroupMap.containsKey(fromElement.getNavigablePath());
    }

    public SqmAttributeJoin findFetchedJoinByPath(NavigablePath path) {
        return this.fetchesByPath == null ? null : this.fetchesByPath.get(path.getIdentifierForTableGroup());
    }
}

