/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.sql.internal.AssignableSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class BasicValuedPathInterpretation<T>
implements AssignableSqmPathInterpretation<T>,
DomainResultProducer<T> {
    private final ColumnReference columnReference;
    private final SqmBasicValuedSimplePath<T> sqmPath;
    private final BasicValuedModelPart mapping;
    private final TableGroup tableGroup;

    public static <T> BasicValuedPathInterpretation<T> from(SqmBasicValuedSimplePath<T> sqmPath, SqlAstCreationState sqlAstCreationState, SemanticQueryWalker sqmWalker) {
        ColumnReference columnReference;
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(sqmPath.getLhs().getNavigablePath());
        BasicValuedModelPart mapping = (BasicValuedModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        if (mapping == null) {
            throw new SemanticException("`" + sqmPath.getNavigablePath().getFullPath() + "` did not reference a known model part");
        }
        TableReference tableReference = tableGroup.resolveTableReference(mapping.getContainingTableExpression());
        Expression expression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, mapping.getMappedColumnExpression()), sacs -> new ColumnReference(tableReference.getIdentificationVariable(), mapping.getMappedColumnExpression(), mapping.getJdbcMapping(), sqlAstCreationState.getCreationContext().getSessionFactory()));
        if (expression instanceof ColumnReference) {
            columnReference = (ColumnReference)expression;
        } else if (expression instanceof SqlSelectionExpression) {
            Expression selectedExpression = ((SqlSelectionExpression)expression).getExpression();
            assert (selectedExpression instanceof ColumnReference);
            columnReference = (ColumnReference)selectedExpression;
        } else {
            throw new UnsupportedOperationException("Unsupported basic-valued path expression : " + expression);
        }
        return new BasicValuedPathInterpretation<T>(columnReference, sqmPath, mapping, tableGroup);
    }

    private BasicValuedPathInterpretation(ColumnReference columnReference, SqmBasicValuedSimplePath<T> sqmPath, BasicValuedModelPart mapping, TableGroup tableGroup) {
        assert (columnReference != null);
        this.columnReference = columnReference;
        assert (sqmPath != null);
        this.sqmPath = sqmPath;
        assert (mapping != null);
        this.mapping = mapping;
        assert (tableGroup != null);
        this.tableGroup = tableGroup;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.sqmPath.getNavigablePath();
    }

    @Override
    public ModelPart getExpressionType() {
        return this.mapping;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.mapping.createDomainResult(this.getNavigablePath(), this.tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.mapping.applySqlSelections(this.getNavigablePath(), this.tableGroup, creationState);
    }

    @Override
    public void applySqlAssignments(Expression newValueExpression, AssignableSqmPathInterpretation.AssignmentContext assignmentProcessingState, Consumer<Assignment> assignmentConsumer, SqlAstCreationContext creationContext) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.columnReference.accept(sqlTreeWalker);
    }

    public String toString() {
        return "BasicValuedPathInterpretation(" + this.sqmPath.getNavigablePath().getFullPath() + ')';
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this.columnReference);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this.columnReference);
    }
}

