/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AssignableSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class EmbeddableValuedPathInterpretation<T>
implements AssignableSqmPathInterpretation<T> {
    private final Expression sqlExpression;
    private final SqmEmbeddedValuedSimplePath<T> sqmPath;
    private final EmbeddableValuedModelPart mapping;
    private final TableGroup tableGroup;

    public static <T> EmbeddableValuedPathInterpretation<T> from(SqmEmbeddedValuedSimplePath<T> sqmPath, SqmToSqlAstConverter converter, SemanticQueryWalker sqmWalker) {
        TableGroup tableGroup = converter.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        EmbeddableValuedModelPart mapping = (EmbeddableValuedModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        return new EmbeddableValuedPathInterpretation<T>(mapping.toSqlExpression(tableGroup, converter.getCurrentClauseStack().getCurrent(), converter, converter), sqmPath, mapping, tableGroup);
    }

    public EmbeddableValuedPathInterpretation(Expression sqlExpression, SqmEmbeddedValuedSimplePath<T> sqmPath, EmbeddableValuedModelPart mapping, TableGroup tableGroup) {
        this.sqlExpression = sqlExpression;
        this.sqmPath = sqmPath;
        this.mapping = mapping;
        this.tableGroup = tableGroup;
    }

    public Expression getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.sqmPath.getNavigablePath();
    }

    @Override
    public ModelPart getExpressionType() {
        return this.mapping;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.mapping.createDomainResult(this.getNavigablePath(), this.tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.mapping.applySqlSelections(this.getNavigablePath(), this.tableGroup, creationState);
    }

    @Override
    public void applySqlAssignments(Expression newValueExpression, AssignableSqmPathInterpretation.AssignmentContext assignmentProcessingState, Consumer<Assignment> assignmentConsumer, SqlAstCreationContext creationContext) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public String toString() {
        return "EmbeddableValuedPathInterpretation(" + this.sqmPath.getNavigablePath().getFullPath() + ')';
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        if (this.sqlExpression instanceof ColumnReference) {
            columnReferenceConsumer.accept((ColumnReference)this.sqlExpression);
        } else if (this.sqlExpression instanceof SqlTuple) {
            SqlTuple sqlTuple = (SqlTuple)this.sqlExpression;
            for (Expression expression : sqlTuple.getExpressions()) {
                if (!(expression instanceof ColumnReference)) {
                    throw new IllegalArgumentException("Expecting ColumnReference, found : " + expression);
                }
                columnReferenceConsumer.accept((ColumnReference)expression);
            }
        }
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        ArrayList<ColumnReference> results = new ArrayList<ColumnReference>();
        this.visitColumnReferences(results::add);
        return results;
    }
}

