/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class EntityValuedPathInterpretation<T>
implements SqmPathInterpretation<T> {
    private EntityValuedModelPart mapping = null;
    private TableGroup tableGroup = null;
    private SqmEntityValuedSimplePath sqmPath = null;

    public static <T> EntityValuedPathInterpretation<T> from(SqmEntityValuedSimplePath<T> sqmPath, SqlAstCreationState sqlAstCreationState) {
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        EntityValuedModelPart mapping = (EntityValuedModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        return new EntityValuedPathInterpretation<T>(sqmPath, tableGroup, mapping);
    }

    private EntityValuedPathInterpretation(SqmEntityValuedSimplePath sqmPath, TableGroup tableGroup, EntityValuedModelPart mapping) {
        this.tableGroup = tableGroup;
        this.mapping = mapping;
        this.sqmPath = sqmPath;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.mapping.createDomainResult(this.getNavigablePath(), this.tableGroup, resultVariable, creationState);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.sqmPath.getNavigablePath();
    }

    @Override
    public ModelPart getExpressionType() {
        return this.mapping;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
    }
}

