/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.SimpleSqmDeleteTranslation;
import org.hibernate.query.sqm.sql.SimpleSqmDeleteTranslator;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.JdbcDelete;

public class StandardSqmDeleteTranslator
extends BaseSqmToSqlAstConverter
implements SimpleSqmDeleteTranslator {
    public static JdbcDelete translate(SqmDeleteStatement statement, SessionFactoryImplementor factory) {
        return null;
    }

    public StandardSqmDeleteTranslator(SqlAstCreationContext creationContext, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext, queryOptions, domainParameterXref, domainParameterBindings);
    }

    @Override
    public SimpleSqmDeleteTranslation translate(SqmDeleteStatement statement) {
        SqlAstProcessingStateImpl processingState = new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent);
        this.getProcessingStateStack().push(processingState);
        DeleteStatement deleteStatement = this.visitDeleteStatement(statement);
        return new SimpleSqmDeleteTranslation(deleteStatement, this.getJdbcParamsBySqmParam(), processingState.getSqlExpressionResolver(), this.getFromClauseAccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStatement visitDeleteStatement(SqmDeleteStatement statement) {
        String entityName = ((SqmRoot)statement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, statement.getRoot().getAlias(), false, LockMode.WRITE, stem -> this.getSqlAliasBaseGenerator().createSqlAliasBase(stem), this.getSqlExpressionResolver(), () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this.getCreationContext());
            this.getFromClauseIndex().registerTableGroup(rootPath, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM DELETE");
            }
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = statement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            DeleteStatement deleteStatement = new DeleteStatement(rootTableGroup.getPrimaryTableReference(), SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions));
            return deleteStatement;
        }
        finally {
            this.getProcessingStateStack().pop();
        }
    }

    @Override
    public CteStatement translate(SqmCteStatement sqmCte) {
        this.visitCteStatement(sqmCte);
        return null;
    }
}

